/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.core;

import jp.sourceforge.jeextension.styleeditor.core.ColorManager;
import jp.sourceforge.jeextension.styleeditor.core.DoubleClickStrategy;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.core.StyleEditor;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntryList;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

class EditorConfiguration
extends SourceViewerConfiguration {
    private DoubleClickStrategy fDoubleClickStrategy;
    private EditorTools fEditorTools;
    private StyleEditor fStyleEditor;

    EditorConfiguration(StyleEditor styleEditor) {
        this.fStyleEditor = styleEditor;
        this.fEditorTools = new EditorTools(styleEditor);
    }

    public ColorManager getColorManager() {
        return this.fStyleEditor.getColorManager();
    }

    public EditorTools getEditorTools() {
        return this.fEditorTools;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return EditorTools.getContentTypes(this.fStyleEditor.getFileExtension());
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new DoubleClickStrategy();
        }
        return this.fDoubleClickStrategy;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        String ext = this.fStyleEditor.getFileExtension();
        EditorTools tools = this.fEditorTools;
        PartitionEntryList list = EditorTools.getPartitionEntryList(ext, false);
        int i = 0;
        while (i < list.size()) {
            IPartitionEntry pe = list.getPartitionEntry(i);
            String partName = pe.getName();
            RuleBasedScanner scanner = tools.createScanner(partName, ext);
            scanner.setDefaultReturnToken(tools.getDefaultToken(pe));
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
            reconciler.setDamager((IPresentationDamager)dr, partName);
            reconciler.setRepairer((IPresentationRepairer)dr, partName);
            ++i;
        }
        return reconciler;
    }
}

