/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.core;

import jp.sourceforge.jeextension.styleeditor.StyleEditorPlugin;
import jp.sourceforge.jeextension.styleeditor.core.ColorManager;
import jp.sourceforge.jeextension.styleeditor.core.DocumentProvider;
import jp.sourceforge.jeextension.styleeditor.core.EditorConfiguration;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class StyleEditor
extends TextEditor
implements IPropertyChangeListener {
    private ColorManager fColorManager = new ColorManager();

    public StyleEditor() {
        EditorConfiguration editorConf = new EditorConfiguration(this);
        DocumentProvider provider = new DocumentProvider(editorConf);
        this.setSourceViewerConfiguration(editorConf);
        this.setDocumentProvider((IDocumentProvider)provider);
    }

    public String getFileExtension() {
        IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
        return input.getFile().getFileExtension();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        String ext = this.getFileExtension();
        Font font = EditorTools.getFont(ext);
        this.getSourceViewer().getTextWidget().setFont(font);
    }

    protected void setPreferenceStore(IPreferenceStore store) {
        IPreferenceStore prefStore = StyleEditorPlugin.getDefault().getPreferenceStore();
        prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        super.setPreferenceStore(store);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String ext = this.getFileExtension();
        Font font = EditorTools.getFont(ext);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer != null) {
            sourceViewer.getTextWidget().setFont(font);
        }
        if (sourceViewer instanceof ISourceViewerExtension2) {
            ((ISourceViewerExtension2)sourceViewer).unconfigure();
            sourceViewer.configure(this.getSourceViewerConfiguration());
        }
        if (this.getDocumentProvider() != null) {
            try {
                super.doSetInput(this.getEditorInput());
            }
            catch (Throwable e) {
                StyleEditorPlugin.log(e);
            }
        }
    }

    ColorManager getColorManager() {
        return this.fColorManager;
    }

    public void dispose() {
        this.fColorManager.dispose();
        super.dispose();
    }
}

