/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import jp.sourceforge.jeextension.styleeditor.StyleEditorPlugin;
import org.eclipse.jface.text.rules.IWordDetector;

class WordDetector
implements IWordDetector {
    private char[] fParts = new char[20];
    private char[] fStarts = new char[20];

    WordDetector() {
        URL url = StyleEditorPlugin.getDefault().getBundle().getEntry("/");
        try {
            this.load(new URL(url + "symbols-part.txt"), this.fParts);
            this.load(new URL(url + "symbols-start.txt"), this.fStarts);
        }
        catch (MalformedURLException e) {
            StyleEditorPlugin.log(e);
        }
    }

    public boolean isWordPart(char c) {
        return this.isContains(c, this.fParts);
    }

    public boolean isWordStart(char c) {
        return this.isContains(c, this.fStarts);
    }

    private boolean isContains(char c, char[] symbols) {
        if (Character.isLetter(c)) {
            return true;
        }
        int i = 0;
        while (i < symbols.length) {
            if (symbols[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void load(URL url, char[] symbols) {
        try {
            InputStream in = url.openStream();
            int i = 0;
            while (i < symbols.length) {
                int ch = in.read();
                if (ch != -1) {
                    symbols[i] = (char)ch;
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.fParts = new char[0];
            StyleEditorPlugin.log(e);
        }
    }
}

