/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.entry;

import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.IDependsEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.text.IExtRule;
import org.eclipse.swt.graphics.RGB;

public class DependsEntry
implements IDependsEntry {
    private String fName = "";
    private IPartitionEntry fPartitionEntry;
    private RGB fRGB = new RGB(0, 0, 0);
    private RGB fBgRGB = new RGB(255, 255, 255);
    private boolean fBgColor = false;
    private boolean fItalic = false;
    private boolean fBold = false;
    private boolean fStrikeThrough = false;
    private boolean fUnderline = false;
    private IExtRule fRule;

    public DependsEntry() {
    }

    public DependsEntry(XMLNode node, String ext) {
        this.fPartitionEntry = EditorTools.getPartitionEntry(node.getParentNode().getAttribute("name"), ext, true);
        this.fName = node.getNodeName();
        this.fRGB.red = Integer.parseInt(node.getAttribute("red"));
        this.fRGB.green = Integer.parseInt(node.getAttribute("green"));
        this.fRGB.blue = Integer.parseInt(node.getAttribute("blue"));
        this.fBgColor = Boolean.valueOf(node.getAttribute("bgcolor"));
        if (this.fBgColor) {
            this.fBgRGB.red = Integer.parseInt(node.getAttribute("bred"));
            this.fBgRGB.green = Integer.parseInt(node.getAttribute("bgreen"));
            this.fBgRGB.blue = Integer.parseInt(node.getAttribute("bblue"));
        }
        this.fItalic = Boolean.valueOf(node.getAttribute("italic"));
        this.fBold = Boolean.valueOf(node.getAttribute("bold"));
        this.fStrikeThrough = Boolean.valueOf(node.getAttribute("strikethrough"));
        this.fUnderline = Boolean.valueOf(node.getAttribute("underline"));
        this.fRule = EditorTools.createExtRule(node, ext);
    }

    public XMLNode createNode() {
        XMLNode xmlNode = new XMLNode(this.fName);
        xmlNode.setAttribute("red", String.valueOf(this.fRGB.red));
        xmlNode.setAttribute("green", String.valueOf(this.fRGB.green));
        xmlNode.setAttribute("blue", String.valueOf(this.fRGB.blue));
        if (this.fBgColor) {
            xmlNode.setAttribute("bgcolor", "true");
            xmlNode.setAttribute("bred", String.valueOf(this.fBgRGB.red));
            xmlNode.setAttribute("bgreen", String.valueOf(this.fBgRGB.green));
            xmlNode.setAttribute("bblue", String.valueOf(this.fBgRGB.blue));
        } else {
            xmlNode.setAttribute("bgcolor", "false");
            xmlNode.setAttribute("bred", "");
            xmlNode.setAttribute("bgreen", "");
            xmlNode.setAttribute("bblue", "");
        }
        xmlNode.setAttribute("italic", String.valueOf(this.fItalic));
        xmlNode.setAttribute("bold", String.valueOf(this.fBold));
        xmlNode.setAttribute("strikethrough", String.valueOf(this.fStrikeThrough));
        xmlNode.setAttribute("underline", String.valueOf(this.fUnderline));
        if (this.fName.equals("multiLine")) {
            xmlNode.setAttribute("start", this.fRule.getWords()[0]);
            xmlNode.setAttribute("end", this.fRule.getWords()[1]);
        }
        if (this.fName.equals("singleLine")) {
            xmlNode.setAttribute("start", this.fRule.getWords()[0]);
            xmlNode.setAttribute("end", this.fRule.getWords()[1]);
        }
        if (this.fName.equals("endOfLine")) {
            xmlNode.setAttribute("start", this.fRule.getWords()[0]);
        }
        if (this.fName.equals("keyword")) {
            xmlNode.setAttribute("word", this.fRule.getWords()[0]);
            xmlNode.setAttribute("case", this.fRule.getWords()[1]);
        }
        if (this.fName.equals("regexp")) {
            xmlNode.setAttribute("regexp", this.fRule.getWords()[0]);
        }
        return xmlNode;
    }

    public IPartitionEntry getDepends() {
        return this.fPartitionEntry;
    }

    public String getName() {
        return this.fName;
    }

    public RGB getRGB() {
        return this.fRGB;
    }

    public IExtRule getRule() {
        return this.fRule;
    }

    public String[] getWords() {
        return this.fRule.getWords();
    }

    public void setDepends(IPartitionEntry depends) {
        this.fPartitionEntry = depends;
    }

    public void setRGB(RGB pRGB) {
        this.fRGB = pRGB;
    }

    public void setRule(IExtRule rule) {
        this.fRule = rule;
    }

    public void setWords(String[] words) {
        this.fRule.setWords(words);
    }

    public RGB getBgRGB() {
        return this.fBgRGB;
    }

    public boolean isBgColor() {
        return this.fBgColor;
    }

    public boolean isBold() {
        return this.fBold;
    }

    public boolean isItalic() {
        return this.fItalic;
    }

    public boolean isStrikeThrough() {
        return this.fStrikeThrough;
    }

    public boolean isUnderline() {
        return this.fUnderline;
    }

    public void setBgColor(boolean b) {
        this.fBgColor = b;
    }

    public void setBgRGB(RGB rgb) {
        this.fBgRGB = rgb;
    }

    public void setBold(boolean b) {
        this.fBold = b;
    }

    public void setItalic(boolean b) {
        this.fItalic = b;
    }

    public void setStrikeThrough(boolean b) {
        this.fStrikeThrough = b;
    }

    public void setUnderline(boolean b) {
        this.fUnderline = b;
    }
}

