/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.preferences;

import jp.sourceforge.jeextension.common.plugin.DefaultDialog;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.DependsEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IDependsEntry;
import jp.sourceforge.jeextension.styleeditor.text.IExtRule;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class AddDependsDialog
extends DefaultDialog {
    private ColorSelector fColorSel;
    private ColorSelector fColorBgc;
    private Label fLabelEnd;
    private Label fLabelKwd;
    private Label fLabelStr;
    private Label fLabelBgc;
    private String fParitionName;
    private Button fRadioMlt;
    private Button fRadioEnd;
    private Button fRadioKwd;
    private Button fRadioSgl;
    private Button fRadioReg;
    private Button fCheckGbc;
    private Button fCheckIta;
    private Button fCheckBol;
    private Button fCheckStr;
    private Button fCheckUnd;
    private IDependsEntry[] fStyleContainer;
    private IDependsEntry fStyleEntry;
    private Text fTextEnd;
    private Text fTextKwd;
    private Text fTextStr;
    private Button fCheckCase;
    private String fExtension;

    AddDependsDialog(Shell shell, IDependsEntry[] container, String part, String ext) {
        super(shell);
        this.fStyleEntry = container[0];
        this.fStyleContainer = container;
        this.fParitionName = part;
        this.fExtension = ext;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.fRadioSgl || event.widget == this.fRadioMlt) {
            this.fLabelStr.setEnabled(true);
            this.fLabelEnd.setEnabled(true);
            this.fLabelKwd.setEnabled(false);
            this.fTextStr.setEnabled(true);
            this.fTextEnd.setEnabled(true);
            this.fTextKwd.setEnabled(false);
            this.fCheckCase.setEnabled(false);
        }
        if (event.widget == this.fRadioEnd) {
            this.fLabelStr.setEnabled(true);
            this.fLabelEnd.setEnabled(false);
            this.fLabelKwd.setEnabled(false);
            this.fTextStr.setEnabled(true);
            this.fTextEnd.setEnabled(false);
            this.fTextKwd.setEnabled(false);
            this.fCheckCase.setEnabled(false);
        }
        if (event.widget == this.fRadioKwd) {
            this.fLabelStr.setEnabled(false);
            this.fLabelEnd.setEnabled(false);
            this.fLabelKwd.setEnabled(true);
            this.fTextStr.setEnabled(false);
            this.fTextEnd.setEnabled(false);
            this.fTextKwd.setEnabled(true);
            this.fCheckCase.setEnabled(true);
        }
        if (event.widget == this.fRadioReg) {
            this.fLabelStr.setEnabled(false);
            this.fLabelEnd.setEnabled(false);
            this.fLabelKwd.setEnabled(true);
            this.fTextStr.setEnabled(false);
            this.fTextEnd.setEnabled(false);
            this.fTextKwd.setEnabled(true);
            this.fCheckCase.setEnabled(false);
        }
        if (event.widget == this.fCheckGbc) {
            if (this.fCheckGbc.getSelection()) {
                this.fColorBgc.setEnabled(true);
                this.fLabelBgc.setEnabled(true);
            } else {
                this.fColorBgc.setEnabled(false);
                this.fLabelBgc.setEnabled(false);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.verticalSpan = 5;
        label.setLayoutData((Object)gridData);
        label.setText(this.getMessage("pref.depends.dlg.radio.label"));
        this.fRadioMlt = new Button(composite, 16);
        this.fRadioMlt.setText(this.getMessage("pref.depends.dlg.radio.multline"));
        this.fRadioMlt.addListener(13, (Listener)this);
        this.fRadioEnd = new Button(composite, 16);
        this.fRadioEnd.setText(this.getMessage("pref.depends.dlg.radio.endofline"));
        this.fRadioEnd.addListener(13, (Listener)this);
        this.fRadioSgl = new Button(composite, 16);
        this.fRadioSgl.setText(this.getMessage("pref.depends.dlg.radio.singleline"));
        this.fRadioSgl.addListener(13, (Listener)this);
        this.fRadioKwd = new Button(composite, 16);
        this.fRadioKwd.setText(this.getMessage("pref.depends.dlg.radio.keyword"));
        this.fRadioKwd.addListener(13, (Listener)this);
        this.fRadioReg = new Button(composite, 16);
        this.fRadioReg.setText(this.getMessage("pref.depends.dlg.radio.regexp"));
        this.fRadioReg.addListener(13, (Listener)this);
        Composite subComposite = new Composite(composite, 0);
        GridData gridData2 = new GridData(1808);
        gridData2.horizontalSpan = 2;
        subComposite.setLayoutData((Object)gridData2);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        subComposite.setLayout((Layout)gridLayout2);
        this.fLabelStr = new Label(subComposite, 0);
        this.fLabelStr.setText(this.getMessage("pref.depends.dlg.start"));
        this.fTextStr = new Text(subComposite, 2048);
        this.fTextStr.setLayoutData((Object)new GridData(768));
        this.fLabelEnd = new Label(subComposite, 0);
        this.fLabelEnd.setText(this.getMessage("pref.depends.dlg.end"));
        this.fTextEnd = new Text(subComposite, 2048);
        this.fTextEnd.setLayoutData((Object)new GridData(768));
        this.fLabelKwd = new Label(subComposite, 0);
        this.fLabelKwd.setText(this.getMessage("pref.depends.dlg.keyword"));
        this.fTextKwd = new Text(subComposite, 2048);
        this.fTextKwd.setLayoutData((Object)new GridData(768));
        Label cLabelClr = new Label(subComposite, 0);
        cLabelClr.setText(this.getMessage("pref.depends.dlg.color"));
        this.fColorSel = new ColorSelector(subComposite);
        this.fColorSel.setColorValue(new RGB(0, 0, 0));
        this.fLabelBgc = new Label(subComposite, 0);
        this.fLabelBgc.setText(this.getMessage("pref.depends.dlg.bgcolor"));
        this.fColorBgc = new ColorSelector(subComposite);
        this.fColorBgc.setColorValue(new RGB(255, 255, 255));
        this.fColorBgc.setEnabled(false);
        GridData gridData22 = new GridData();
        gridData22.horizontalSpan = 2;
        this.fCheckGbc = new Button(subComposite, 32);
        this.fCheckGbc.setText(this.getMessage("pref.depends.dlg.usebgcolor"));
        this.fCheckGbc.addListener(13, (Listener)this);
        this.fCheckGbc.setLayoutData((Object)gridData22);
        this.fCheckIta = new Button(subComposite, 32);
        this.fCheckIta.setText(this.getMessage("pref.depends.dlg.italic"));
        this.fCheckIta.addListener(13, (Listener)this);
        this.fCheckBol = new Button(subComposite, 32);
        this.fCheckBol.setText(this.getMessage("pref.depends.dlg.bold"));
        this.fCheckBol.addListener(13, (Listener)this);
        this.fCheckStr = new Button(subComposite, 32);
        this.fCheckStr.setText(this.getMessage("pref.depends.dlg.strikethrough"));
        this.fCheckStr.addListener(13, (Listener)this);
        this.fCheckUnd = new Button(subComposite, 32);
        this.fCheckUnd.setText(this.getMessage("pref.depends.dlg.underline"));
        this.fCheckUnd.addListener(13, (Listener)this);
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 2;
        this.fCheckCase = new Button(subComposite, 32);
        this.fCheckCase.setText(this.getMessage("pref.depends.dlg.case"));
        this.fCheckCase.setSelection(true);
        this.fCheckCase.setLayoutData((Object)gridData3);
        this.executeInitEvent();
        return composite;
    }

    private void executeInitEvent() {
        Event event = new Event();
        if (this.fStyleEntry != null) {
            IExtRule rule = this.fStyleEntry.getRule();
            if (this.fStyleEntry.getName().equals("keyword")) {
                this.fTextKwd.setText(rule.getWords()[0]);
                String sensitive = rule.getWords()[1];
                this.fCheckCase.setSelection(Boolean.valueOf(sensitive).booleanValue());
                this.fRadioMlt.setEnabled(false);
                this.fRadioKwd.setSelection(true);
                this.fRadioSgl.setEnabled(false);
                this.fRadioEnd.setEnabled(false);
                this.fRadioReg.setEnabled(false);
                event.widget = this.fRadioKwd;
            }
            if (this.fStyleEntry.getName().equals("endOfLine")) {
                this.fTextStr.setText(rule.getWords()[0]);
                this.fRadioMlt.setEnabled(false);
                this.fRadioEnd.setSelection(true);
                this.fRadioSgl.setEnabled(false);
                this.fRadioKwd.setEnabled(false);
                this.fRadioReg.setEnabled(false);
                this.fCheckCase.setEnabled(false);
                event.widget = this.fRadioEnd;
            }
            if (this.fStyleEntry.getName().equals("singleLine")) {
                this.fTextStr.setText(rule.getWords()[0]);
                this.fTextEnd.setText(rule.getWords()[1]);
                this.fRadioMlt.setEnabled(false);
                this.fRadioSgl.setSelection(true);
                this.fRadioEnd.setEnabled(false);
                this.fRadioKwd.setEnabled(false);
                this.fRadioReg.setEnabled(false);
                this.fCheckCase.setEnabled(false);
                event.widget = this.fRadioSgl;
            }
            if (this.fStyleEntry.getName().equals("multiLine")) {
                this.fTextStr.setText(rule.getWords()[0]);
                this.fTextEnd.setText(rule.getWords()[1]);
                this.fRadioMlt.setSelection(true);
                this.fRadioSgl.setEnabled(false);
                this.fRadioEnd.setEnabled(false);
                this.fRadioKwd.setEnabled(false);
                this.fRadioReg.setEnabled(false);
                this.fCheckCase.setEnabled(false);
                event.widget = this.fRadioMlt;
            }
            if (this.fStyleEntry.getName().equals("regexp")) {
                this.fTextKwd.setText(rule.getWords()[0]);
                this.fRadioMlt.setEnabled(false);
                this.fRadioSgl.setEnabled(false);
                this.fRadioEnd.setEnabled(false);
                this.fRadioKwd.setEnabled(false);
                this.fRadioReg.setSelection(true);
                this.fCheckCase.setEnabled(false);
                event.widget = this.fRadioReg;
            }
            this.fColorSel.setColorValue(this.fStyleEntry.getRGB());
            if (this.fStyleEntry.isBgColor()) {
                this.fColorBgc.setColorValue(this.fStyleEntry.getBgRGB());
                this.fCheckGbc.setSelection(true);
                this.fColorBgc.setEnabled(true);
                this.fLabelBgc.setEnabled(true);
            } else {
                this.fColorBgc.setEnabled(false);
                this.fLabelBgc.setEnabled(false);
            }
            if (this.fStyleEntry.isItalic()) {
                this.fCheckIta.setSelection(true);
            }
            if (this.fStyleEntry.isBold()) {
                this.fCheckBol.setSelection(true);
            }
            if (this.fStyleEntry.isStrikeThrough()) {
                this.fCheckStr.setSelection(true);
            }
            if (this.fStyleEntry.isUnderline()) {
                this.fCheckUnd.setSelection(true);
            }
        } else {
            this.fRadioKwd.setSelection(true);
            event.widget = this.fRadioKwd;
        }
        this.handleEvent(event);
    }

    protected void okPressed() {
        String detected;
        if (this.fRadioReg.getSelection() && (detected = EditorTools.checkRegExp(this.fTextKwd.getText())) != null) {
            MessageBox mb = new MessageBox(this.getShell());
            mb.setMessage(String.valueOf(detected) + " " + this.getMessage("pref.err.regexp"));
            mb.open();
            return;
        }
        XMLNode parent = new XMLNode("partition");
        parent.setAttribute("name", this.fParitionName);
        XMLNode node = null;
        RGB rgb = this.fColorSel.getColorValue();
        if (this.fRadioKwd.getSelection()) {
            node = new XMLNode("keyword");
            node.setAttribute("word", this.fTextKwd.getText());
            node.setAttribute("case", String.valueOf(this.fCheckCase.getSelection()));
        }
        if (this.fRadioMlt.getSelection()) {
            node = new XMLNode("multiLine");
            node.setAttribute("start", this.fTextStr.getText());
            node.setAttribute("end", this.fTextEnd.getText());
        }
        if (this.fRadioSgl.getSelection()) {
            node = new XMLNode("singleLine");
            node.setAttribute("start", this.fTextStr.getText());
            node.setAttribute("end", this.fTextEnd.getText());
        }
        if (this.fRadioEnd.getSelection()) {
            node = new XMLNode("endOfLine");
            node.setAttribute("start", this.fTextStr.getText());
        }
        if (this.fRadioReg.getSelection()) {
            node = new XMLNode("regexp");
            node.setAttribute("regexp", this.fTextKwd.getText());
        }
        node.setAttribute("red", String.valueOf(rgb.red));
        node.setAttribute("green", String.valueOf(rgb.green));
        node.setAttribute("blue", String.valueOf(rgb.blue));
        if (this.fCheckGbc.getSelection()) {
            RGB brgb = this.fColorBgc.getColorValue();
            node.setAttribute("bgcolor", "true");
            node.setAttribute("bred", String.valueOf(brgb.red));
            node.setAttribute("bgreen", String.valueOf(brgb.green));
            node.setAttribute("bblue", String.valueOf(brgb.blue));
        } else {
            node.setAttribute("bgcolor", "false");
            node.setAttribute("bred", "");
            node.setAttribute("bgreen", "");
            node.setAttribute("bblue", "");
        }
        node.setAttribute("italic", String.valueOf(this.fCheckIta.getSelection()));
        node.setAttribute("bold", String.valueOf(this.fCheckBol.getSelection()));
        node.setAttribute("strikethrough", String.valueOf(this.fCheckStr.getSelection()));
        node.setAttribute("underline", String.valueOf(this.fCheckUnd.getSelection()));
        parent.addChild(node);
        if (this.fStyleEntry == null) {
            this.fStyleEntry = new DependsEntry(node, this.fExtension);
        } else {
            EditorTools.changeDependsEntry(this.fStyleEntry, node, this.fExtension);
        }
        this.fStyleContainer[0] = this.fStyleEntry;
        super.okPressed();
    }
}

