/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.preferences;

import jp.sourceforge.jeextension.common.plugin.DefaultDialog;
import jp.sourceforge.jeextension.styleeditor.StyleEditorPlugin;
import jp.sourceforge.jeextension.styleeditor.core.ColorManager;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.DefinedStyleEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntryList;
import jp.sourceforge.jeextension.styleeditor.preferences.AddPartitionDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class PartitionEntryDialog
extends DefaultDialog {
    private Button fButtonAdd;
    private Button fButtonDel;
    private Button fButtonDn;
    private Button fButtonMod;
    private Button fButtonUp;
    private ColorManager fColorManager = new ColorManager();
    private Table fTable;
    private String fExtension;

    PartitionEntryDialog(Shell shell, String ext) {
        super(shell);
        this.fExtension = ext;
    }

    public boolean close() {
        this.fColorManager.dispose();
        return super.close();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.fButtonAdd) {
            this.fireAddEntry();
        }
        if (event.widget == this.fButtonMod) {
            this.fireModifyEntry();
        }
        if (event.widget == this.fButtonDel) {
            this.fireDeleteEntry();
        }
        if (event.widget == this.fButtonUp) {
            this.fireMoveUpEntry();
        }
        if (event.widget == this.fButtonDn) {
            this.fireMoveDownEntry();
        }
    }

    private void addTableItem(IPartitionEntry entry) {
        TableItem item = new TableItem(this.fTable, 0);
        String partName = entry.getName();
        if (partName.equals("__dftl_partition_content_type")) {
            item.setText(0, this.getMessage("pref.partition.dlg.base"));
        } else {
            item.setText(0, partName);
        }
        if (entry instanceof PartitionEntry) {
            PartitionEntry pe = (PartitionEntry)entry;
            item.setText(1, pe.getView());
        }
        item.setData((Object)entry);
        item.setForeground(this.fColorManager.getColor(entry.getRGB()));
        if (entry.isBgColor()) {
            item.setBackground(this.fColorManager.getColor(entry.getBgRGB()));
        }
    }

    private Button createButton(Composite composite, String str) {
        Button button = new Button(composite, 0);
        button.setLayoutData((Object)new GridData(258));
        button.setText(str);
        button.addListener(13, (Listener)this);
        return button;
    }

    private TableColumn createTableColumn(Table table, String str) {
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(100);
        tableColumn.setText(str);
        return tableColumn;
    }

    private void fireAddEntry() {
        IPartitionEntry[] container = new IPartitionEntry[1];
        AddPartitionDialog d = new AddPartitionDialog(this.getShell(), container, this.fExtension);
        if (d.open() == 0) {
            this.addTableItem(container[0]);
            DefinedStyleEntry styleEntry = StyleEditorPlugin.getDefinedStyleEntry();
            styleEntry.add(container[0], this.fExtension);
        }
    }

    private void fireDeleteEntry() {
        int sel = this.fTable.getSelectionIndex();
        if (sel < 0) {
            return;
        }
        TableItem item = this.fTable.getItem(sel);
        IPartitionEntry entry = (IPartitionEntry)item.getData();
        this.fTable.remove(sel);
        StyleEditorPlugin.getDefinedStyleEntry().remove(entry, this.fExtension);
    }

    private void fireModifyEntry() {
        int sel = this.fTable.getSelectionIndex();
        if (sel < 0) {
            return;
        }
        TableItem item = this.fTable.getItem(sel);
        IPartitionEntry entry = (IPartitionEntry)item.getData();
        IPartitionEntry[] container = new IPartitionEntry[]{entry};
        AddPartitionDialog d = new AddPartitionDialog(this.getShell(), container, this.fExtension);
        if (d.open() == 0) {
            if (entry.getName().equals("__dftl_partition_content_type")) {
                item.setText(0, this.getMessage("pref.partition.dlg.base"));
            } else {
                item.setText(0, entry.getName());
            }
            if (entry instanceof PartitionEntry) {
                PartitionEntry pe = (PartitionEntry)entry;
                item.setText(1, pe.getView());
            }
            item.setData((Object)entry);
            item.setForeground(this.fColorManager.getColor(entry.getRGB()));
            if (entry.isBgColor()) {
                item.setBackground(this.fColorManager.getColor(entry.getBgRGB()));
            }
        }
    }

    private void fireMoveDownEntry() {
        this.fireMoveEntry(1);
    }

    private void fireMoveUpEntry() {
        this.fireMoveEntry(-1);
    }

    private void fireMoveEntry(int increment) {
        int sel = this.fTable.getSelectionIndex();
        if (sel < 0) {
            return;
        }
        Object obj = this.fTable.getSelection()[0].getData();
        PartitionEntryList list = EditorTools.getPartitionEntryList(this.fExtension, false);
        int index = list.indexOf(obj);
        Object removeObj = list.remove(index);
        list.add(index + increment, removeObj);
        this.refleshTableEntry();
        this.fTable.setSelection(sel + increment);
        this.refleshButtonEnable();
    }

    private void refleshButtonEnable() {
        int sel = this.fTable.getSelectionIndex();
        if (this.fTable.getItemCount() == 1) {
            this.fButtonUp.setEnabled(false);
            this.fButtonDn.setEnabled(false);
        } else if (sel == 0) {
            this.fButtonUp.setEnabled(false);
            this.fButtonDn.setEnabled(true);
        } else if (sel == this.fTable.getItemCount() - 1) {
            this.fButtonUp.setEnabled(true);
            this.fButtonDn.setEnabled(false);
        } else {
            this.fButtonUp.setEnabled(true);
            this.fButtonDn.setEnabled(true);
        }
    }

    private void refleshTableEntry() {
        this.fTable.removeAll();
        PartitionEntryList entryList = EditorTools.getPartitionEntryList(this.fExtension, false);
        int i = 0;
        while (i < entryList.size()) {
            IPartitionEntry entry = entryList.getPartitionEntry(i);
            this.addTableItem(entry);
            ++i;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.fTable = new Table(composite, 67584);
        GridData gridData = new GridData(1808);
        gridData.verticalSpan = 5;
        this.fTable.setLayoutData((Object)gridData);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        this.createTableColumn(this.fTable, this.getMessage("pref.com.colmn.type"));
        this.createTableColumn(this.fTable, this.getMessage("pref.com.colmn.rule"));
        this.fButtonAdd = this.createButton(composite, this.getMessage("pref.com.btn.add"));
        this.fButtonMod = this.createButton(composite, this.getMessage("pref.com.btn.mod"));
        this.fButtonDel = this.createButton(composite, this.getMessage("pref.com.btn.del"));
        this.fButtonUp = this.createButton(composite, this.getMessage("pref.com.btn.up"));
        this.fButtonDn = this.createButton(composite, this.getMessage("pref.com.btn.dn"));
        this.refleshTableEntry();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

