/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.text;

import jp.sourceforge.jeextension.styleeditor.core.ColorManager;
import jp.sourceforge.jeextension.styleeditor.text.IColorActivator;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ExtTextAttribute
extends TextAttribute
implements IColorActivator {
    private Color fBackgroundColor;
    private RGB fBackgroundRGB;
    private Color fForegroundColor;
    private RGB fForegroundRGB;

    public ExtTextAttribute(RGB foreground, RGB background, int style) {
        super(null, null, style);
        this.fForegroundRGB = foreground;
        this.fBackgroundRGB = background;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TextAttribute)) {
            return false;
        }
        TextAttribute a = (TextAttribute)object;
        return a.getStyle() == this.getStyle() && this.equals(a.getForeground(), this.getForeground()) && this.equals(a.getBackground(), this.getBackground());
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2 == null;
    }

    public void activateColor(ColorManager cm) {
        if (this.fForegroundRGB != null) {
            this.fForegroundColor = cm.getColor(this.fForegroundRGB);
        }
        if (this.fBackgroundRGB != null) {
            this.fBackgroundColor = cm.getColor(this.fBackgroundRGB);
        }
    }

    public Color getBackground() {
        return this.fBackgroundColor;
    }

    public Color getForeground() {
        return this.fForegroundColor;
    }

    public int hashCode() {
        int foregroundHash = this.getForeground() == null ? 0 : this.getForeground().hashCode();
        int backgroundHash = this.getBackground() == null ? 0 : this.getBackground().hashCode();
        return foregroundHash << 24 | backgroundHash << 16 | this.getStyle();
    }
}

