/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/core/StyleEditor.java,v 1.4 2007/03/09 08:18:54 kohnosuke Exp $
 * $Revision: 1.4 $
 * $Date: 2007/03/09 08:18:54 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.core;

// #ReqID:10002 Refactoring
import jp.sourceforge.jeextension.styleeditor.StyleEditorPlugin;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;

/**
 * DefinedEditor is based TextEditor.
 */ // #ReqID:10002 Refactoring
public class StyleEditor
        extends TextEditor implements IPropertyChangeListener {
    
    /**
     * ColorManager object.
     */ // #ReqID:10002 Refactoring
    private ColorManager fColorManager = new ColorManager();
// #ReqID:10002 Refactoring
    /**
     * Initiate Editor.
     */
    public StyleEditor() {
        super();
        // #ReqID:10002 Refactoring
        EditorConfiguration editorConf = new EditorConfiguration(this);
        DocumentProvider provider = new DocumentProvider(editorConf);
        // #ReqID:10002 Refactoring
        setSourceViewerConfiguration(editorConf);
        setDocumentProvider(provider);
    }

    /**
     * Returns current editting file extension.
     * @return file extension.
     */
    public String getFileExtension() {
        // get current editting file extension.
        IFileEditorInput input = (IFileEditorInput) getEditorInput();
        return input.getFile().getFileExtension();
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.ui.editors.text.TextEditor#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        
        // #ReqID:6168 Set Editor Font.
        // #ReqID:10002 Refactoring
        String ext = getFileExtension();
        Font font = EditorTools.getFont(ext);
        getSourceViewer().getTextWidget().setFont(font);
        // #ReqID:10002 Refactoring
//        // TextEditor activate background color.
//        Map m = EditorTools.getPartitionEntryMap();
//        PartitionEntryList list = (PartitionEntryList) m.get(ext);
//        if (list == null) {
//            list = (PartitionEntryList) m.get("*");
//        }
//        for (int i = 0; i < list.size(); i++) {
//            PartitionEntry entry = (PartitionEntry) list.get(i);
//            if (entry.getName().equals(IDocument.DEFAULT_CONTENT_TYPE)) {
//                if (entry.isBgColor()) {
//                    RGB bg = entry.getBgRGB();
//                    getSourceViewer().getTextWidget().setBackground(
//                            fColorManager.getColor(bg));
//                }
//            }
//        }
    }

    /** // #IntID:00005 Support Apply Button
     * {@inheritDoc}
     * @see org.eclipse.ui.texteditor.AbstractTextEditor#setPreferenceStore(org.eclipse.jface.preference.IPreferenceStore)
     */
    protected void setPreferenceStore(IPreferenceStore store) {
        
        IPreferenceStore prefStore =
            StyleEditorPlugin.getDefault().getPreferenceStore();
        prefStore.addPropertyChangeListener(this);
        
        super.setPreferenceStore(store);
    }
    
    /** // #IntID:00005 Support Apply Button
     * {@inheritDoc}
     * @see org.eclipse.jface.util.IPropertyChangeListener#propertyChange(org.eclipse.jface.util.PropertyChangeEvent)
     */
    public void propertyChange(PropertyChangeEvent event) {
        
        // Reflesh Editor Font.
        String ext = getFileExtension();
        Font font = EditorTools.getFont(ext);
        
        // Reflesh Editor SourceViewer
        ISourceViewer sourceViewer = getSourceViewer();
        if (sourceViewer != null) {
            sourceViewer.getTextWidget().setFont(font);
        }
        if (sourceViewer instanceof ISourceViewerExtension2) {
            ((ISourceViewerExtension2) sourceViewer).unconfigure();
            sourceViewer.configure(getSourceViewerConfiguration());
        }
        
        // Reflesh Editor Input
        if (getDocumentProvider() != null) {
            try {
                super.doSetInput(getEditorInput());
            }
            catch (Throwable e) {
                StyleEditorPlugin.log(e);
            }
        }
    }
    
    /**
     * Return ColorManager Instance managed StyleEditor.
     * @return ColorManager
     */
    ColorManager getColorManager() {
        return this.fColorManager;
    }
    
    /**
     * {@inheritDoc}
     * @see org.eclipse.ui.IWorkbenchPart#dispose()
     */
    public void dispose() {
        fColorManager.dispose();
        // #ReqID:10000 Editor Font disposed
//        if (fFont != null) {
//            fFont.dispose();
//        }
        super.dispose();
    }
}
