/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/core/WordDetector.java,v 1.4 2007/02/26 12:27:00 kohnosuke Exp $
 * $Revision: 1.4 $
 * $Date: 2007/02/26 12:27:00 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

import jp.sourceforge.jeextension.styleeditor.StyleEditorPlugin;

import org.eclipse.jface.text.rules.IWordDetector;

/**
 * DefineWordDetector
 */
class WordDetector implements IWordDetector {
    
    /** for isWordPart validation characters */
    private char[] fParts = new char[20];
    
    /** for isWordStart validation characters */
    private char[] fStarts = new char[20];
    
    /**
     * default constructor.
     */
    WordDetector() {
        super();
        URL url =
// #IntId:000000 Eclipse 3.0 Conversion.
//              StyleEditorPlugin.getDefault().getDescriptor().getInstallURL();
                StyleEditorPlugin.getDefault().getBundle().getEntry("/");
        try {
            load(new URL(url + "symbols-part.txt") , fParts);
            load(new URL(url + "symbols-start.txt"), fStarts);
        }
        catch (MalformedURLException e) {
            StyleEditorPlugin.log(e);
        }
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.text.rules.IWordDetector#isWordPart(char)
     */
    public boolean isWordPart(char c) {
        return isContains(c, fParts);
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.text.rules.IWordDetector#isWordStart(char)
     */
    public boolean isWordStart(char c) {
        return isContains(c, fStarts);
    }

    /**
     * Return character validation.
     * @param c         character of check's target.
     * @param symbols   valid symbol char array.
     * @return if valid character, return true.
     */
    private boolean isContains(char c, char[] symbols) {
        if (Character.isLetter(c)) {
            return true;
        }
        else {
            for (int i = 0; i < symbols.length; i++) {
                if (symbols[i] == c) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * Load defined symbol character.
     * @param url       define file url.
     * @param symbols   symbol character container.
     */
    private void load(URL url, char[] symbols) {
        try {
            InputStream in = url.openStream();
            for (int i = 0; i < symbols.length; i++) {
                int ch = in.read();
                if (ch == -1) {
                    break;
                }
                symbols[i] = (char) ch;
            }
        }
        catch (IOException e) {
            fParts = new char[0];
            StyleEditorPlugin.log(e);
        }
    }
}
