/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/entry/IEntry.java,v 1.2 2007/03/09 08:20:13 kohnosuke Exp $
 * $Revision: 1.2 $
 * $Date: 2007/03/09 08:20:13 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.entry;

import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.text.IExtRule;

import org.eclipse.swt.graphics.RGB;

/**
 * IEntry
 */
public interface IEntry {
    
    /**
     * Create XMLNode instance of current state.
     * @return XMLNode instance.
     */
    XMLNode createNode();
    
    /**
     * Return entry name of type.
     * @return multiLine | singleLine | endOfLine | keyword
     */
    String getName();
    /**
     * Returns defined RGB for text attributes.
     * @return RGB.
     */
    RGB getRGB();
    
    /**
     * Return IExtRule.
     * @return IExtRule.
     */
    IExtRule getRule();
    
    /**
     * Set RGB for text attributes.
     * @param rgb RGB.
     */
    void setRGB(RGB rgb);
    
    /**
     * Set IExtRule.
     * @param rule  IExtRule
     */
    void setRule(IExtRule rule);
    // #IntID:00004 Style Maximization
    /**
     * Set Background RGB for Color.
     * @param rgb RGB for Color
     */
    void setBgRGB(RGB rgb);
    
    /**
     * Set enabled Background Color.
     * @param b if enabled set true, else set false
     */
    void setBgColor(boolean b);
    
    /**
     * Set enabled Italic style.
     * @param b if enabled set true, else set false
     */
    void setItalic(boolean b);
    
    /**
     * Set enabled Bold style.
     * @param b if enabled set true, else set false
     */
    void setBold(boolean b);
    
    /**
     * Set enabled StrikeThrough style.
     * @param b if enabled set true, else set false
     */
    void setStrikeThrough(boolean b);
    
    /**
     * Set enabled Underline style.
     * @param b if enabled set true, else set false
     */
    void setUnderline(boolean b);
    
    /**
     * Return Background RGB for Color.
     * @return Background RGB
     */
    RGB getBgRGB();
    
    /**
     * Return enabled Background Color.
     * @return if enabled set true, else set false
     */
    boolean isBgColor();
    
    /**
     * Return enabled Italic style.
     * @return if enabled set true, else set false
     */
    boolean isItalic();
    
    /**
     * Return enabled Bold style.
     * @return if enabled set true, else set false
     */
    boolean isBold();
    
    /**
     * Return enabled StrikeThrough style.
     * @return if enabled set true, else set false
     */
    boolean isStrikeThrough();
    
    /**
     * Return enabled Underline style.
     * @return if enabled set true, else set false
     */
    boolean isUnderline();
}
