/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/entry/PartitionEntry.java,v 1.4 2007/03/09 10:41:53 kohnosuke Exp $
 * $Revision: 1.4 $
 * $Date: 2007/03/09 10:41:53 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.entry;

import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.text.IExtRule;

import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.RGB;

/**
 * PartitionEntry
 */
public class PartitionEntry implements IPartitionEntry {
    
    /** partition end keyword. */
    private String fEnd = "";
    
    /** partition name. */
    private String fName = "";
    
    /** defined RGB color. */
    private RGB fRGB = new RGB(0, 0, 0);
    // #IntID:00004 Style Maximization
    /** defined RGB color. */
    private RGB fBgRGB = new RGB(255, 255, 255);
    
    /** defined enable BackgroundColor */
    private boolean fBgColor = false;
    
    /** defined style */
    private boolean fItalic = false;
    
    /** defined style */
    private boolean fBold = false;
    
    /** defined style */
    private boolean fStrikeThrough = false;
    
    /** defined style */
    private boolean fUnderline = false;
    
    /** defined rule. */
    private IExtRule fRule;
    
    /** partition start keyword. */
    private String fStart = "";
    
    /** regexp keyword. #ReqID:10017 RegExp */
    private String fRegExp = "";
    
    /** list includes IDependsEntry depends this partition.
      * #ReqID:10017 RegExp*/
    private DependsEntryList fDepends = new DependsEntryList();
    
    /** view strings for PartitionEntryDialog #ReqID:10017 RegExp */
    private String fView;
    
    /**
     * Initiate this object. for default constructor.
     */
    public PartitionEntry() {
        super();
    }
    
    /**
     * Initiate this object. using XMLNode.
     * @param node  XMLNode
     * @param ext   extension name. (ex. java, means *.java)
     */
    public PartitionEntry(XMLNode node, String ext) {
        super();
        fName = node.getAttribute("name");
        fStart         = node.getAttribute("start");
        fEnd           = node.getAttribute("end");
        // #ReqID:10017 RegExp
        fRegExp        = node.getAttribute("regexp");
        this.fRGB.red   = Integer.parseInt(node.getAttribute("red"));
        this.fRGB.green = Integer.parseInt(node.getAttribute("green"));
        this.fRGB.blue  = Integer.parseInt(node.getAttribute("blue"));
        // #IntID:00004 Style Maximization
        this.fBgColor = Boolean.valueOf(
                node.getAttribute("bgcolor")).booleanValue();
        if (fBgColor) {
            this.fBgRGB.red     = Integer.parseInt(
                    node.getAttribute("bred"));
            this.fBgRGB.green   = Integer.parseInt(
                    node.getAttribute("bgreen"));
            this.fBgRGB.blue    = Integer.parseInt(
                    node.getAttribute("bblue"));
        }
        this.fItalic = Boolean.valueOf(
                node.getAttribute("italic")).booleanValue();
        this.fBold = Boolean.valueOf(
                node.getAttribute("bold")).booleanValue();
        this.fStrikeThrough = Boolean.valueOf(
                node.getAttribute("strikethrough")).booleanValue();
        this.fUnderline = Boolean.valueOf(
                node.getAttribute("underline")).booleanValue();
        
        // #ReqID:10017 RegExp
        // #IntID:00006 Compatibility previous version conf
        if (fRegExp == null) {
            fRegExp = "";
        }
        if (fRegExp.equals("") == false) {
            this.fView = fRegExp;
        }
        else {
            this.fView = fStart + " " + fEnd;
        }
        if (fName.equals("__dftl_partition_content_type")) {
            fName = IDocument.DEFAULT_CONTENT_TYPE;
            return;
        }
        this.fRule = EditorTools.createExtRule(node, ext);
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IPartitionEntry#createNode()
     */
    public XMLNode createNode() {
        XMLNode xmlNode = new XMLNode("partition");
        xmlNode.setAttribute("name" , this.fName);
        xmlNode.setAttribute("red"  , String.valueOf(fRGB.red));
        xmlNode.setAttribute("green", String.valueOf(fRGB.green));
        xmlNode.setAttribute("blue" , String.valueOf(fRGB.blue));
        xmlNode.setAttribute("start", this.getStart());
        xmlNode.setAttribute("end"  , this.getEnd());
        // #ReqID:10017 RegExp
        xmlNode.setAttribute("regexp", this.getRegExp());
        // #IntID:00004 Style Maximization
        if (fBgColor) {
            xmlNode.setAttribute("bgcolor", "true");
            xmlNode.setAttribute("bred"  , String.valueOf(this.fBgRGB.red));
            xmlNode.setAttribute("bgreen", String.valueOf(this.fBgRGB.green));
            xmlNode.setAttribute("bblue" , String.valueOf(this.fBgRGB.blue));
        }
        else {
            xmlNode.setAttribute("bgcolor", "false");
            xmlNode.setAttribute("bred"  , "");
            xmlNode.setAttribute("bgreen", "");
            xmlNode.setAttribute("bblue" , "");
        }
        xmlNode.setAttribute("italic",        String.valueOf(fItalic));
        xmlNode.setAttribute("bold",          String.valueOf(fBold));
        xmlNode.setAttribute("strikethrough", String.valueOf(fStrikeThrough));
        xmlNode.setAttribute("underline",     String.valueOf(fUnderline));
        return xmlNode;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IPartitionEntry#getEnd()
     */
    public String getEnd() {
        return fEnd;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IEntry#getName()
     */
    public String getName() {
        return fName;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IEntry#getRGB()
     */
    public RGB getRGB() {
        return fRGB;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IEntry#getRule()
     */
    public IExtRule getRule() {
        return this.fRule;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IPartitionEntry#getStart()
     */
    public String getStart() {
        return fStart;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry#getDependsEntryList()
     */
    public DependsEntryList getDependsEntryList() {
        return fDepends;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IPartitionEntry#setEnd(java.lang.String)
     */
    public void setEnd(String string) {
        fEnd = string;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IPartitionEntry#setName(java.lang.String)
     */
    public void setName(String string) {
       fName = string;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IEntry#setRGB(org.eclipse.swt.graphics.RGB)
     */
    public void setRGB(RGB newRgb) {
        this.fRGB = newRgb;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IEntry#setRule(jp.sourceforge.jeextension.styleeditor.text.IExtRule)
     */
    public void setRule(IExtRule rule) {
        fRule = rule;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IPartitionEntry#setStart(java.lang.String)
     */
    public void setStart(String string) {
        fStart = string;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry#getRegExp()
     * <!-- #ReqID:10017 RegExp (Partition) -->
     */
    public String getRegExp() {
        return this.fRegExp;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry#setRegExp(java.lang.String)
     * <!-- #ReqID:10017 RegExp (Partition) -->
     */
    public void setRegExp(String regexp) {
        this.fRegExp = regexp;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry#getView()
     * <!-- #ReqID:10017 RegExp (Partition) -->
     */
    public String getView() {
        return fView;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry#setView(java.lang.String)
     * <!-- #ReqID:10017 RegExp (Partition) -->
     */
    public void setView(String view) {
        fView = view;
    }
    // #IntID:00004 Style Maximization
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IEntry#getBgRGB()
     */
    public RGB getBgRGB() {
        return fBgRGB;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IEntry#isBgColor()
     */
    public boolean isBgColor() {
        return fBgColor;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IEntry#isBold()
     */
    public boolean isBold() {
        return fBold;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IEntry#isItalic()
     */
    public boolean isItalic() {
        return fItalic;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IEntry#isStrikeThrough()
     */
    public boolean isStrikeThrough() {
        return fStrikeThrough;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IEntry#isUnderline()
     */
    public boolean isUnderline() {
        return fUnderline;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IEntry#setBgColor(boolean)
     */
    public void setBgColor(boolean b) {
        fBgColor = b;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IEntry#setBgRGB(org.eclipse.swt.graphics.RGB)
     */
    public void setBgRGB(RGB rgb) {
        fBgRGB = rgb;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IEntry#setBold(boolean)
     */
    public void setBold(boolean b) {
        fBold = b;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IEntry#setItalic(boolean)
     */
    public void setItalic(boolean b) {
        fItalic = b;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IEntry#setStrikeThrough(boolean)
     */
    public void setStrikeThrough(boolean b) {
        fStrikeThrough = b;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IEntry#setUnderline(boolean)
     */
    public void setUnderline(boolean b) {
        fUnderline = b;
    }

}
