/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/preferences/AddDependsDialog.java,v 1.10 2007/03/09 11:13:03 kohnosuke Exp $
 * $Revision: 1.10 $
 * $Date: 2007/03/09 11:13:03 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.preferences;

import jp.sourceforge.jeextension.common.plugin.DefaultDialog;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.DependsEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IDependsEntry;
import jp.sourceforge.jeextension.styleeditor.text.IExtRule;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MessageBox; // #ReqID:10017 RegExp (Partition)
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/**
 * DefinedStyleEditroDialog
 */
class AddDependsDialog extends DefaultDialog {
    
    /** ColorSelector button. */
    private ColorSelector fColorSel;
    
    /** ColorSelector button. #IntID:00004 Style Maximization */
    private ColorSelector fColorBgc;

    /** 'End' Label. */
    private Label fLabelEnd;

    /** 'Keyword' Label. */
    private Label fLabelKwd;

    /** 'Start' Label. */
    private Label fLabelStr;
    
    /** 'Start' Label. */ // #IntID:00004 Style Maximization
    private Label fLabelBgc;
    
    /** depends partition name. */
    private String fParitionName;
    
    /** Selection Radio button. */
    private Button fRadioMlt;
    
    /** Selection Radio button. */
    private Button fRadioEnd;
    
    /** Selection Radio button. */
    private Button fRadioKwd;
    
    /** Selection Radio button. */
    private Button fRadioSgl;
    
    /** Selection Radio button. */ // #ReqID:10017 RegExp
    private Button fRadioReg;
    
    /** Selection Radio button. */ // #IntID:00004 Style Maximization
    private Button fCheckGbc;
    
    /** Selection Radio button. */ // #IntID:00004 Style Maximization
    private Button fCheckIta;
    
    /** Selection Radio button. */ // #IntID:00004 Style Maximization
    private Button fCheckBol;
    
    /** Selection Radio button. */ // #IntID:00004 Style Maximization
    private Button fCheckStr;
    
    /** Selection Radio button. */ // #IntID:00004 Style Maximization
    private Button fCheckUnd;
    
    /** return values reference when dialog was disposed. */
    private IDependsEntry[] fStyleContainer;
    
    /** dialog values container. */
    private IDependsEntry fStyleEntry;
    
    /** End's Text. */
    private Text fTextEnd;
    
    /** Keyword's Text. */
    private Text fTextKwd;
    
    /** Start's Text. */
    private Text fTextStr;
    
    /** Case Check Button. */
    private Button fCheckCase;
    
    /** current editting extension. */
    private String fExtension;
    
    /**
     * Initiate DefineEditorDialog Window.
     * @param shell     shell using on parent window
     * @param container dialog values container.
     * @param part      depends partition name.
     * @param ext   extension name. (ex. java, means *.java)
     */
    AddDependsDialog(Shell shell, IDependsEntry[] container, String part,
            String ext) {
        super(shell);
        fStyleEntry = container[0];
        fStyleContainer = container;
        fParitionName = part;
        fExtension = ext;
    }
    
    /**
     * {@inheritDoc}
     * @see org.eclipse.swt.widgets.Listener#handleEvent(org.eclipse.swt.widgets.Event)
     */
    public void handleEvent(Event event) {
        if (event.widget == fRadioSgl || event.widget == fRadioMlt) {
            fLabelStr.setEnabled(true);
            fLabelEnd.setEnabled(true);
            fLabelKwd.setEnabled(false);
            fTextStr.setEnabled(true);
            fTextEnd.setEnabled(true);
            fTextKwd.setEnabled(false);
            // #ReqID:10018 always casesensitive enabled
            fCheckCase.setEnabled(false);
        }
        if (event.widget == fRadioEnd) {
            fLabelStr.setEnabled(true);
            fLabelEnd.setEnabled(false);
            fLabelKwd.setEnabled(false);
            fTextStr.setEnabled(true);
            fTextEnd.setEnabled(false);
            fTextKwd.setEnabled(false);
            // #ReqID:10018 always casesensitive enabled
            fCheckCase.setEnabled(false);
        }
        if (event.widget == fRadioKwd) {
            fLabelStr.setEnabled(false);
            fLabelEnd.setEnabled(false);
            fLabelKwd.setEnabled(true);
            fTextStr.setEnabled(false);
            fTextEnd.setEnabled(false);
            fTextKwd.setEnabled(true);
            // #ReqID:10018 always casesensitive enabled
            fCheckCase.setEnabled(true);
        }
        // #ReqID:10017 RegExp
        if (event.widget == fRadioReg) {
            fLabelStr.setEnabled(false);
            fLabelEnd.setEnabled(false);
            fLabelKwd.setEnabled(true);
            fTextStr.setEnabled(false);
            fTextEnd.setEnabled(false);
            fTextKwd.setEnabled(true);
            // #ReqID:10018 always casesensitive enabled
            fCheckCase.setEnabled(false);
        }
        // #IntID:00004 Style Maximization
        if (event.widget == fCheckGbc) {
            if (fCheckGbc.getSelection()) {
                fColorBgc.setEnabled(true);
                fLabelBgc.setEnabled(true);
            }
            else {
                fColorBgc.setEnabled(false);
                fLabelBgc.setEnabled(false);
            }
        }
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
     */
    protected Control createDialogArea(Composite parent) {
        
        final Composite composite = (Composite) super.createDialogArea(parent);
        {
            final GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite.setLayout(gridLayout);

            final Label label = new Label(composite, SWT.NONE);
            final GridData gridData = new GridData();
            gridData.verticalSpan = 5; // #ReqID:10017 RegExp
            label.setLayoutData(gridData);
            label.setText(getMessage("pref.depends.dlg.radio.label"));

            fRadioMlt = new Button(composite, SWT.RADIO);
            fRadioMlt.setText(getMessage("pref.depends.dlg.radio.multline"));
            fRadioMlt.addListener(SWT.Selection, this);

            fRadioEnd = new Button(composite, SWT.RADIO);
            fRadioEnd.setText(getMessage("pref.depends.dlg.radio.endofline"));
            fRadioEnd.addListener(SWT.Selection, this);

            fRadioSgl = new Button(composite, SWT.RADIO);
            fRadioSgl.setText(getMessage("pref.depends.dlg.radio.singleline"));
            fRadioSgl.addListener(SWT.Selection, this);

            fRadioKwd = new Button(composite, SWT.RADIO);
            fRadioKwd.setText(getMessage("pref.depends.dlg.radio.keyword"));
            fRadioKwd.addListener(SWT.Selection, this);

            // #ReqID:10017 RegExp
            fRadioReg = new Button(composite, SWT.RADIO);
            fRadioReg.setText(getMessage("pref.depends.dlg.radio.regexp"));
            fRadioReg.addListener(SWT.Selection, this);
        }
        final Composite subComposite = new Composite(composite, SWT.NONE);
        {
            final GridData gridData = new GridData(GridData.FILL_BOTH);
            gridData.horizontalSpan = 2;
            subComposite.setLayoutData(gridData);
            final GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            subComposite.setLayout(gridLayout);

            fLabelStr = new Label(subComposite, SWT.NONE);
            fLabelStr.setText(getMessage("pref.depends.dlg.start"));

            fTextStr = new Text(subComposite, SWT.BORDER);
            fTextStr.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

            fLabelEnd = new Label(subComposite, SWT.NONE);
            fLabelEnd.setText(getMessage("pref.depends.dlg.end"));

            fTextEnd = new Text(subComposite, SWT.BORDER);
            fTextEnd.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

            fLabelKwd = new Label(subComposite, SWT.NONE);
            fLabelKwd.setText(getMessage("pref.depends.dlg.keyword"));

            fTextKwd = new Text(subComposite, SWT.BORDER);
            fTextKwd.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

            final Label cLabelClr = new Label(subComposite, SWT.NONE);
            cLabelClr.setText(getMessage("pref.depends.dlg.color"));

            fColorSel = new ColorSelector(subComposite);
            fColorSel.setColorValue(new RGB(0, 0, 0));
            // #IntID:00004 Style Maximization
            fLabelBgc = new Label(subComposite, SWT.NONE);
            fLabelBgc.setText(getMessage("pref.depends.dlg.bgcolor"));

            fColorBgc = new ColorSelector(subComposite);
            fColorBgc.setColorValue(new RGB(255, 255, 255));
            // #IntID:00007 BugFix BGColor default enabled when entry new item
            fColorBgc.setEnabled(false);

            final GridData gridData2 = new GridData();
            gridData2.horizontalSpan = 2;
            fCheckGbc = new Button(subComposite, SWT.CHECK);
            fCheckGbc.setText(getMessage("pref.depends.dlg.usebgcolor"));
            fCheckGbc.addListener(SWT.Selection, this);
            fCheckGbc.setLayoutData(gridData2);

            fCheckIta = new Button(subComposite, SWT.CHECK);
            fCheckIta.setText(getMessage("pref.depends.dlg.italic"));
            fCheckIta.addListener(SWT.Selection, this);

            fCheckBol = new Button(subComposite, SWT.CHECK);
            fCheckBol.setText(getMessage("pref.depends.dlg.bold"));
            fCheckBol.addListener(SWT.Selection, this);

            fCheckStr = new Button(subComposite, SWT.CHECK);
            fCheckStr.setText(getMessage("pref.depends.dlg.strikethrough"));
            fCheckStr.addListener(SWT.Selection, this);

            fCheckUnd = new Button(subComposite, SWT.CHECK);
            fCheckUnd.setText(getMessage("pref.depends.dlg.underline"));
            fCheckUnd.addListener(SWT.Selection, this);
            // #IntID:00006 Support Eclipse 3.0.x
            final GridData gridData3 = new GridData();
            gridData3.horizontalSpan = 2;
            fCheckCase = new Button(subComposite, SWT.CHECK);
            fCheckCase.setText(getMessage("pref.depends.dlg.case"));
            fCheckCase.setSelection(true);
            // #IntID:00004 Style Maximization
            fCheckCase.setLayoutData(gridData3);

        }
        
        executeInitEvent();
        
        return composite;
    }
    
    /** // #IntID:10002 Refactoring
     * Execute Initialize Event, after createDialog process.
     */
    private void executeInitEvent() {
        Event event = new Event();
        if (fStyleEntry != null) {
            IExtRule rule = fStyleEntry.getRule();
            if (fStyleEntry.getName().equals("keyword")) {
                fTextKwd.setText(rule.getWords()[0]);
                String sensitive = rule.getWords()[1];
// #ReqID:10003 Casesensitive Setting ignored
//                if (sensitive.equalsIgnoreCase("true")) {
                    fCheckCase.setSelection(
                            Boolean.valueOf(sensitive).booleanValue());
//                }
                fRadioMlt.setEnabled(false);
                fRadioKwd.setSelection(true);
                fRadioSgl.setEnabled(false);
                fRadioEnd.setEnabled(false);
                fRadioReg.setEnabled(false); // #ReqID:10017 RegExp
// #ReqID:10003 Casesensitive Setting ignored
//                fCheckCase.setEnabled(true);
                event.widget = fRadioKwd;
            }
            if (fStyleEntry.getName().equals("endOfLine")) {
                fTextStr.setText(rule.getWords()[0]);
                fRadioMlt.setEnabled(false);
                fRadioEnd.setSelection(true);
                fRadioSgl.setEnabled(false);
                fRadioKwd.setEnabled(false);
                fRadioReg.setEnabled(false); // #ReqID:10017 RegExp
                fCheckCase.setEnabled(false);
                event.widget = fRadioEnd;
            }
            if (fStyleEntry.getName().equals("singleLine")) {
                fTextStr.setText(rule.getWords()[0]);
                fTextEnd.setText(rule.getWords()[1]);
                fRadioMlt.setEnabled(false);
                fRadioSgl.setSelection(true);
                fRadioEnd.setEnabled(false);
                fRadioKwd.setEnabled(false);
                fRadioReg.setEnabled(false); // #ReqID:10017 RegExp
                fCheckCase.setEnabled(false);
                event.widget = fRadioSgl;
            }
            if (fStyleEntry.getName().equals("multiLine")) {
                fTextStr.setText(rule.getWords()[0]);
                fTextEnd.setText(rule.getWords()[1]);
                fRadioMlt.setSelection(true);
                fRadioSgl.setEnabled(false);
                fRadioEnd.setEnabled(false);
                fRadioKwd.setEnabled(false);
                fRadioReg.setEnabled(false); // #ReqID:10017 RegExp
                fCheckCase.setEnabled(false);
                event.widget = fRadioMlt;
            }
            // #ReqID:10017 RegExp
            if (fStyleEntry.getName().equals("regexp")) {
                fTextKwd.setText(rule.getWords()[0]);
                fRadioMlt.setEnabled(false);
                fRadioSgl.setEnabled(false);
                fRadioEnd.setEnabled(false);
                fRadioKwd.setEnabled(false);
                fRadioReg.setSelection(true);
                fCheckCase.setEnabled(false);
                event.widget = fRadioReg;
            }
            // #IntID:00004 Style Maximization
            fColorSel.setColorValue(fStyleEntry.getRGB());
            if (fStyleEntry.isBgColor()) {
                fColorBgc.setColorValue(fStyleEntry.getBgRGB());
                fCheckGbc.setSelection(true);
                fColorBgc.setEnabled(true);
                fLabelBgc.setEnabled(true);
            }
            else {
                fColorBgc.setEnabled(false);
                fLabelBgc.setEnabled(false);
            }
            if (fStyleEntry.isItalic()) {
                fCheckIta.setSelection(true);
            }
            if (fStyleEntry.isBold()) {
                fCheckBol.setSelection(true);
            }
            if (fStyleEntry.isStrikeThrough()) {
                fCheckStr.setSelection(true);
            }
            if (fStyleEntry.isUnderline()) {
                fCheckUnd.setSelection(true);
            }
        }
        else {
            fRadioKwd.setSelection(true);
            event.widget = fRadioKwd;
        }
        handleEvent(event);
    }
    
    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.dialogs.Dialog#okPressed()
     */
    protected void okPressed() {
        
        // #ReqID:10017 RegExp (Partition)
        if (fRadioReg.getSelection()) {
            String detected = EditorTools.checkRegExp(fTextKwd.getText());
            if (detected == null) {
                // RegExp check OK
            }
            else {
                // RegExp check NG
                MessageBox mb = new MessageBox(getShell());
                mb.setMessage(detected + " " + getMessage("pref.err.regexp"));
                mb.open();
                return;
            }
        }
        
        XMLNode parent = new XMLNode("partition");
        parent.setAttribute("name", fParitionName);
        XMLNode node = null;
        // #IntID:10002 Refactoring
        RGB rgb = fColorSel.getColorValue();
        if (fRadioKwd.getSelection()) {
            node = new XMLNode("keyword");
            node.setAttribute("word" , fTextKwd.getText());
            node.setAttribute("case" ,
                    String.valueOf(fCheckCase.getSelection()));
        }
        if (fRadioMlt.getSelection()) {
            node = new XMLNode("multiLine");
            node.setAttribute("start", fTextStr.getText());
            node.setAttribute("end"  , fTextEnd.getText());
        }
        if (fRadioSgl.getSelection()) {
            node = new XMLNode("singleLine");
            node.setAttribute("start", fTextStr.getText());
            node.setAttribute("end"  , fTextEnd.getText());
        }
        if (fRadioEnd.getSelection()) {
            node = new XMLNode("endOfLine");
            node.setAttribute("start", fTextStr.getText());
        }
        // #ReqID:10017 RegExp
        if (fRadioReg.getSelection()) {
            node = new XMLNode("regexp");
            node.setAttribute("regexp", fTextKwd.getText());
        }
        // #IntID:00004 Style Maximization
        node.setAttribute("red"  , String.valueOf(rgb.red));
        node.setAttribute("green", String.valueOf(rgb.green));
        node.setAttribute("blue" , String.valueOf(rgb.blue));
        if (fCheckGbc.getSelection()) {
            RGB brgb = fColorBgc.getColorValue();
            node.setAttribute("bgcolor"  , "true");
            node.setAttribute("bred"  , String.valueOf(brgb.red));
            node.setAttribute("bgreen", String.valueOf(brgb.green));
            node.setAttribute("bblue" , String.valueOf(brgb.blue));
        }
        else {
            node.setAttribute("bgcolor"  , "false");
            node.setAttribute("bred"  , "");
            node.setAttribute("bgreen", "");
            node.setAttribute("bblue" , "");
        }
        node.setAttribute("italic",         fCheckIta.getSelection() + "");
        node.setAttribute("bold",           fCheckBol.getSelection() + "");
        node.setAttribute("strikethrough",  fCheckStr.getSelection() + "");
        node.setAttribute("underline",      fCheckUnd.getSelection() + "");
        parent.addChild(node);
        
        if (fStyleEntry == null) {
            fStyleEntry = new DependsEntry(node, fExtension);
        }
        else {
            EditorTools.changeDependsEntry(fStyleEntry, node, fExtension);
        }
        fStyleContainer[0] = fStyleEntry;
        super.okPressed();
    }
}
