/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/text/ExtRegExpRule.java,v 1.1 2007/02/28 13:29:04 kohnosuke Exp $
 * $Revision: 1.1 $
 * $Date: 2007/02/28 13:29:04 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.text;

import java.util.regex.Pattern;

import org.eclipse.jface.text.rules.IToken;

import jp.sourceforge.jeextension.styleeditor.core.ColorManager;

/**
 * ExtRegExpRule
 * 
 * #ReqID:10017 RegExp
 */
public class ExtRegExpRule extends RegExpRule implements IExtRule {
    
    /**
     * RegExp
     */
    private String fWord;
    
    /**
     * Constructer using regexp strings, and IToken when it's matching.
     * @param regexp    regexp strings
     * @param token     IToken
     */
    public ExtRegExpRule(String regexp, IToken token) {
        super(regexp, token);
        this.fWord = regexp;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.text.IColorActivator#activateColor(jp.sourceforge.jeextension.styleeditor.core.ColorManager)
     */
    public void activateColor(ColorManager cm) {
        Object obj = super.fToken.getData();
        if (obj instanceof IColorActivator) {
            ((IColorActivator) obj).activateColor(cm);
        }
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.text.IExtRule#getWords()
     */
    public String[] getWords() {
        return new String[] {this.fWord};
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.text.IExtRule#setWords(java.lang.String[])
     */
    public void setWords(String[] words) {
        this.fWord = words[0];
        super.fPattern = Pattern.compile(words[0]);
    }
}
