/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/text/ExtTextAttribute.java,v 1.3 2007/03/09 08:09:16 kohnosuke Exp $
 * $Revision: 1.3 $
 * $Date: 2007/03/09 08:09:16 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.text;

import jp.sourceforge.jeextension.styleeditor.core.ColorManager;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
// #ReqID:10002 Refactoring
/**
 * ExtTextAttribute
 */
public class ExtTextAttribute extends TextAttribute
        implements IColorActivator {
    
    /** Background color after activation */
    private Color fBackgroundColor;
    
    /** Background RGB */
    private RGB fBackgroundRGB;
    
    /** Foreground color after activation */
    private Color fForegroundColor;
    
    /** Foreground RGB */
    private RGB fForegroundRGB;
// #ReqID:10002 Refactoring
    /**
     * Initiate extended TextAttribute Object using foreground RGB, background
     * RGB, SWT style.
     * @param foreground    RGB.
     * @param background    RGB.
     * @param style         SWT style.
     */
    public ExtTextAttribute(RGB foreground, RGB background, int style) {
        // #ReqID:10002 Refactoring
        super(null, null, style);
        this.fForegroundRGB = foreground;
        this.fBackgroundRGB = background;
    }
    
    /** // #ReqID:10002 Refactoring
     * {@inheritDoc}
     * 
     * @see org.eclipse.jface.text.TextAttribute#equals(java.lang.Object)
     */
    public boolean equals(Object object) {
        
        if (object == this) {
            return true;
        }
        
        if (!(object instanceof TextAttribute)) {
            return false;
        }
        
        TextAttribute a = (TextAttribute) object;
        return (a.getStyle() == getStyle()
                && equals(a.getForeground(), getForeground()) && equals(a
                .getBackground(), getBackground()));
    }
    
    /** // #ReqID:10002 Refactoring
     * Returns whether the two given objects are equal.
     * 
     * @param o1
     *            the first object, can be <code>null</code>
     * @param o2
     *            the second object, can be <code>null</code>
     * @return <code>true</code> if the given objects are equals
     * @since 2.0
     */
    private boolean equals(Object o1, Object o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        else {
            return (o2 == null);
        }
    }
    
    /**
     * Activate Color device.
     * @param cm ColorManager
     */
    public void activateColor(ColorManager cm) {
        if (fForegroundRGB != null) {
            this.fForegroundColor = cm.getColor(this.fForegroundRGB);
        }
        if (fBackgroundRGB != null) {
            this.fBackgroundColor = cm.getColor(this.fBackgroundRGB);
        }
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.text.TextAttribute#getBackground()
     */
    public Color getBackground() {
        return this.fBackgroundColor;
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.text.TextAttribute#getForeground()
     */
    public Color getForeground() {
        return this.fForegroundColor;
    }
    
    /** // #ReqID:10002 Refactoring
     * {@inheritDoc}
     * 
     * @see Object#hashCode()
     */
    public int hashCode() {
        int foregroundHash;
        if (getForeground() == null) {
            foregroundHash = 0;
        }
        else {
            foregroundHash = getForeground().hashCode();
        }
        int backgroundHash;
        if (getBackground() == null) {
            backgroundHash = 0;
        }
        else {
            backgroundHash = getBackground().hashCode();
        }
        return (foregroundHash << 24) | (backgroundHash << 16) | getStyle();
    }
    
}
