/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.StyleEditorPlugin;
import jp.sourceforge.jeextension.styleeditor.core.StyleEditorWordDetector;
import jp.sourceforge.jeextension.styleeditor.entry.DefinedStyleEntry;
import jp.sourceforge.jeextension.styleeditor.entry.DependsEntry;
import jp.sourceforge.jeextension.styleeditor.entry.DependsEntryList;
import jp.sourceforge.jeextension.styleeditor.entry.FontEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IDependsEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntryList;
import jp.sourceforge.jeextension.styleeditor.text.ExtEndOfLineRule;
import jp.sourceforge.jeextension.styleeditor.text.ExtMultiLineRule;
import jp.sourceforge.jeextension.styleeditor.text.ExtRegExpRule;
import jp.sourceforge.jeextension.styleeditor.text.ExtSingleLineRule;
import jp.sourceforge.jeextension.styleeditor.text.ExtTextAttribute;
import jp.sourceforge.jeextension.styleeditor.text.ExtWordRule;
import jp.sourceforge.jeextension.styleeditor.text.IColorActivator;
import jp.sourceforge.jeextension.styleeditor.text.IExtRule;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;

public class StyleEditorTools {
    public static String checkRegExp(String regexp) {
        StringBuffer detected = new StringBuffer();
        if (regexp.indexOf("\\r") != -1) {
            detected.append("\\r");
        }
        if (regexp.indexOf("\\n") != -1) {
            detected.append("\\n");
        }
        if (regexp.indexOf("\\x0D") != -1) {
            detected.append("\\x0D");
        }
        if (regexp.indexOf("\\x0A") != -1) {
            detected.append("\\x0A");
        }
        if (regexp.indexOf("\\x0d") != -1) {
            detected.append("\\x0d");
        }
        if (regexp.indexOf("\\x0a") != -1) {
            detected.append("\\x0a");
        }
        if (detected.length() != 0) {
            return detected.toString();
        }
        return null;
    }

    public static void changeDependsEntry(IDependsEntry entry, XMLNode node, String ext) {
        DependsEntry newEntry = new DependsEntry(node, ext);
        entry.setDepends(newEntry.getDepends());
        entry.setRGB(newEntry.getRGB());
        entry.setRule(newEntry.getRule());
        entry.setWords(newEntry.getWords());
        entry.setBgColor(newEntry.isBgColor());
        entry.setBgRGB(newEntry.getBgRGB());
        entry.setItalic(newEntry.isItalic());
        entry.setBold(newEntry.isBold());
        entry.setStrikeThrough(newEntry.isStrikeThrough());
        entry.setUnderline(newEntry.isUnderline());
    }

    public static void changePartitionEntry(IPartitionEntry entry, XMLNode node, String ext) {
        PartitionEntry newEntry = new PartitionEntry(node, ext);
        entry.setRGB(newEntry.getRGB());
        entry.setRule(newEntry.getRule());
        entry.setStart(newEntry.getStart());
        entry.setEnd(newEntry.getEnd());
        entry.setName(newEntry.getName());
        entry.setRegExp(newEntry.getRegExp());
        entry.setView(newEntry.getView());
        entry.setBgColor(newEntry.isBgColor());
        entry.setBgRGB(newEntry.getBgRGB());
        entry.setItalic(newEntry.isItalic());
        entry.setBold(newEntry.isBold());
        entry.setStrikeThrough(newEntry.isStrikeThrough());
        entry.setUnderline(newEntry.isUnderline());
    }

    public static IExtRule createExtRule(XMLNode node, String ext) {
        Token token;
        String end;
        String start;
        IExtRule rule = null;
        String nodeName = node.getNodeName();
        RGB rgb = new RGB(0, 0, 0);
        rgb.red = Integer.parseInt(node.getAttribute("red"));
        rgb.green = Integer.parseInt(node.getAttribute("green"));
        rgb.blue = Integer.parseInt(node.getAttribute("blue"));
        RGB brgb = null;
        int style = 0;
        String obj = node.getAttribute("bgcolor");
        if (obj != null) {
            if ("true".equals(node.getAttribute("bgcolor"))) {
                brgb = new RGB(0, 0, 0);
                brgb.red = Integer.parseInt(node.getAttribute("bred"));
                brgb.green = Integer.parseInt(node.getAttribute("bgreen"));
                brgb.blue = Integer.parseInt(node.getAttribute("bblue"));
            }
            style = "true".equals(node.getAttribute("bold")) ? 1 : 0;
            if ("true".equals(node.getAttribute("italic"))) {
                style |= 2;
            }
            if ("true".equals(node.getAttribute("strikethrough"))) {
                style |= 0x20000000;
            }
            if ("true".equals(node.getAttribute("underline"))) {
                style |= 0x40000000;
            }
        }
        if ("partition".equals(nodeName)) {
            start = node.getAttribute("start");
            end = node.getAttribute("end");
            String regexp = node.getAttribute("regexp");
            Token token2 = new Token((Object)node.getAttribute("name"));
            rule = regexp != null && !regexp.equals("") ? new ExtRegExpRule(node.getAttribute("regexp"), (IToken)token2) : ("".equals(end) ? new ExtEndOfLineRule(start, (IToken)token2) : new ExtMultiLineRule(start, end, (IToken)token2));
        }
        if ("multiLine".equals(nodeName)) {
            start = node.getAttribute("start");
            end = node.getAttribute("end");
            Token token3 = new Token((Object)new ExtTextAttribute(rgb, brgb, style));
            rule = new ExtMultiLineRule(start, end, (IToken)token3);
        }
        if ("singleLine".equals(nodeName)) {
            token = new Token((Object)new ExtTextAttribute(rgb, brgb, style));
            String start2 = node.getAttribute("start");
            String end2 = node.getAttribute("end");
            rule = new ExtSingleLineRule(start2, end2, (IToken)token);
        }
        if ("endOfLine".equals(nodeName)) {
            token = new Token((Object)new ExtTextAttribute(rgb, brgb, style));
            rule = new ExtEndOfLineRule(node.getAttribute("start"), (IToken)token);
        }
        if ("keyword".equals(nodeName)) {
            token = new Token((Object)new ExtTextAttribute(rgb, brgb, style));
            ExtWordRule wRule = new ExtWordRule(new StyleEditorWordDetector());
            String word = node.getAttribute("word");
            String csensitive = node.getAttribute("case");
            if (csensitive == null) {
                csensitive = "true";
            }
            wRule.addWord(word, (IToken)token, csensitive);
            rule = wRule;
        }
        if ("regexp".equals(nodeName)) {
            token = new Token((Object)new ExtTextAttribute(rgb, brgb, style));
            rule = new ExtRegExpRule(node.getAttribute("regexp"), (IToken)token);
        }
        return rule;
    }

    public static Map getPartitionEntryMap() {
        DefinedStyleEntry styleEntry = StyleEditorPlugin.getDefinedStyleEntry();
        return styleEntry.getPartitionEntryMap();
    }

    public static Map getFontEntryMap() {
        DefinedStyleEntry styleEntry = StyleEditorPlugin.getDefinedStyleEntry();
        return styleEntry.getFontEntryMap();
    }

    public static Font getFont(String ext) {
        Map fontEntryMap = StyleEditorTools.getFontEntryMap();
        FontEntry fontEntry = (FontEntry)fontEntryMap.get(ext);
        if (fontEntry != null) {
            return fontEntry.getFont();
        }
        fontEntry = (FontEntry)fontEntryMap.get("*");
        if (fontEntry != null) {
            return fontEntry.getFont();
        }
        return JFaceResources.getTextFont();
    }

    public static IPartitionEntry getPartitionEntry(String partName, String ext, boolean create) {
        DefinedStyleEntry styleEntry = StyleEditorPlugin.getDefinedStyleEntry();
        return styleEntry.getPartitionEntry(partName, ext, create);
    }

    public static PartitionEntryList getPartitionEntryList(String ext, boolean create) {
        DefinedStyleEntry styleEntry = StyleEditorPlugin.getDefinedStyleEntry();
        return styleEntry.getPartitionEntryList(ext, create);
    }

    StyleEditorTools() {
    }

    public RuleBasedPartitionScanner createPartitionScanner(String ext) {
        RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner();
        scanner.setPredicateRules(this.createPredicateRule(ext));
        return scanner;
    }

    public RuleBasedScanner createScanner(String partitionName, String ext) {
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setRules(this.createRules(partitionName, ext));
        return scanner;
    }

    public static String[] getContentTypes(String ext) {
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("__dftl_partition_content_type");
        return StyleEditorTools.createContentTypes(typeList, ext);
    }

    public static String[] getContentTypesExcludeDefault(String ext) {
        return StyleEditorTools.createContentTypes(new ArrayList(), ext);
    }

    public IToken getDefaultToken(IPartitionEntry entry) {
        IColorManager cm = StyleEditorPlugin.getDefault().getColorManager();
        RGB rgb = entry.getRGB();
        RGB brgb = null;
        Color fg = cm.getColor(rgb);
        Color bg = null;
        if (entry.isBgColor()) {
            brgb = entry.getBgRGB();
            bg = cm.getColor(brgb);
        }
        int style = 0;
        style = entry.isBold() ? 1 : 0;
        if (entry.isItalic()) {
            style |= 2;
        }
        if (entry.isStrikeThrough()) {
            style |= 0x20000000;
        }
        if (entry.isUnderline()) {
            style |= 0x40000000;
        }
        TextAttribute attr = new TextAttribute(fg, bg, style);
        Token token = new Token((Object)attr);
        return token;
    }

    public IDocumentPartitioner createDocumentPartitioner(String ext) {
        RuleBasedPartitionScanner scanner = this.createPartitionScanner(ext);
        String[] contentTypes = StyleEditorTools.getContentTypesExcludeDefault(ext);
        return new DefaultPartitioner((IPartitionTokenScanner)scanner, contentTypes);
    }

    private void activateColor(List ruleList) {
        IColorManager cm = StyleEditorPlugin.getDefault().getColorManager();
        int i = 0;
        while (i < ruleList.size()) {
            Object obj = ruleList.get(i);
            if (obj instanceof IColorActivator) {
                IColorActivator rule = (IColorActivator)obj;
                rule.activateColor(cm);
            }
            ++i;
        }
    }

    private void appendRuleList(IEntry entry, List ruleList) {
        IExtRule rule = null;
        if (entry.getName().equals("keyword")) {
            int i = 0;
            while (i < ruleList.size()) {
                Object obj = ruleList.get(i);
                if (obj instanceof WordRule) {
                    rule = (WordRule)obj;
                }
                ++i;
            }
            if (rule != null) {
                ExtWordRule wRule = (ExtWordRule)entry.getRule();
                ((ExtWordRule)rule).addWordRuleMap(wRule.getWordRuleMap());
                return;
            }
            rule = entry.getRule();
            ExtWordRule wRule = (ExtWordRule)entry.getRule();
            HashMap currentMap = new HashMap(wRule.getWordRuleMap());
            wRule.getWordRuleMap().clear();
            wRule.getWordRuleMap().putAll(currentMap);
        }
        if (entry.getName().equals("multiLine")) {
            rule = entry.getRule();
        }
        if (entry.getName().equals("endOfLine")) {
            rule = entry.getRule();
        }
        if (entry.getName().equals("singleLine")) {
            rule = entry.getRule();
        }
        if (entry.getName().equals("regexp")) {
            rule = entry.getRule();
        }
        if (entry instanceof IPartitionEntry) {
            if (entry.getName().equals("__dftl_partition_content_type")) {
                return;
            }
            rule = entry.getRule();
        }
        ruleList.add(rule);
    }

    private static String[] createContentTypes(List typeList, String ext) {
        PartitionEntryList entryList = StyleEditorTools.getPartitionEntryList(ext, false);
        int i = 0;
        while (i < entryList.size()) {
            IPartitionEntry entry = entryList.getPartitionEntry(i);
            String partition = entry.getName();
            if (!partition.equals("__dftl_partition_content_type")) {
                typeList.add(entry.getName());
            }
            ++i;
        }
        String[] types = new String[typeList.size()];
        return typeList.toArray(types);
    }

    private IPredicateRule[] createPredicateRule(String ext) {
        PartitionEntryList entryList = StyleEditorTools.getPartitionEntryList(ext, false);
        ArrayList ruleList = new ArrayList();
        int i = 0;
        while (i < entryList.size()) {
            IPartitionEntry entry = entryList.getPartitionEntry(i);
            this.appendRuleList(entry, ruleList);
            ++i;
        }
        this.activateColor(ruleList);
        IPredicateRule[] rules = new IPredicateRule[ruleList.size()];
        return ruleList.toArray(rules);
    }

    private IRule[] createRules(String partName, String ext) {
        IPartitionEntry partList = StyleEditorTools.getPartitionEntry(partName, ext, false);
        DependsEntryList entryList = partList.getDependsEntryList();
        ArrayList ruleList = new ArrayList();
        int i = 0;
        while (i < entryList.size()) {
            IDependsEntry entry = entryList.getDependsEntry(i);
            String partition = entry.getDepends().getName();
            if (partition.equals(partName)) {
                this.appendRuleList(entry, ruleList);
            }
            ++i;
        }
        this.activateColor(ruleList);
        IRule[] rules = new IRule[ruleList.size()];
        ruleList.toArray(rules);
        return rules;
    }
}

