/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.preferences;

import jp.sourceforge.jeextension.common.plugin.DefaultDialog;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.core.StyleEditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntry;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class AddPartitionDialog
extends DefaultDialog {
    private ColorSelector fColorSel;
    private Label fLabelEnd;
    private Label fLabelKwd;
    private Label fLabelReg;
    private Label fLabelStr;
    private Label fLabelBgc;
    private IPartitionEntry[] fStyleContainer;
    private IPartitionEntry fStyleEntry;
    private Text fTextEnd;
    private Text fTextNme;
    private Text fTextReg;
    private Text fTextStr;
    private Button fCheckBase;
    private Button fUseRegExp;
    private Button fJavadoc;
    private Button fJavaMulti;
    private Button fJavaSingle;
    private final String fExtension;
    private Button fCheckGbc;
    private Button fCheckIta;
    private Button fCheckBol;
    private Button fCheckStr;
    private Button fCheckUnd;
    private ColorSelector fColorBgc;

    AddPartitionDialog(Shell shell, IPartitionEntry[] container, String ext) {
        super(shell);
        this.fStyleEntry = container[0];
        this.fStyleContainer = container;
        this.fExtension = ext;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.fCheckBase) {
            if (this.fCheckBase.getSelection()) {
                this.fTextStr.setText("");
                this.fTextEnd.setText("");
                this.fTextNme.setText("__dftl_partition_content_type");
                this.fTextReg.setEnabled(false);
                this.fTextStr.setEnabled(false);
                this.fTextEnd.setEnabled(false);
                this.fTextNme.setEnabled(false);
                this.fUseRegExp.setEnabled(false);
                this.fJavadoc.setEnabled(false);
                this.fJavaMulti.setEnabled(false);
                this.fJavaSingle.setEnabled(false);
            } else {
                if (this.fTextNme.getText().equals("__dftl_partition_content_type")) {
                    this.fTextNme.setText("");
                }
                this.fTextReg.setEnabled(false);
                this.fTextStr.setEnabled(true);
                this.fTextEnd.setEnabled(true);
                this.fTextNme.setEnabled(true);
                this.fUseRegExp.setEnabled(true);
                this.fJavadoc.setEnabled(true);
                this.fJavaMulti.setEnabled(true);
                this.fJavaSingle.setEnabled(true);
            }
        }
        if (event.widget == this.fUseRegExp) {
            if (this.fUseRegExp.getSelection()) {
                this.fTextStr.setText("");
                this.fTextEnd.setText("");
                this.fTextReg.setEnabled(true);
                this.fTextStr.setEnabled(false);
                this.fTextEnd.setEnabled(false);
                this.fCheckBase.setEnabled(false);
                this.fJavadoc.setEnabled(false);
                this.fJavaMulti.setEnabled(false);
                this.fJavaSingle.setEnabled(false);
            } else {
                this.fTextReg.setText("");
                this.fTextReg.setEnabled(false);
                this.fTextStr.setEnabled(true);
                this.fTextEnd.setEnabled(true);
                this.fCheckBase.setEnabled(true);
                this.fJavadoc.setEnabled(true);
                this.fJavaMulti.setEnabled(true);
                this.fJavaSingle.setEnabled(true);
            }
        }
        if (event.widget == this.fCheckGbc) {
            if (this.fCheckGbc.getSelection()) {
                this.fColorBgc.setEnabled(true);
                this.fLabelBgc.setEnabled(true);
            } else {
                this.fColorBgc.setEnabled(false);
                this.fLabelBgc.setEnabled(false);
            }
        }
        if (event.widget == this.fJavadoc) {
            if (this.fJavadoc.getSelection()) {
                this.fTextStr.setText("/**");
                this.fTextEnd.setText("*/");
                this.fTextNme.setText("__java_javadoc");
                this.fTextReg.setEnabled(false);
                this.fTextStr.setEnabled(false);
                this.fTextEnd.setEnabled(false);
                this.fTextNme.setEnabled(false);
                this.fCheckBase.setEnabled(false);
                this.fUseRegExp.setEnabled(false);
                this.fJavaMulti.setEnabled(false);
                this.fJavaSingle.setEnabled(false);
            } else {
                this.fTextStr.setText("");
                this.fTextEnd.setText("");
                this.fTextNme.setText("");
                this.fTextReg.setEnabled(false);
                this.fTextStr.setEnabled(true);
                this.fTextEnd.setEnabled(true);
                this.fTextNme.setEnabled(true);
                this.fCheckBase.setEnabled(true);
                this.fUseRegExp.setEnabled(true);
                this.fJavaMulti.setEnabled(true);
                this.fJavaSingle.setEnabled(true);
            }
        }
        if (event.widget == this.fJavaMulti) {
            if (this.fJavaMulti.getSelection()) {
                this.fTextStr.setText("/*");
                this.fTextEnd.setText("*/");
                this.fTextNme.setText("__java_multiline_comment");
                this.fTextReg.setEnabled(false);
                this.fTextStr.setEnabled(false);
                this.fTextEnd.setEnabled(false);
                this.fTextNme.setEnabled(false);
                this.fCheckBase.setEnabled(false);
                this.fUseRegExp.setEnabled(false);
                this.fJavadoc.setEnabled(false);
                this.fJavaSingle.setEnabled(false);
            } else {
                this.fTextStr.setText("");
                this.fTextEnd.setText("");
                this.fTextNme.setText("");
                this.fTextReg.setEnabled(false);
                this.fTextStr.setEnabled(true);
                this.fTextEnd.setEnabled(true);
                this.fTextNme.setEnabled(true);
                this.fCheckBase.setEnabled(true);
                this.fUseRegExp.setEnabled(true);
                this.fJavadoc.setEnabled(true);
                this.fJavaSingle.setEnabled(false);
            }
        }
        if (event.widget == this.fJavaSingle) {
            if (this.fJavaSingle.getSelection()) {
                this.fTextStr.setText("//");
                this.fTextEnd.setText("");
                this.fTextNme.setText("__java_singleline_comment");
                this.fTextReg.setEnabled(false);
                this.fTextStr.setEnabled(false);
                this.fTextEnd.setEnabled(false);
                this.fTextNme.setEnabled(false);
                this.fCheckBase.setEnabled(false);
                this.fUseRegExp.setEnabled(false);
                this.fJavadoc.setEnabled(false);
                this.fJavaMulti.setEnabled(false);
            } else {
                this.fTextStr.setText("");
                this.fTextEnd.setText("");
                this.fTextNme.setText("");
                this.fTextReg.setEnabled(false);
                this.fTextStr.setEnabled(true);
                this.fTextEnd.setEnabled(true);
                this.fTextNme.setEnabled(true);
                this.fCheckBase.setEnabled(true);
                this.fUseRegExp.setEnabled(true);
                this.fJavadoc.setEnabled(true);
                this.fJavaMulti.setEnabled(true);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.fCheckBase = new Button(composite, 32);
        this.fCheckBase.setText(this.getMessage("pref.partition.dlg.base"));
        this.fCheckBase.setSelection(false);
        this.fCheckBase.addListener(13, (Listener)this);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fCheckBase.setLayoutData((Object)gridData);
        this.fUseRegExp = new Button(composite, 32);
        this.fUseRegExp.setText(this.getMessage("pref.partition.dlg.regexp"));
        this.fUseRegExp.setSelection(false);
        this.fUseRegExp.addListener(13, (Listener)this);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        this.fUseRegExp.setLayoutData((Object)gridData2);
        this.fJavadoc = new Button(composite, 32);
        this.fJavadoc.setText(this.getMessage("pref.partition.dlg.javadoc"));
        this.fJavadoc.setSelection(false);
        this.fJavadoc.addListener(13, (Listener)this);
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 2;
        this.fJavadoc.setLayoutData((Object)gridData3);
        this.fJavaMulti = new Button(composite, 32);
        this.fJavaMulti.setText(this.getMessage("pref.partition.dlg.javamulti"));
        this.fJavaMulti.setSelection(false);
        this.fJavaMulti.addListener(13, (Listener)this);
        GridData gridData4 = new GridData(768);
        gridData4.horizontalSpan = 2;
        this.fJavaMulti.setLayoutData((Object)gridData4);
        this.fJavaSingle = new Button(composite, 32);
        this.fJavaSingle.setText(this.getMessage("pref.partition.dlg.javasingle"));
        this.fJavaSingle.setSelection(false);
        this.fJavaSingle.addListener(13, (Listener)this);
        GridData gridData5 = new GridData(768);
        gridData5.horizontalSpan = 2;
        this.fJavaSingle.setLayoutData((Object)gridData5);
        this.fLabelStr = new Label(composite, 0);
        this.fLabelStr.setText(this.getMessage("pref.partition.dlg.start"));
        this.fTextStr = new Text(composite, 2048);
        this.fTextStr.setLayoutData((Object)new GridData(768));
        this.fLabelEnd = new Label(composite, 0);
        this.fLabelEnd.setText(this.getMessage("pref.partition.dlg.end"));
        this.fTextEnd = new Text(composite, 2048);
        this.fTextEnd.setLayoutData((Object)new GridData(768));
        this.fLabelReg = new Label(composite, 0);
        this.fLabelReg.setText(this.getMessage("pref.partition.dlg.expression"));
        this.fTextReg = new Text(composite, 2048);
        this.fTextReg.setLayoutData((Object)new GridData(768));
        this.fTextReg.setEnabled(false);
        this.fLabelKwd = new Label(composite, 0);
        this.fLabelKwd.setText(this.getMessage("pref.partition.dlg.name"));
        this.fTextNme = new Text(composite, 2048);
        this.fTextNme.setLayoutData((Object)new GridData(768));
        Label cLabelClr = new Label(composite, 0);
        cLabelClr.setText(this.getMessage("pref.partition.dlg.color"));
        this.fColorSel = new ColorSelector(composite);
        this.fColorSel.setColorValue(new RGB(0, 0, 0));
        this.fLabelBgc = new Label(composite, 0);
        this.fLabelBgc.setText(this.getMessage("pref.partition.dlg.bgcolor"));
        this.fColorBgc = new ColorSelector(composite);
        this.fColorBgc.setColorValue(new RGB(255, 255, 255));
        this.fColorBgc.setEnabled(false);
        this.fCheckGbc = new Button(composite, 32);
        this.fCheckGbc.setText(this.getMessage("pref.partition.dlg.usebgcolor"));
        this.fCheckGbc.addListener(13, (Listener)this);
        GridData gridData6 = new GridData(768);
        gridData6.horizontalSpan = 2;
        this.fCheckGbc.setLayoutData((Object)gridData6);
        this.fCheckIta = new Button(composite, 32);
        this.fCheckIta.setText(this.getMessage("pref.partition.dlg.italic"));
        this.fCheckIta.addListener(13, (Listener)this);
        this.fCheckBol = new Button(composite, 32);
        this.fCheckBol.setText(this.getMessage("pref.partition.dlg.bold"));
        this.fCheckBol.addListener(13, (Listener)this);
        this.fCheckStr = new Button(composite, 32);
        this.fCheckStr.setText(this.getMessage("pref.partition.dlg.strikethrough"));
        this.fCheckStr.addListener(13, (Listener)this);
        this.fCheckUnd = new Button(composite, 32);
        this.fCheckUnd.setText(this.getMessage("pref.partition.dlg.underline"));
        this.fCheckUnd.addListener(13, (Listener)this);
        if (this.fStyleEntry != null) {
            PartitionEntry pe = (PartitionEntry)this.fStyleEntry;
            this.fTextStr.setText(pe.getStart());
            this.fTextEnd.setText(pe.getEnd());
            this.fTextReg.setText(pe.getRegExp());
            this.fTextNme.setText(pe.getName());
            this.fColorSel.setColorValue(this.fStyleEntry.getRGB());
            if (this.fStyleEntry.isBgColor()) {
                this.fColorBgc.setColorValue(this.fStyleEntry.getBgRGB());
                this.fCheckGbc.setSelection(true);
                this.fColorBgc.setEnabled(true);
                this.fLabelBgc.setEnabled(true);
            } else {
                this.fColorBgc.setEnabled(false);
                this.fLabelBgc.setEnabled(false);
            }
            if (this.fStyleEntry.isItalic()) {
                this.fCheckIta.setSelection(true);
            }
            if (this.fStyleEntry.isBold()) {
                this.fCheckBol.setSelection(true);
            }
            if (this.fStyleEntry.isStrikeThrough()) {
                this.fCheckStr.setSelection(true);
            }
            if (this.fStyleEntry.isUnderline()) {
                this.fCheckUnd.setSelection(true);
            }
            Event e = new Event();
            if (this.fTextNme.getText().equals("__dftl_partition_content_type")) {
                this.fCheckBase.setSelection(true);
                e.widget = this.fCheckBase;
            }
            if (this.fTextNme.getText().equals("__java_javadoc")) {
                this.fJavadoc.setSelection(true);
                e.widget = this.fJavadoc;
            }
            if (this.fTextNme.getText().equals("__java_multiline_comment")) {
                this.fJavaMulti.setSelection(true);
                e.widget = this.fJavaMulti;
            }
            if (this.fTextNme.getText().equals("__java_singleline_comment")) {
                this.fJavaSingle.setSelection(true);
                e.widget = this.fJavaSingle;
            }
            if (!this.fTextReg.getText().equals("")) {
                this.fUseRegExp.setSelection(true);
                e.widget = this.fUseRegExp;
            }
            this.handleEvent(e);
        }
        return composite;
    }

    protected void okPressed() {
        String detected;
        if (this.fUseRegExp.getSelection() && (detected = StyleEditorTools.checkRegExp(this.fTextReg.getText())) != null) {
            MessageBox mb = new MessageBox(this.getShell());
            mb.setMessage(String.valueOf(detected) + " " + this.getMessage("pref.err.regexp"));
            mb.open();
            return;
        }
        RGB rgb = this.fColorSel.getColorValue();
        XMLNode node = new XMLNode("partition");
        node.setAttribute("name", this.fTextNme.getText());
        node.setAttribute("red", String.valueOf(rgb.red));
        node.setAttribute("green", String.valueOf(rgb.green));
        node.setAttribute("blue", String.valueOf(rgb.blue));
        if (this.fCheckGbc.getSelection()) {
            RGB brgb = this.fColorBgc.getColorValue();
            node.setAttribute("bgcolor", "true");
            node.setAttribute("bred", String.valueOf(brgb.red));
            node.setAttribute("bgreen", String.valueOf(brgb.green));
            node.setAttribute("bblue", String.valueOf(brgb.blue));
        } else {
            node.setAttribute("bgcolor", "false");
            node.setAttribute("bred", "");
            node.setAttribute("bgreen", "");
            node.setAttribute("bblue", "");
        }
        node.setAttribute("italic", String.valueOf(this.fCheckIta.getSelection()));
        node.setAttribute("bold", String.valueOf(this.fCheckBol.getSelection()));
        node.setAttribute("strikethrough", String.valueOf(this.fCheckStr.getSelection()));
        node.setAttribute("underline", String.valueOf(this.fCheckUnd.getSelection()));
        if (this.fUseRegExp.getSelection()) {
            node.setAttribute("start", "");
            node.setAttribute("end", "");
            node.setAttribute("regexp", this.fTextReg.getText());
        } else {
            node.setAttribute("start", this.fTextStr.getText());
            node.setAttribute("end", this.fTextEnd.getText());
            node.setAttribute("regexp", "");
        }
        if (this.fStyleEntry == null) {
            this.fStyleEntry = new PartitionEntry(node, this.fExtension);
        } else {
            StyleEditorTools.changePartitionEntry(this.fStyleEntry, node, this.fExtension);
        }
        this.fStyleContainer[0] = this.fStyleEntry;
        super.okPressed();
    }
}

