/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.CharKey;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.WrappedRuntimeException;

public class CharInfo {
    BitSet m_specialsMap = new BitSet(65535);
    private Hashtable m_charToEntityRef = new Hashtable();
    public static String HTML_ENTITIES_RESOURCE = "org.apache.xml.serializer.HTMLEntities";
    public static String XML_ENTITIES_RESOURCE = "org.apache.xml.serializer.XMLEntities";
    public static final char S_LINEFEED = '\n';
    public static char S_CARRIAGERETURN = (char)13;
    private CharKey m_charKey = new CharKey();
    static /* synthetic */ Class class$org$apache$xml$serializer$CharInfo;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CharInfo(String entitiesResource) {
        InputStream is = null;
        BufferedReader reader = null;
        PropertyResourceBundle entities = this.loadEntitiesResource(entitiesResource);
        if (null != entities) {
            Enumeration<String> enumeration = entities.getKeys();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    this.m_specialsMap.set(10);
                    this.m_specialsMap.set(S_CARRIAGERETURN);
                    return;
                }
                String name = enumeration.nextElement();
                String value = entities.getString(name);
                int code = Integer.parseInt(value);
                this.defineEntity(name, (char)code);
            }
        }
        try {
            try {
                try {
                    ClassLoader cl = (class$org$apache$xml$serializer$CharInfo == null ? (class$org$apache$xml$serializer$CharInfo = CharInfo.class$("org.apache.xml.serializer.CharInfo")) : class$org$apache$xml$serializer$CharInfo).getClassLoader();
                    is = cl == null ? ClassLoader.getSystemResourceAsStream(entitiesResource) : cl.getResourceAsStream(entitiesResource);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (is == null) {
                    is = (class$org$apache$xml$serializer$CharInfo == null ? (class$org$apache$xml$serializer$CharInfo = CharInfo.class$("org.apache.xml.serializer.CharInfo")) : class$org$apache$xml$serializer$CharInfo).getResourceAsStream(entitiesResource);
                }
                if (is == null) {
                    URL url = new URL(entitiesResource);
                    is = url.openStream();
                }
                if (is == null) {
                    throw new RuntimeException(XMLMessages.createXMLMessage("ER_RESOURCE_COULD_NOT_FIND", new Object[]{entitiesResource, entitiesResource}));
                }
                try {
                    reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    reader = new BufferedReader(new InputStreamReader(is));
                }
                String line = reader.readLine();
                while (true) {
                    if (line == null) {
                        is.close();
                        this.m_specialsMap.set(10);
                        this.m_specialsMap.set(S_CARRIAGERETURN);
                        break;
                    }
                    if (line.length() == 0 || line.charAt(0) == '#') {
                        line = reader.readLine();
                        continue;
                    }
                    int index = line.indexOf(32);
                    if (index > 1) {
                        String name = line.substring(0, index);
                        if (++index < line.length()) {
                            String value = line.substring(index);
                            if ((index = value.indexOf(32)) > 0) {
                                value = value.substring(0, index);
                            }
                            int code = Integer.parseInt(value);
                            this.defineEntity(name, (char)code);
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception except) {
                throw new RuntimeException(XMLMessages.createXMLMessage("ER_RESOURCE_COULD_NOT_LOAD", new Object[]{entitiesResource, except.toString(), entitiesResource, except.toString()}));
            }
            Object var12_18 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (Exception except) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception except) {}
        is.close();
        return;
    }

    protected void defineEntity(String name, char value) {
        CharKey character = new CharKey(value);
        this.m_charToEntityRef.put(character, name);
        this.m_specialsMap.set(value);
    }

    public synchronized String getEntityNameForChar(char value) {
        this.m_charKey.setChar(value);
        return (String)this.m_charToEntityRef.get(this.m_charKey);
    }

    public boolean isSpecial(char value) {
        return this.m_specialsMap.get(value);
    }

    public static CharInfo getCharInfo(String entitiesFileName) {
        CharInfo retobj = null;
        Hashtable getCharInfo_cache = HashtableHolder.m_getCharInfo_cache;
        retobj = (CharInfo)getCharInfo_cache.get(entitiesFileName);
        if (retobj == null) {
            try {
                retobj = new CharInfo(entitiesFileName);
                getCharInfo_cache.put(entitiesFileName, retobj);
            }
            catch (Exception e) {
                retobj = null;
            }
        }
        if (null == retobj) {
            String absoluteEntitiesFileName;
            if (entitiesFileName.indexOf(58) < 0) {
                absoluteEntitiesFileName = SystemIDResolver.getAbsoluteURIFromRelative(entitiesFileName);
            } else {
                try {
                    absoluteEntitiesFileName = SystemIDResolver.getAbsoluteURI(entitiesFileName, null);
                }
                catch (TransformerException te) {
                    throw new WrappedRuntimeException(te);
                }
            }
            retobj = new CharInfo(absoluteEntitiesFileName);
            getCharInfo_cache.put(entitiesFileName, retobj);
        }
        return retobj;
    }

    private PropertyResourceBundle loadEntitiesResource(String baseName) throws MissingResourceException {
        try {
            Locale locale = Locale.getDefault();
            ClassLoader loader = this.getClass().getClassLoader();
            return (PropertyResourceBundle)ResourceBundle.getBundle(baseName);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class HashtableHolder {
        private static Hashtable m_getCharInfo_cache = new Hashtable();

        private HashtableHolder() {
        }
    }
}

