/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/core/JavaStyleEditorActionContributor.java,v 1.7 2007/10/25 03:16:49 kohnosuke Exp $
 * $Revision: 1.7 $
 * $Date: 2007/10/25 03:16:49 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.core;

import java.lang.reflect.Constructor;

import jp.sourceforge.jeextension.styleeditor.StyleEditorPlugin;
import jp.sourceforge.jeextension.styleeditor.util.ReflectFactory;

import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

/**
 * ActionContributor for JavaStyleEditor.
 * @since 2.0.0
 * <!-- #IntID:00014 fix, Jeex Style Editor hold cursor position -->
 */
public class JavaStyleEditorActionContributor extends
org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditorActionContributor
implements ISourceViewerActivator {
    
    /** ActionContributorHelper */
    private final ActionContributorHelper fHelper;
    
    /**
     * Default Constructor.
     */
    public JavaStyleEditorActionContributor() {
        super();
        fHelper = new ActionContributorHelper(this);
    }
    /**
     * {@inheritDoc}
     */
    public void setActiveEditor(IEditorPart part) {
        
        // remove reconfiling listeners
        if (part != null) {
            ReflectFactory f1 = new ReflectFactory();
            f1.setTarget(part);
            f1.setClass("org.eclipse.jdt.internal.ui.javaeditor."
                    + "CompilationUnitEditor");
            f1.setName("fReconcilingListeners");
            Object fReconcilingListeners = f1.get();
            ReflectFactory f2 = new ReflectFactory();
            f2.setTarget(fReconcilingListeners);
            
            String version = StyleEditorPlugin.getRuntimeVersion();
            // 3.2.0 higher
            if (version.compareTo("3.2.0") > 0) {
                f2.setClass("org.eclipse.core.runtime.ListenerList");
            }
            // 3.2.0 equal or lower
            else {
                f2.setClass("org.eclipse.jface.util.ListenerList");
            }
            f2.setName("clear");
            f2.invoke();
        }
        
        fHelper.setActiveEditorPart(part);
        super.setActiveEditor(part);
    }
    
    /**
     * {@inheritDoc}
     */
    public void activate(ISourceViewer viewer, IDocument document,
            Class sourceViewerClass, IEditorPart part) {
        
        ReflectFactory f = new ReflectFactory();
        
        // SourceViewerConfiguration
        f.setTarget(part);
        f.setClass("org.eclipse.ui.texteditor.AbstractTextEditor");
        f.setName("getSourceViewerConfiguration");
        Object sourceViewerConfig = f.invoke();
        
        // IPreferenceStore
        f.setName("getPreferenceStore");
        Object preferenceStore = f.invoke();
        
        // IColorManager
        f.setTarget(sourceViewerConfig);
        f.setClass("org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration");
        f.setName("getColorManager");
        Object colorManager = f.invoke();
        
        // String (partitioning)
        f.setName("getConfiguredDocumentPartitioning");
        f.setType("org.eclipse.jface.text.source.ISourceViewer");
        f.setParam((Object) null);
        Object partitioning = f.invoke();
        
        // SourceViewerConfiguration instance
        Object instance = null;
        try {
            Constructor con = sourceViewerClass.getConstructor(new Class[] {
                    IColorManager.class,
                    IPreferenceStore.class,
                    ITextEditor.class,
                    String.class,
            });
            instance = con.newInstance(new Object[] {
                    colorManager,
                    preferenceStore,
                    part,
                    partitioning,
            });
        }
        catch (Exception e) {
            StyleEditorPlugin.log(e);
        }
        
        // offset, length
        ISelectionProvider selectionProvider =
            ((ITextEditor) part).getSelectionProvider();
        ITextSelection selection =
            (ITextSelection) selectionProvider.getSelection();
        int offset = selection.getOffset();
        int length = selection.getLength();
        
        // configure
        if (viewer instanceof ISourceViewerExtension2) {
            ((ISourceViewerExtension2) viewer).unconfigure();
            viewer.configure((SourceViewerConfiguration) instance);
        }
        
        // repaint
        viewer.setDocument(document, viewer.getAnnotationModel());
        
        // re:set offset, length
        selectionProvider.setSelection(new TextSelection(offset, length));
        
        StyleEditorCore core = StyleEditorPlugin.getDefault().getCore();
        core.setActiveViewerConfig(viewer,
                (SourceViewerConfiguration) instance);
        
    }
    
}
