/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/core/StyleEditorDamagerRepairer.java,v 1.3 2007/10/25 03:16:49 kohnosuke Exp $
 * $Revision: 1.3 $
 * $Date: 2007/10/25 03:16:49 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.core;

import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;

/**
 * Fixed DefaultDamagerRepairer for StyleEditor.
 * @since 2.0.0
 */
public class StyleEditorDamagerRepairer extends DefaultDamagerRepairer {
    
    /**
     * Constractor.
     * @param scanner ITokenScanner
     */
    public StyleEditorDamagerRepairer(ITokenScanner scanner) {
        super(scanner);
    }
    
    /**
     * {@inheritDoc}
     */
    public void createPresentation(TextPresentation presentation,
            ITypedRegion region) {
        
        if (fScanner == null) {
            // will be removed if deprecated constructor will be removed
            addRange(presentation, region.getOffset(),
                    region.getLength(), fDefaultTextAttribute);
            return;
        }
        
        int lastStart = region.getOffset();
        int length = 0;
        boolean firstToken = true;
        IToken lastToken = Token.UNDEFINED;
        TextAttribute lastAttribute = getTokenTextAttribute(lastToken);
        
        fScanner.setRange(fDocument, lastStart, region.getLength());
        
        while (true) {
            IToken token = fScanner.nextToken();         
            if (token.isEOF()) {
                break;
            }
            TextAttribute attribute = getTokenTextAttribute(token);          
            if (lastAttribute != null && lastAttribute.equals(attribute)) {
                length += fScanner.getTokenLength();
                if (firstToken) {
                    lastAttribute = attribute;
                }
                firstToken = false;
            } else {
                if (!firstToken) {
                    addRange(presentation, lastStart, length, lastAttribute);
                }
                firstToken = false;
                lastToken = token;
                lastAttribute = attribute;
                lastStart = fScanner.getTokenOffset();
                length = fScanner.getTokenLength();                          
            }
        }

        addRange(presentation, lastStart, length, lastAttribute);
    }
}
