/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/entry/IDependsEntry.java,v 1.4 2007/10/25 03:16:49 kohnosuke Exp $
 * $Revision: 1.4 $
 * $Date: 2007/10/25 03:16:49 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.entry;

/**
 * IDependsEntry
 * @since 1.0.0
 */
public interface IDependsEntry extends IEntry {
    /**
     * Returns depends parition entry.
     * @return depends parition entry.
     */
    IPartitionEntry getDepends();
    
    /**
     * Returns keywords.
     * @return words length { multiLine=2 | singleLine=2 | endOfLine=1
     *         keyword=1 }
     */
    String[] getWords();
    
    /**
     * Set depends parition entry.
     * @param depends depends parition entry.
     */
    void setDepends(IPartitionEntry depends);
    
    /**
     * Set keywords.
     * @param words words length { multiLine=2 | singleLine=2 | endOfLine=1
     *              keyword=1 }
     */
    void setWords(String[] words);
}
