﻿//**************************************************************//
//  Effect File exported by RenderMonkey 1.6
//
//  - Although many improvements were made to RenderMonkey FX 
//    file export, there are still situations that may cause  
//    compilation problems once the file is exported, such as 
//    occasional naming conflicts for methods, since FX format
//    does not support any notions of name spaces. You need to
//    try to create workspaces in such a way as to minimize   
//    potential naming conflicts on export.                   
//   
//  - Note that to minimize resulting name collisions in the FX
//    file, RenderMonkey will mangle names for passes, shaders 
//    and function names as necessary to reduce name conflicts.
//**************************************************************//
//--------------------------------------------------------------//
// Textured
//--------------------------------------------------------------//
//--------------------------------------------------------------//
// Pass 0
//--------------------------------------------------------------//

#define MAX_SHADER_INSTANCE_COUNT 50


float4x4 World[MAX_SHADER_INSTANCE_COUNT];


float4x4 View ;
float4x4 Projection;



struct VS_INPUT
{
	float4 Position : POSITION0;
	float2 texcode : TEXCOORD0;
	//float  tgtindex : TEXCOORD1;
};

struct VS_OUTPUT
{
   float4 Position : POSITION0;
   float2 Texcoord : TEXCOORD0;
   float4 defCol   : TEXCOORD1;
};
 
struct VS_Temp
{
	float3	Position;
	float3	Siz3d;
	float	Siz1d;
	float3	vect;
	float2	AddUvPos;
	float4	defCol;
};


//Matrix配列を分解し、必要なものを取り出す
VS_Temp sepalateMX(float tgtIndex)
{
	VS_Temp outs;
	
	outs.Position = float3(World[tgtIndex]._11,World[tgtIndex]._12,World[tgtIndex]._13);
	
	outs.vect = float3(World[tgtIndex]._21,World[tgtIndex]._22,World[tgtIndex]._23);
	
	outs.Siz3d = float3(World[tgtIndex]._31,World[tgtIndex]._32,World[tgtIndex]._33);
	outs.Siz1d = float(World[tgtIndex]._34);

	outs.AddUvPos = float2(World[tgtIndex]._14,World[tgtIndex]._24);
	outs.defCol = float4(World[tgtIndex]._41,World[tgtIndex]._42,World[tgtIndex]._43,World[tgtIndex]._44);
	
	return outs;
}


VS_OUTPUT vs_main( VS_INPUT Input , float tgtindex : TEXCOORD1 )
{
   VS_OUTPUT Output;
   VS_Temp temps  = sepalateMX(tgtindex);
      
   float4x4 nowWld =  float4x4(1,0,0,0,
						0,1,0,0,
						0,0,1,0,
						temps.Position.x,temps.Position.y,temps.Position.z,1);
   
	float4x4 worldViewMatrix = mul(nowWld, View);
	float3 positionVS = Input.Position * temps.Siz1d  + float3(worldViewMatrix._41, worldViewMatrix._42, worldViewMatrix._43);
	Output.Position = mul(float4(positionVS, 1.0f), Projection);

   Output.Texcoord = Input.texcode + temps.AddUvPos;
   Output.defCol = temps.defCol;
   return Output;
   
}


texture MyTexture;
sampler2D baseMap = sampler_state
{
   Texture = (MyTexture);
   ADDRESSU = WRAP;
   ADDRESSV = WRAP;
   MINFILTER = LINEAR;
   MAGFILTER = LINEAR;
};

struct PS_INPUT
{
   float2 Texcoord : TEXCOORD0;
   float4 defCol   : TEXCOORD1;
};

float4 Textured_Pass_0_Pixel_Shader_ps_main( PS_INPUT Input ) : COLOR0
{
	float4 Col =  tex2D( baseMap, Input.Texcoord ).rgba;

	Col = Col * Input.defCol;

	return Col;
  
}
 

//--------------------------------------------------------------//
// Technique Section for Textured
//--------------------------------------------------------------//
technique Textured
{
   pass Pass_0
   {
      VertexShader = compile vs_2_0 vs_main();
      PixelShader = compile ps_2_0 Textured_Pass_0_Pixel_Shader_ps_main();
   }
}
 