#region Using Xe[gg

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

#endregion

namespace DebugSample
{
    /// <summary>
    /// CPUx̃A^Cpc[
    /// </summary>
    /// <remarks>
    /// ̃c[gƂŃ{glbN̔ƁAƂǂꂾ̏ł̂
    /// oIɔB
    /// ܂AA^Cvt@C[Ȃ̂ŃQ[ɏuԓIɑʂ̏ꍇ
    /// lqc邱ƂłB
    /// 
    /// TimeRulerT|[gĂ@\͈ȉ̒ʂ:
    ///  * ő8(ύX)̃o[\
    ///  * e}[J[ɔCӂ̐F邱Ƃł
    ///  * }[J[O\@\
    ///  * TRACEݒOBeginMark/EndMark̃\bȟĂяôȂ
    ///  * ő32(ύX)BeginMark̃lXgĂяoɑΉ
    ///  * }`XbhΉ
    ///  * ׏Ԃɂ\t[̎ω@\
    ///  
    /// {IȎgp@́AGame.ComponentsTimeRuler̃CX^XǉA
    /// Game.Update\bh̐擪timerRuler.StartFrame()\bhĂԂ悤ɂB
    /// 
    /// ͑肵̑OBeginMark,EndMarkĂяoB
    /// 
    /// timeRuler.BeginMark( "Update", Color.Blue );
    /// // 肵
    /// timerRuler.EndMark( "Update" );
    /// 
    /// ܂ABeginMarkɂ͑茋ʂ\o[̃CfbNXwł(Kl0)
    /// 
    /// timeRuler.BeginMark( 1, "Update", Color.Blue );
    /// 
    /// vt@CɎgp郁\bĥɂConditionalAttributew肵Ă̂ŁA
    /// BeginMark/EndMark̃\bhTRACEݒ肳ĂȂƃ\bhĂяõR[h
    /// 𐶐Ȃ悤ɂȂĂBۂ̃[Xɂ̓rhݒ
    /// TRACE萔̒`̃`FbN{bNXNÂYȂ悤ɂ邱ƁB
    /// 
    /// </remarks>
    public class TimeRuler : DrawableGameComponent
    {
        #region 萔錾

        /// <summary>
        /// őo[\
        /// </summary>
        const int MaxBars = 8;

        /// <summary>
        /// o[ЂƂ̍őTv
        /// </summary>
        const int MaxSamples = 256;

        /// <summary>
        /// o[ЂƂ̍őlXg
        /// </summary>
        const int MaxNestCall = 32;

        /// <summary>
        /// ő\t[
        /// </summary>
        const int MaxSampleFrames = 4;

        /// <summary>
        /// ÕXibvԊu(t[)
        /// </summary>
        const int LogSnapDuration = 120;

        /// <summary>
        /// o[̍(sNZ)
        /// </summary>
        const int BarHeight = 8;

        /// <summary>
        /// o[̃pfBO(sNZ)
        /// </summary>
        const int BarPadding = 2;

        /// <summary>
        /// \t[Ɋ|t[
        /// </summary>
        const int AutoAdjustDelay = 30;

        #endregion

        #region vpeB

        /// <summary>
        /// O̕\ݒ̐ݒƎ擾
        /// </summary>
        public bool ShowLog { get; set; }

        /// <summary>
        /// ڕW\t[̎擾Ɛݒ
        /// </summary>
        public int TargetSampleFrames { get; set; }

        /// <summary>
        /// TimeRuler`ʒu̎擾Ɛݒ
        /// </summary>
        public Vector2 Position { get { return position; } set { position = value; } }

        /// <summary>
        /// TimeRuler`敝̎擾Ɛݒ
        /// </summary>
        public int Width { get; set; }

        #endregion

        #region tB[h

#if TRACE

        /// <summary>
        /// }[J[\
        /// </summary>
        private struct Marker
        {
            public int MarkerId;
            public float BeginTime;
            public float EndTime;
            public Color Color;
        }

        /// <summary>
        /// }[J[RNV
        /// </summary>
        private class MarkerCollection
        {
            // }[J[RNV
            public Marker[] Markers = new Marker[MaxSamples];
            public int MarkCount;

            // }[J[lXg
            public int[] MarkerNests = new int[MaxNestCall];
            public int NestCount;
        }

        /// <summary>
        /// t[̃O
        /// </summary>
        private class FrameLog
        {
            // o[
            public MarkerCollection[] Bars;

            public FrameLog()
            {
                // }[J[RNVz̏
                Bars = new MarkerCollection[MaxBars];
                for ( int i = 0; i < MaxBars; ++i )
                    Bars[i] = new MarkerCollection();
            }
        }

        /// <summary>
        /// }[J[
        /// </summary>
        private class MarkerInfo
        {
            // }[J[
            public string Name;

            // }[J[O
            public MarkerLog[] Logs = new MarkerLog[MaxBars];

            public MarkerInfo( string name )
            {
                Name = name;
            }
        }

        /// <summary>
        /// }[J[O
        /// </summary>
        private struct MarkerLog
        {
            public float SnapMin;
            public float SnapMax;
            public float SnapAvg;

            public float Min;
            public float Max;
            public float Avg;

            public int Samples;

            public bool Initialized;
        }

        // fobO}l[W[
        DebugManager debugManager;

        // t[̃O
        FrameLog[] logs;

        // Ot[̃O
        FrameLog prevLog;

        // 蒆̃t[O
        FrameLog curLog;

        // ݂̃t[
        int frameCount;

        // vɎgpXgbvEHb`
        Stopwatch stopwatch = new Stopwatch();

        // }[J[z
        List<MarkerInfo> markers = new List<MarkerInfo>();

        // }[J[}[J[IDւ̕ϊ}bv
        Dictionary<string, int> markerNameToIdMap = new Dictionary<string, int>();

        // Tvt[p̃JE^
        int frameAdjust;

        // ݂̕\t[
        int sampleFrames;

        // }[J[O\
        StringBuilder logString = new StringBuilder( 512 );

#endif
        // TimerRuler̕\ʒu
        Vector2 position;

        #endregion

        #region 

        public TimeRuler( Game game )
            : base( game )
        {
            // T[rXƂēo^
            // timeLine.BeginMarkgĂ郉CTRACEݒȂ̏ꍇłcĂ
            // ꍇ̂ŁAT[rXo^͕KvɂȂ
            Game.Services.AddService( typeof( TimeRuler ), this );
        }

        public override void Initialize()
        {
#if TRACE
            debugManager =
                Game.Services.GetService( typeof( DebugManager ) ) as DebugManager;

            if ( debugManager == null )
                throw new InvalidOperationException( "DebugManagero^Ă܂" );

            // DebugCommandHosto^Ă̂ȂAR}ho^
            IDebugCommandHost host =
                                Game.Services.GetService( typeof( IDebugCommandHost ) )
                                                                    as IDebugCommandHost;

            if ( host != null )
            {
                host.RegisterCommand( "tr", "TimeRuler", this.CommandExecute );
                this.Visible = false;
                this.Enabled = false;
            }

            // p[^[̏
            logs = new FrameLog[2];
            for ( int i = 0; i < logs.Length; ++i )
                logs[i] = new FrameLog();

            sampleFrames = TargetSampleFrames = 1;
#endif
            base.Initialize();
        }

        protected override void LoadContent()
        {
            Width = (int)( GraphicsDevice.Viewport.Width * 0.8f );

            Layout layout = new Layout( GraphicsDevice.Viewport );
            position = layout.Place( new Vector2( Width, BarHeight ),
                                                    0, 0.01f, Alignment.BottomCenter );

            base.LoadContent();
        }

#if TRACE
        /// <summary>
        /// TimeRulerR}h
        /// </summary>
        void CommandExecute( IDebugCommandHost host, string command,
                                                                IList<string> arguments )
        {
            if ( arguments.Count == 0 )
                Visible = !Visible;

            char[] subArgSeparator = new[] { ':' };
            foreach ( string orgArg in arguments )
            {
                string arg = orgArg.ToLower();
                string[] subargs = arg.Split( subArgSeparator );
                switch ( subargs[0] )
                {
                case "on":
                    Visible = true;
                    break;
                case "off":
                    Visible = false;
                    break;
                case "reset":
                    ResetLog();
                    break;
                case "log":
                    if ( subargs.Length > 1 )
                    {
                        if ( String.Compare( subargs[1], "on" ) == 0 )
                            ShowLog = true;
                        if ( String.Compare( subargs[1], "off" ) == 0 )
                            ShowLog = false;
                    }
                    else
                    {
                        ShowLog = !ShowLog;
                    }
                    break;
                case "frame":
                    int a = Int32.Parse( subargs[1] );
                    a = Math.Max( a, 1 );
                    a = Math.Min( a, MaxSampleFrames );
                    TargetSampleFrames = a;
                    break;
                case "/?":
                case "--help":
                    host.Echo( "tr [log|on|off|reset|frame]" );
                    host.Echo( "Options:" );
                    host.Echo( "       on     Display TimeRuler." );
                    host.Echo( "       off    Hide TimeRuler." );
                    host.Echo( "       log    Show/Hide marker log." );
                    host.Echo( "       reset  Reset marker log." );
                    host.Echo( "       frame:sampleFrames" );
                    host.Echo( "              Change target sample frame count" );
                    break;
                default:
                    break;
                }
            }
        }
#endif

        #endregion

        #region p\bh

        /// <summary>
        /// Vt[̊Jn
        /// </summary>
        [Conditional( "TRACE" )]
        public void StartFrame()
        {
#if TRACE
            lock ( this )
            {
                // ݂̃t[O̍XV
                prevLog = logs[frameCount++ & 0x1];
                curLog = logs[frameCount & 0x1];

                float endFrameTime = (float)stopwatch.Elapsed.TotalMilliseconds;

                // }[J[̍XVƃO
                for ( int barIdx = 0; barIdx < prevLog.Bars.Length; ++barIdx )
                {
                    MarkerCollection prevBar = prevLog.Bars[barIdx];
                    MarkerCollection nextBar = curLog.Bars[barIdx];

                    // Ot[EndMarkĂłȂ}[J[At[
                    // ēxJB
                    for ( int nest = 0; nest < prevBar.NestCount; ++nest )
                    {
                        int markerIdx = prevBar.MarkerNests[nest];

                        prevBar.Markers[markerIdx].EndTime = endFrameTime;

                        nextBar.MarkerNests[nest] = nest;
                        nextBar.Markers[nest].MarkerId =
                            prevBar.Markers[markerIdx].MarkerId;
                        nextBar.Markers[nest].BeginTime = 0;
                        nextBar.Markers[nest].EndTime = -1;
                        nextBar.Markers[nest].Color = prevBar.Markers[markerIdx].Color;
                    }

                    // }[J[O̍XV
                    for ( int markerIdx = 0; markerIdx < prevBar.MarkCount; ++markerIdx )
                    {
                        float duration = prevBar.Markers[markerIdx].EndTime -
                                            prevBar.Markers[markerIdx].BeginTime;

                        int markerId = prevBar.Markers[markerIdx].MarkerId;
                        MarkerInfo m = markers[markerId];

                        if ( !m.Logs[barIdx].Initialized )
                        {
                            // ŏ̃t[̏
                            m.Logs[barIdx].Min = duration;
                            m.Logs[barIdx].Max = duration;
                            m.Logs[barIdx].Avg = duration;

                            m.Logs[barIdx].Initialized = true;
                        }
                        else
                        {
                            // Qt[ڈȍ~̏
                            m.Logs[barIdx].Min = Math.Min( m.Logs[barIdx].Min, duration );
                            m.Logs[barIdx].Max = Math.Min( m.Logs[barIdx].Max, duration );
                            m.Logs[barIdx].Avg += duration;
                            m.Logs[barIdx].Avg *= 0.5f;

                            if ( m.Logs[barIdx].Samples++ >= LogSnapDuration )
                            {
                                m.Logs[barIdx].SnapMin = m.Logs[barIdx].Min;
                                m.Logs[barIdx].SnapMax = m.Logs[barIdx].Max;
                                m.Logs[barIdx].SnapAvg = m.Logs[barIdx].Avg;
                                m.Logs[barIdx].Samples = 0;
                            }
                        }
                    }

                    nextBar.MarkCount = prevBar.NestCount;
                    nextBar.NestCount = prevBar.NestCount;
                }

                // ̃t[̑Jn
                stopwatch.Reset();
                stopwatch.Start();
            }
#endif
        }

        /// <summary>
        /// }[J[̊Jn
        /// </summary>
        /// <param name="markerName">}[J[</param>
        /// <param name="color">J[</param>
        [Conditional( "TRACE" )]
        public void BeginMark( string markerName, Color color )
        {
#if TRACE
            BeginMark( 0, markerName, color );
#endif
        }

        /// <summary>
        /// }[J[̊Jn
        /// </summary>
        /// <param name="barIndex">o[̃CfbNXl</param>
        /// <param name="markerName">}[J[</param>
        /// <param name="color">J[</param>
        [Conditional( "TRACE" )]
        public void BeginMark( int barIndex, string markerName, Color color )
        {
#if TRACE
            lock ( this )
            {
                if ( barIndex < 0 || barIndex >= MaxBars )
                    throw new ArgumentOutOfRangeException( "barIndex" );

                MarkerCollection bar = curLog.Bars[barIndex];

                if ( bar.MarkCount >= MaxSamples )
                {
                    throw new OverflowException(
                        "TvMaxSample𒴂܂B\n" +
                        "TimeRuler.MaxSmpale̒l傫邩A" +
                        "TvȂĂB" );
                }

                if ( bar.NestCount >= MaxNestCall )
                {
                    throw new OverflowException(
                        "lXgMaxNestCall𒴂܂B\n" +
                        "TimeRuler.MaxNestCall̒l傫邩A" +
                        "lXgĂяo炵ĂB" );
                }

                // o^Ă}[J[擾
                int markerId;
                if ( !markerNameToIdMap.TryGetValue( markerName, out markerId ) )
                {
                    // o^ĂȂΐVɓo^
                    markerId = markers.Count;
                    markerNameToIdMap.Add( markerName, markerId );
                    markers.Add( new MarkerInfo( markerName ) );
                }

                // Jn
                bar.MarkerNests[bar.NestCount++] = bar.MarkCount;

                // }[J[̃p[^[ݒ
                bar.Markers[bar.MarkCount].MarkerId = markerId;
                bar.Markers[bar.MarkCount].Color = color;
                bar.Markers[bar.MarkCount].BeginTime =
                                        (float)stopwatch.Elapsed.TotalMilliseconds;

                bar.Markers[bar.MarkCount].EndTime = -1;

                bar.MarkCount++;
            }
#endif
        }

        /// <summary>
        /// }[J[̏I
        /// </summary>
        /// <param name="markerName">}[J[</param>
        [Conditional( "TRACE" )]
        public void EndMark( string markerName )
        {
#if TRACE
            EndMark( 0, markerName );
#endif
        }

        /// <summary>
        /// }[J[̏I
        /// </summary>
        /// <param name="barIndex">o[̃CfbNXl</param>
        /// <param name="markerName">}[J[</param>
        [Conditional( "TRACE" )]
        public void EndMark( int barIndex, string markerName )
        {
#if TRACE
            lock ( this )
            {
                if ( barIndex < 0 || barIndex >= MaxBars )
                    throw new ArgumentOutOfRangeException( "barIndex" );

                MarkerCollection bar = curLog.Bars[barIndex];

                if ( bar.NestCount <= 0 )
                {
                    throw new InvalidOperationException(
                        "EndMarkĂяoOɁABeginMark\bhĂłB" );
                }

                int markerId;
                if ( !markerNameToIdMap.TryGetValue( markerName, out markerId ) )
                {
                    throw new InvalidOperationException(
                        String.Format( "}[J[u{0}v͓o^Ă܂B" +
                            "BeginMarkŎgOƓOmFĂB",
                            markerName ) );
                }

                int markerIdx = bar.MarkerNests[--bar.NestCount];
                if ( bar.Markers[markerIdx].MarkerId != markerId )
                {
                    throw new InvalidOperationException(
                    "BeginMark/EndMarǩĂяosłB" +
                    "BeginMark(A), BeginMark(B), EndMark(B), EndMark(A)" +
                    "̂悤ɂ͌Ăׂ܂A" +
                    "BeginMark(A), BeginMark(B), EndMark(A), EndMark(B)̂悤ɂ" +
                    "Ăׂ܂B" );
                }

                bar.Markers[markerIdx].EndTime =
                    (float)stopwatch.Elapsed.TotalMilliseconds;
            }
#endif
        }

        /// <summary>
        /// }[J[ÕZbg
        /// </summary>
        [Conditional( "TRACE" )]
        public void ResetLog()
        {
#if TRACE
            lock ( this )
            {
                foreach ( MarkerInfo markerInfo in markers )
                {
                    for ( int i = 0; i < markerInfo.Logs.Length; ++i )
                    {
                        markerInfo.Logs[i].Initialized = false;
                        markerInfo.Logs[i].SnapMin = 0;
                        markerInfo.Logs[i].SnapMax = 0;
                        markerInfo.Logs[i].SnapAvg = 0;

                        markerInfo.Logs[i].Min = 0;
                        markerInfo.Logs[i].Max = 0;
                        markerInfo.Logs[i].Avg = 0;

                        markerInfo.Logs[i].Samples = 0;
                    }
                }
            }
#endif
        }

        #endregion

        #region `

        public override void Draw( GameTime gameTime )
        {
            Draw( position, Width );
            base.Draw( gameTime );
        }

        [Conditional( "TRACE" )]
        public void Draw( Vector2 position, int width )
        {
#if TRACE
            // DebugManagerSpriteBatch, SpriteFont, WhiteTexture
            SpriteBatch spriteBatch = debugManager.SpriteBatch;
            SpriteFont font = debugManager.DebugFont;
            Texture2D texture = debugManager.WhiteTexture;

            // \ׂo[̐ɂĕ\TCYƈʒuύX
            int height = 0;
            float maxTime = 0;
            foreach ( MarkerCollection bar in prevLog.Bars )
            {
                if ( bar.MarkCount > 0 )
                {
                    height += BarHeight + BarPadding * 2;
                    maxTime = Math.Max( maxTime,
                                            bar.Markers[bar.MarkCount - 1].EndTime );
                }
            }

            // \t[̎
            // Ⴆ16.6msŏԂɍȂԂ莞Ԉȏ㑱
            // Iɕ\鎞ԊԊu33.3msɒ
            const float frameSpan = 1.0f / 60.0f * 1000f;
            float sampleSpan = (float)sampleFrames * frameSpan;

            if ( maxTime > sampleSpan )
                frameAdjust = Math.Max( 0, frameAdjust ) + 1;
            else
                frameAdjust = Math.Min( 0, frameAdjust ) - 1;

            if ( Math.Abs( frameAdjust ) > AutoAdjustDelay )
            {
                sampleFrames = Math.Min( MaxSampleFrames, sampleFrames );
                sampleFrames =
                    Math.Max( TargetSampleFrames, (int)( maxTime / frameSpan ) + 1 );

                frameAdjust = 0;
            }

            // ~bsNZɕϊWvZ
            float msToPs = (float)width / sampleSpan;

            // `Jnʒu
            int startY = (int)position.Y - ( height - BarHeight );

            // ݂yW
            int y = startY;

            spriteBatch.Begin();

            // wi̔̋``
            Rectangle rc = new Rectangle( (int)position.X, y, width, height );
            spriteBatch.Draw( texture, rc, new Color( 0, 0, 0, 128 ) );

            // eo[̃}[J[`
            rc.Height = BarHeight;
            foreach ( MarkerCollection bar in prevLog.Bars )
            {
                rc.Y = y + BarPadding;
                if ( bar.MarkCount > 0 )
                {
                    for ( int j = 0; j < bar.MarkCount; ++j )
                    {
                        float bt = bar.Markers[j].BeginTime;
                        float et = bar.Markers[j].EndTime;
                        int sx = (int)( position.X + bt * msToPs );
                        int ex = (int)( position.X + et * msToPs );
                        rc.X = sx;
                        rc.Width = Math.Max( ex - sx, 1 );

                        spriteBatch.Draw( texture, rc, bar.Markers[j].Color );
                    }
                }

                y += BarHeight + BarPadding;
            }

            // Obh`悷
            // ~bPʂ̃Obh`
            rc = new Rectangle( (int)position.X, (int)startY, 1, height );
            for ( float t = 1.0f; t < sampleSpan; t += 1.0f )
            {
                rc.X = (int)( position.X + t * msToPs );
                spriteBatch.Draw( texture, rc, Color.Gray );
            }

            // t[Pʂ̃Obh`
            for ( int i = 0; i <= sampleFrames; ++i )
            {
                rc.X = (int)( position.X + frameSpan * (float)i * msToPs );
                spriteBatch.Draw( texture, rc, Color.White );
            }

            // O̕\
            if ( ShowLog )
            {
                // \镶StringBuilderŐ
                y = startY - font.LineSpacing;
                logString.Length = 0;
                foreach ( MarkerInfo markerInfo in markers )
                {
                    for ( int i = 0; i < MaxBars; ++i )
                    {
                        if ( markerInfo.Logs[i].Initialized )
                        {
                            if ( logString.Length > 0 )
                                logString.Append( "\n" );

                            logString.Append( " Bar " );
                            logString.AppendNumber( i );
                            logString.Append( " " );
                            logString.Append( markerInfo.Name );

                            logString.Append( " Avg.:" );
                            logString.AppendNumber( markerInfo.Logs[i].SnapAvg );
                            logString.Append( "ms " );

                            y -= font.LineSpacing;
                        }
                    }
                }

                // \镶̔wi̋`TCY̌vZƕ`
                Vector2 size = font.MeasureString( logString );
                rc = new Rectangle( (int)position.X, (int)y, (int)size.X, (int)size.Y );
                spriteBatch.Draw( texture, rc, new Color( 0, 0, 0, 128 ) );

                // O̕`
                spriteBatch.DrawString( font, logString,
                                        new Vector2( position.X, y ), Color.White );
            }

            spriteBatch.End();
#endif
        }

        #endregion

    }
}
