﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;

namespace JF_Particle
{

    /// <summary>
    /// 乱数用クラス
    /// </summary>
    public class Randoms
    {
        public const int rand_MAX = 1000;

        private int roop_I;

        private uint[] RandInt;

        /// <summary>
        /// 配列添え字を再設定する
        /// </summary>
        public void ReRandomsIndex()
        {
            roop_I += (int)GetRand(100);
            if (roop_I >= rand_MAX)
            {
                roop_I = 0;
            }
        }


        /// <summary>
        /// 乱数初期化
        /// </summary>
        public Randoms()
        {
            Random random = new Random();
            RandInt = new uint[rand_MAX];
            for (int i = 0; i < rand_MAX; i++)
            {
                RandInt[i] = (uint)random.Next();
            }
            roop_I = 0;
        }
        /// <summary>
        /// 定義済み乱数を取得する
        /// </summary>
        /// <param name="int_max">乱数の最大値。この数までの範囲内の数値を取得する。</param>
        /// <returns></returns>
        public void GetRand(ref int int_max)
        {
            if (int_max < 1) int_max = 100;
            uint tmpint;
            tmpint = RandInt[roop_I];
            roop_I++;
            if (roop_I == rand_MAX)
            {
                roop_I = 0;
            }
            int_max =  (int)(tmpint % int_max);
        }

        /// <summary>
        /// 定義済み乱数を取得する
        /// </summary>
        /// <param name="int_max">乱数の最大値。この数までの範囲内の数値を取得する。</param>
        /// <returns></returns>
        public uint GetRand(int int_max)
        {
            if (int_max < 1) int_max = 100;
            uint tmpint;
            tmpint = RandInt[roop_I];
            roop_I++;
            if (roop_I == rand_MAX)
            {
                roop_I = 0;
            }
            return (uint)(tmpint % int_max);
        }

        /// <summary>
        /// 定義済み乱数を取得する
        /// </summary>
        /// <param name="int_max">乱数の最大値。この数までの範囲内の数値を取得する。</param>
        /// <returns></returns>
        public uint GetRand100()
        {
            uint tmpint;
            tmpint = RandInt[roop_I];
            roop_I++;
            if (roop_I == rand_MAX)
            {
                roop_I = 0;
            }
            return (uint)(tmpint % 100);
        }

        /// <summary>
        /// 乱数取得基本。テーブル内の乱数をそのまま返す
        /// </summary>
        /// <returns></returns>
        public uint GetRand()
        {
            uint tmpint;
            tmpint = RandInt[roop_I];
            roop_I++;
            if (roop_I == rand_MAX)
            {
                roop_I = 0;
            }
            return tmpint;
        }

        /// <summary>
        /// 中心位置からランダムな位置を取得する
        /// </summary>
        /// <param name="centerP"></param>
        /// <param name="x_fact"></param>
        /// <param name="z_fact"></param>
        /// <returns></returns>
        public Vector3 GetRandPoint(Vector3 centerP, ref  int x_fact, ref int z_fact)
        {
            float x, z;

            x = GetRand(x_fact * 2) - x_fact;
            z = GetRand(z_fact * 2) - z_fact;

            return new Vector3(x, 0, z);
        }

    }
}
