/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.jetplume.cms.portlets;

import java.util.Collection;
import java.util.Iterator;

import javax.portlet.PortletConfig;
import javax.portlet.PortletException;

import org.apache.commons.lang.StringUtils;
import org.apache.portals.bridges.common.GenericServletPortlet;

import org.apache.portals.graffito.ContentModelService;
import org.apache.portals.graffito.exception.ContentManagementException;
import org.apache.portals.graffito.model.CmsObject;
import org.apache.portals.graffito.model.Document;
import org.apache.portals.graffito.model.Folder;
import org.apache.portals.graffito.portlets.util.ServiceAccessor;

/**
 * CMS Tree Portlet
 * 
 * @author <a href="mailto:shinsuke@apache.org">Shinsuke Sugaya </a>
 * @version $Id: GenericCmsServletPortlet.java,v 1.1 2005/04/19 22:17:12
 *           shinsuke Exp $
 */
public abstract class GenericCmsServletPortlet extends GenericServletPortlet
{
    public final static String CURRENT_URI = "current_uri";

    public final static String CURRENT_FILE = "current_file";

    public final static String DEFAULT_SCOPE = "/graffito";

    protected ContentModelService cms;

    private String scope;

    public void init(PortletConfig config) throws PortletException
    {
        super.init(config);

        cms = ServiceAccessor.getModelService();
        if (cms == null)
        {
            throw new PortletException("Failed to load CMS service");
        }

        setScope(config.getInitParameter("scope"));
        if (getScope() == null)
        {
            setScope(DEFAULT_SCOPE);
        }
    }

    protected CmsObject getSiteObject(String uri)
    {
        System.out.println("TEST: getSiteObject: uri=" + uri);
        if (uri != null)
        {
            // 0:scope, 1:site, 2:category, 3:menu
            String path[] = StringUtils.split(uri, CmsObject.URI_SEPARATOR);
            if (path.length > 1)
            {
                System.out.println("TEST: getSiteObject: path[1]=" + path[1]);
                try
                {
                    Folder siteFolder = cms.getFolder(getScope() + CmsObject.URI_SEPARATOR + path[1]);
                    System.out.println("TEST: getSiteObject: path=" + getScope() + CmsObject.URI_SEPARATOR + path[1]
                            + ", siteFolder=" + siteFolder);
                    if (siteFolder != null)
                    {
                        return getCategoryObject(siteFolder, uri);
                    }
                }
                catch (ContentManagementException e)
                {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        }

        try
        {
            Collection rootFolders = getRootFolders();
            if (rootFolders != null)
            {
                Iterator ite = rootFolders.iterator();
                System.out.println("TEST: getSiteObject: site " + ite.hasNext());
                if (ite.hasNext())
                {
                    return getCategoryObject((Folder) ite.next(), uri);
                }
                else
                {
                    return cms.getCmsObject(getScope());
                }
            }
        }
        catch (ContentManagementException e1)
        {
            // TODO Auto-generated catch block
            e1.printStackTrace();
        }

        return null;
    }

    protected CmsObject getCategoryObject(Folder sFolder, String uri)
    {
        System.out.println("TEST: getCategoryObject: uri=" + uri);
        if (uri != null)
        {
            // 0:scope, 1:site, 2:category, 3:menu
            String path[] = StringUtils.split(uri, CmsObject.URI_SEPARATOR);
            if (path.length > 2)
            {
                System.out.println("TEST: getCategoryObject: path[2]=" + path[2]);
                try
                {
                    Folder categoryFolder = cms.getFolder(sFolder.getUri() + CmsObject.URI_SEPARATOR + path[2]);
                    if (categoryFolder != null)
                    {
                        return getMenuObject(categoryFolder, uri);
                    }
                }
                catch (ContentManagementException e)
                {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        }

        Collection cFolders = sFolder.getFolders();
        if (cFolders != null)
        {
            Iterator ite = cFolders.iterator();
            System.out.println("TEST: getCategoryObject: category " + ite.hasNext());
            if (ite.hasNext())
            {
                return getMenuObject((Folder) ite.next(), uri);
            }
        }
        return sFolder;
    }

    protected CmsObject getMenuObject(Folder cFolder, String uri)
    {
        if (uri != null)
        {
            // 0:scope, 1:site, 2:category, 3:menu
            String path[] = StringUtils.split(uri, CmsObject.URI_SEPARATOR);
            if (path.length > 3)
            {
                System.out.println("TEST: getMenuObject: path[3]=" + path[3]);
                try
                {
                    CmsObject menuObject = cms.getCmsObject(cFolder.getUri() + CmsObject.URI_SEPARATOR + path[3]);
                    if (menuObject != null)
                    {
                        return menuObject;
                    }
                }
                catch (ContentManagementException e)
                {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        }

        Collection mDocs = cFolder.getDocuments();
        if (mDocs != null)
        {
            Iterator ite = mDocs.iterator();
            System.out.println("TEST: getMenuObject: menu " + ite.hasNext());
            if (ite.hasNext())
            {
                return (Document) ite.next();
            }
        }
        return cFolder;
    }

    //    protected String getCurrentPath()
    //    {
    //        try
    //        {
    //            Iterator ite = getRootFolders().iterator();
    //            System.out.println("TEST: getDefaultURI: scope " + ite.hasNext() + ",
    // size=" + getRootFolders().size());
    //            if (ite.hasNext())
    //            {
    //                Folder defaultSite = (Folder) ite.next();
    //                ite = defaultSite.getFolders().iterator();
    //                System.out.println("TEST: getDefaultURI: site " + ite.hasNext());
    //                if (ite.hasNext())
    //                {
    //                    Folder defaultCategory = (Folder) ite.next();
    //                    ite = defaultCategory.getDocuments().iterator();
    //                    System.out.println("TEST: getDefaultURI: category " + ite.hasNext());
    //                    if (ite.hasNext())
    //                    {
    //                        Document doc = (Document) ite.next();
    //                        return doc.getUri();
    //                    }
    //                    else
    //                    {
    //                        return defaultCategory.getUri();
    //                    }
    //                }
    //                else
    //                {
    //                    return defaultSite.getUri();
    //                }
    //            }
    //        }
    //        catch (ContentManagementException e)
    //        {
    //            // TODO Auto-generated catch block
    //            e.printStackTrace();
    //        }
    //
    //        return getScope();
    //    }

    protected Collection getRootFolders() throws ContentManagementException
    {
        return cms.getFolders(getScope());
    }

    /**
     * @return Returns the scope.
     */
    public String getScope()
    {
        return scope;
    }

    /**
     * @param scope
     *             The scope to set.
     */
    public void setScope(String scope)
    {
        this.scope = scope;
    }
}
