/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.jetplume.cms.portlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.apache.portals.graffito.exception.ContentManagementException;
import org.apache.portals.graffito.model.CmsObject;
import org.apache.portals.graffito.model.Document;
import org.apache.portals.graffito.model.Folder;
import org.apache.portals.messaging.PortletMessaging;

/**
 * CMS Navigator Portlet
 * 
 * @author <a href="mailto:shinsuke@apache.org">Shinsuke Sugaya </a>
 * @version $Id: NavigatorPortlet.java,v 1.1 2005/04/19 22:17:12 shinsuke Exp $
 */
public class NavigatorPortlet extends GenericCmsServletPortlet
{
    public void init(PortletConfig config) throws PortletException
    {
        super.init(config);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException
    {
        response.setContentType("text/html");

        String currentFile = (String) PortletMessaging.receive(request, "FileDisplayer", CURRENT_FILE);

            StringBuffer javaScriptBuffer = new StringBuffer();
            StringBuffer nonJavaScriptBuffer = new StringBuffer();
            StringBuffer htmlBuffer = new StringBuffer();

            javaScriptBuffer.append("siteName = new Array();\n");
            javaScriptBuffer.append("siteTitle = new Array();\n");
            javaScriptBuffer.append("siteURL = new Array();\n");
            javaScriptBuffer.append("categoryName = new Array();\n");
            javaScriptBuffer.append("categoryTitle = new Array();\n");
            javaScriptBuffer.append("categoryURL = new Array();\n");
            javaScriptBuffer.append("menuName = new Array();\n");
            javaScriptBuffer.append("menuTitle = new Array();\n");
            javaScriptBuffer.append("menuURL = new Array();\n");
            try
            {
                System.out.println("TEST: NavigatorPortlet: currentFile=" + currentFile);
                CmsObject cmsObj = getSiteObject((String) PortletMessaging.receive(request, "FileDisplayer", CURRENT_FILE));
                if (cmsObj == null)
                {
                    htmlBuffer.append("The document does not exist. uri=" + currentFile);
                }
                else
                {
                    String paths[] = cmsObj.getPath();
                    String root = paths[0];
                    javaScriptBuffer.append("selectedRootName=\"" + root + "\";\n");
                    String site = null;
                    if (paths.length > 1)
                    {
                        site = paths[1];
                        javaScriptBuffer.append("selectedSiteName=\"" + site + "\";\n");
                    }
                    String category = null;
                    if (paths.length > 2)
                    {
                        category = paths[2];
                        javaScriptBuffer.append("selectedCategoryName=\"" + category + "\";\n");
                    }
                    String menu = null;
                    if (paths.length > 3)
                    {
                        menu = paths[3];
                        javaScriptBuffer.append("selectedMenuName=\"" + menu + "\";\n");
                    }

                    Iterator siteFolders = cms.getFolders(CmsObject.URI_SEPARATOR + root).iterator();
                    System.out.println("TEST: NavigatorPortlet: siteFolders=" + siteFolders.hasNext() + ", size="
                            + cms.getFolders(CmsObject.URI_SEPARATOR + root).size());
                    for (int i = 0; siteFolders.hasNext(); i++)
                    {
                        PortletURL actionURL = response.createActionURL();
                        Folder siteFolder = (Folder) siteFolders.next();
                        actionURL.setParameter(CURRENT_URI, siteFolder.getUri());
                        javaScriptBuffer.append("siteName[" + i + "]=\"" + siteFolder.getName() + "\";\n");
                        javaScriptBuffer.append("siteTitle[" + i + "]=\"" + siteFolder.getTitle() + "\";\n");
                        javaScriptBuffer.append("siteURL[" + i + "]=\"" + actionURL.toString() + "\";\n");
                    }

                    if (site != null)
                    {
                        Iterator categoryFolders = cms.getFolders(
                                CmsObject.URI_SEPARATOR + root + CmsObject.URI_SEPARATOR + site).iterator();
                        System.out.println("TEST: NavigatorPortlet: categoryFolders="
                                + categoryFolders.hasNext()
                                + ", size="
                                + cms.getFolders(CmsObject.URI_SEPARATOR + root + CmsObject.URI_SEPARATOR + site)
                                        .size());
                        for (int i = 0; categoryFolders.hasNext(); i++)
                        {
                            PortletURL actionURL = response.createActionURL();
                            Folder categoryFolder = (Folder) categoryFolders.next();
                            actionURL.setParameter(CURRENT_URI, categoryFolder.getUri());
                            javaScriptBuffer.append("categoryName[" + i + "]=\"" + categoryFolder.getName() + "\";\n");
                            javaScriptBuffer.append("categoryTitle[" + i + "]=\"" + categoryFolder.getTitle() + "\";\n");
                            javaScriptBuffer.append("categoryURL[" + i + "]=\"" + actionURL.toString() + "\";\n");
                        }
                    }

                    if (category != null)
                    {
                        Iterator menuFolders = cms.getDocuments(
                                CmsObject.URI_SEPARATOR + root + CmsObject.URI_SEPARATOR + site
                                        + CmsObject.URI_SEPARATOR + category).iterator();
                        System.out.println("TEST: NavigatorPortlet: menuFolders="
                                + menuFolders.hasNext()
                                + ", size="
                                + cms.getFolders(
                                        CmsObject.URI_SEPARATOR + root + CmsObject.URI_SEPARATOR + site
                                                + CmsObject.URI_SEPARATOR + category).size());
                        for (int i = 0; menuFolders.hasNext(); i++)
                        {
                            PortletURL actionURL = response.createActionURL();
                            Document menuDoc = (Document) menuFolders.next();
                            actionURL.setParameter(CURRENT_URI, menuDoc.getUri());
                            javaScriptBuffer.append("menuName[" + i + "]=\"" + menuDoc.getName() + "\";\n");
                            javaScriptBuffer.append("menuTitle[" + i + "]=\"" + menuDoc.getTitle() + "\";\n");
                            javaScriptBuffer.append("menuURL[" + i + "]=\"" + actionURL.toString() + "\";\n");
                        }
                    }
                }
            }
            catch (ContentManagementException e)
            {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

            PrintWriter writer = response.getWriter();

            // JavaScript
            writer.println("<script type=\"text/javascript\">");
            writer.println("<!--");
            writer.println(javaScriptBuffer.toString());
            writer.println("//-->");
            writer.println("</script>");

            // Non JavaScript
            writer.println("<noscript>");
            writer.println(nonJavaScriptBuffer.toString());
            writer.println("</noscript>");

            // HTML
            writer.println(htmlBuffer.toString());

            //TODO debug
            //writer.println(javaScriptBuffer.toString());
     

    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException,
            IOException
    {
        String currentURI = actionRequest.getParameter(CURRENT_URI);
        PortletMessaging.publish(actionRequest, "FileDisplayer", CURRENT_FILE, currentURI);

    }

}
