/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.jetplume.cms.portlets;

import java.io.IOException;
import java.io.PrintWriter;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.apache.portals.graffito.model.CmsObject;
import org.apache.portals.graffito.model.Document;
import org.apache.portals.messaging.PortletMessaging;

/**
 * CMS Document Displayer
 * 
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor </a>
 * @version $Id: ViewerPortlet.java,v 1.2 2005/04/21 22:41:48 shinsuke Exp $
 */
public class ViewerPortlet extends GenericCmsServletPortlet
{

    public void init(PortletConfig config) throws PortletException
    {
        super.init(config);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException
    {
        response.setContentType("text/html");

        StringBuffer buf = new StringBuffer();

        CmsObject cmsObj = getSiteObject((String) PortletMessaging.receive(request, "FileDisplayer", CURRENT_FILE));
        if (cmsObj != null)
        {
            //TODO debug
//            buf.append("URI: " + cmsObj.getUri() + "<br/>\n");
            if (cmsObj instanceof Document)
            {
                Document doc = (Document) cmsObj;
                if ((doc.getContentType().indexOf("text") != -1))
                {
                    buf.append( doc.getContent().getContentAsString());
                }
                else if ((doc.getContentType().indexOf("html") != -1))
                {
                    buf.append(doc.getContent().getContentAsString());
                }
                else
                {
                    buf.append("The content does not exist. uri=" + cmsObj.getUri());
                }
            }
        }
        else
        {
            buf.append("The content does not exist. ");
        }
        PrintWriter writer = response.getWriter();

        writer.println(buf.toString());

    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException,
            IOException
    {
        String currentURI = actionRequest.getParameter(CURRENT_URI);
        PortletMessaging.publish(actionRequest, "FileDisplayer", CURRENT_FILE, currentURI);

    }

}
