/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.graffito.portlets.util;

import java.io.IOException;
import java.io.InputStream;

import org.apache.jetspeed.services.JetspeedPortletServices;
import org.apache.jetspeed.services.PortletServices;
import org.apache.portals.graffito.ContentModelService;
import org.apache.portals.graffito.ContentSearchService;
import org.apache.portals.graffito.ContentServerService;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.InputStreamResource;

/**
 * Spring static accessor singleton.
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: ServiceAccessor.java,v 1.1 2005/04/13 23:17:40 shinsuke Exp $
 */
public class ServiceAccessor
{
    private static BeanFactory springFactory = null;
    
    private static boolean useJetspeedServices = true;

    public static ContentModelService getModelService()
    {        
        return (ContentModelService) getService("ContentModel");
    }

    public static ContentServerService getServerService()
    {
        return (ContentServerService)getService("ContentServer");
    }

    public static ContentSearchService getSearchService()
    {
        return (ContentSearchService)getService("ContentSearch");        
    }
    
    public static BeanFactory getFactory()
    {
        return springFactory;
    }

    static public void initializeSpring(InputStream is)
    throws IOException
    {
        springFactory = new XmlBeanFactory(new InputStreamResource(is));
        is.close();        
    }
        
    public static Object getService(String serviceName)
    {
        if (useJetspeedServices)
        {
            // FIXME: better to use jetspeed-portlet.xml to define the requested service            
            PortletServices services = JetspeedPortletServices.getSingleton();
            return (ContentModelService) services.getService(serviceName);            
        }
        else
        {
            return springFactory.getBean(serviceName);
        }
    }
}