/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.graffito.servlets;

import java.io.InputStream;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

import org.apache.portals.graffito.portlets.util.ServiceAccessor;

/**
 * Initialize Spring at servlet startup
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: SpringInitializerServlet.java,v 1.1 2005/04/13 23:17:41 shinsuke Exp $
 */
public class SpringInitializerServlet
    extends HttpServlet
{        
    public static final long serialVersionUID = 1;

    
    public synchronized final void init(ServletConfig config) 
    throws ServletException
    {
        synchronized (this.getClass())
        {            
            super.init(config);
            ServletContext context = getServletContext();

            try
            {
                String assembly = getInitParameter("assembly");                
                InputStream is = context.getResourceAsStream(assembly);                                
                ServiceAccessor.initializeSpring(is);                                
            }
            catch (Exception e)
            {
                e.printStackTrace();
                throw new ServletException("Failed to load Spring assembly", e);
            }
        }
    }

    public final void destroy()
    {
    }
    
}