class LoadingScene extends Scene {
	resource:Resource;
	shape:Shape;
	shapeP:Shape;
	requestCount:number;

	constructor(game:Game, resource:Resource) {
		super(game);
		this.resource = resource;
		this.resource.loaded.handle(this, this.complete);
		this.requestCount = this.resource.requests.length;

		this.shape = new Shape(game.width, 32);
		this.shape.moveTo(0, game.height / 2 - 16);

		this.shapeP = new Shape(1, 32, ShapeStyle.fill);
		this.shapeP.moveTo(0, game.height / 2 - 16);

		this.append(this.shape);
		this.append(this.shapeP);
	}

	complete(cnt:number) {
		this.shapeP.width = this.game.width * ((this.requestCount-cnt) / this.requestCount);
		this.shapeP.updated();

		if (cnt == 0) {
			this.resource.loaded.remove(this, this.complete);
			this.end();
		}
	}
}