enum ShapeStyle {
	stroke,
	fill
}
enum ShapeType {
	rect,
	arc
}
class Shape extends E {
	style:ShapeStyle;
	type:ShapeType;
	constructor(width:number, height:number, style?:ShapeStyle, color?:string, type?:ShapeType) {
		super();
		this.x = 0;
		this.y = 0;
		this.width = width;
		this.height = height;
		this.style = style ? style : ShapeStyle.stroke;
		if (color)
			this.setColor(color);
		this.type = type ? type : ShapeType.rect;
	}

	setStyle(style:ShapeStyle) {
		this.style = style;
		this.setColor(this.getColor());
	}

	setLineWidth(width:number) {
		this.setDrawOption("lineWidth", width);
	}
	getLineWidth() {
		return this.getDrawOption("lineWidth");
	}

	setColor(color:string) {
		if (this.style == ShapeStyle.stroke) {
			this.setDrawOption("strokeStyle", color);
		} else {
			this.setDrawOption("fillStyle", color);
		}
	}
	getColor() {
		if (this.style == ShapeStyle.stroke) {
			return this.getDrawOption("strokeStyle");
		} else {
			return this.getDrawOption("filltyle");
		}
	}

	draw(area:Area, context:CanvasRenderingContext2D) {
		//arc, rect
		//style: fill, stroke
		context.beginPath();
		switch(this.type) {
			case ShapeType.rect:
				context.rect(
					0,
					0,
					this.width,
					this.height
				);
				break;
			case ShapeType.arc:
				context.arc(
					0,//this.x,
					0,//this.y,
					this.width,
					0,
					Math.PI*2,
					false
				);
				break;
		}
		if (this.style == ShapeStyle.fill) {
			context.fill();
		} else {
			context.stroke();
		}
	}
}