/*
Copyright (c) Ubiquitous Entertainment Inc. Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
interface ActionEventArgs {
	timeline: Timeline;
}
interface ActionTickEventArgs {
	timeline: Timeline;
	elapsed: number;
}
class Action {
	time:number;
	frame:number;
	added_to_timeline:Trigger;
	removed_from_timeline:Trigger;
	action_tick:Trigger;
	action_start:Trigger;
	action_end:Trigger;
	timeline:Timeline;
	entity:E;

	constructor(param?:any) {
		this.added_to_timeline = new Trigger();
		this.removed_from_timeline = new Trigger();
		this.action_tick = new Trigger();

		this.time = null;
		this.frame = 0;
		if (param) {
			for (var key in param) {
				if (param.hasOwnProperty(key)) {
					if (param[key] != null) {
						this[key] = param[key];
					}
				}
			}
		}
		var action = this;

		this.timeline = null;
		this.entity = null;

		this.removed_from_timeline.handle(this, this.removedFromTimeline);
		this.added_to_timeline.handle(this, this.addedToTimeline);
		this.action_tick.handle(this, this.actionTick);
	}

	removedFromTimeline() {
		this.timeline = null;
		this.entity = null;
		this.frame = 0;
	}

	addedToTimeline(p:ActionEventArgs) {
		this.timeline = p.timeline;
		this.entity = p.timeline.entity;
		this.frame = 0;
	}

	actionTick(p:ActionTickEventArgs) {
		var remaining = this.time - (this.frame + p.elapsed);
		if (this.time != null && remaining <= 0) {
			this.frame = this.time;
			p.timeline.next(-remaining);
		} else {
			this.frame += p.elapsed;
		}
	}
}
