class LoadingScene extends Scene {
	resource:Resource;
	shape:Shape;
	shapeP:Shape;
	requestCount:number;
	jgameRequestCount:number;
	finished:Trigger;
	otherResources:{[key:string]: number; };
	otherResourceCount:number;
	otherResourceCompleted:number;
	lastCnt:number;

	constructor(game:Game, resource:Resource, noShape?:bool) {
		super(game);
		this.resource = resource;
		this.resource.loaded.handle(this, this.complete);
		this.requestCount = this.resource.requests.length;
		this.jgameRequestCount = this.requestCount;
		this.finished = new Trigger();
		this.otherResources = {};
		this.otherResourceCount = 0;
		this.otherResourceCompleted = 0;
		this.lastCnt = 0;

		if (!noShape) {
			this.shape = new Shape(game.width, 32);
			this.shape.moveTo(0, game.height / 2 - 16);

			this.shapeP = new Shape(1, 32, ShapeStyle.fill);
			this.shapeP.moveTo(0, game.height / 2 - 16);

			this.append(this.shape);
			this.append(this.shapeP);
		}
	}

	addOtherResource(identify:string) {
		this.requestCount++;
		this.otherResourceCount++;
	}

	otherResourceComplete(identify:string) {
		this.otherResources[identify]--;
		this.otherResourceCompleted++;
		this.complete(this.lastCnt);
	}

	complete(cnt:number) {
		this.lastCnt = cnt;
		var per = (this.jgameRequestCount-cnt+this.otherResourceCompleted) / this.requestCount;
		this.shapeP.width = this.game.width * per;
		this.shapeP.updated();

		if (per == 1) {
			this.resource.loaded.remove(this, this.complete);
			this.end();
			this.finished.fire();
		}
	}
}