module jg {
	export class Label extends E {
		text:string;
		maxWidth:number;
		syncObj: any;
		syncProp: string;
		syncRound: bool;

		constructor(text?:string, fontSize?:number, fontColor?:string, baseline?:string) {
			super();
			this.x = 0;
			this.y = 0;
			if (text) {
				this.setText(text);
			} else {
				this.setText("");
				this.width = 0;
				this.height = 0;
			}
			this.setTextBaseline(baseline ? baseline : "top");
			this.setFontSize(fontSize ? fontSize : 14);
			this.setColor(fontColor ? fontColor : "black");
		}

		setMaxWidth(maxWidth:number) {
			this.maxWidth = maxWidth;
			this.updateSize();
		}

		updateSize() {
			var canvas = window.createCanvas(10, 10);
			var ctx = canvas.getContext("2d");
			ctx.font = this.getFont();
			//ctx.textAlign = this.getTextAlign();
			var metrix:TextMetrics = ctx.measureText(this.text);
			this.width = metrix.width;
			this.height = this.getFontSize();
		}

		addShadow(color?:string) {
			this.setDrawOption("shadowBlur", 2);
			this.setDrawOption("shadowColor", color ? color : "black");
		}

		removeShadow() {
			this.removeDrawOption("shadowBlur");
			this.removeDrawOption("shadowColor");
		}

		setText(text:string) {
			this.text = text;
			this.updateSize();
			this.updated();
		}

		setFont(fontString:string) {
			this.setDrawOption("font", fontString);
			this.updateSize();
		}

		getFont():string {
			return this.getDrawOption("font");
		}

		//TODO: boldやitalicが指定されている場合バグる
		setFontSize(size:number) {
			var font = this.getFont();
			var firstPos = font.indexOf(" ");
			this.setFont(size+"px "+font.substr(firstPos+1));
		}

		//TODO: boldやitalicが指定されている場合バグる
		getFontSize():number {
			var font = this.getFont();
			var firstPos = font.indexOf(" ");
			try {
				return parseInt(font.substr(0, firstPos-2));
			} catch(ex) {
			}
			return this.height;
		}

		//start, end, left, right, center
		setTextAlign(align:string) {
			this.setDrawOption("textAlign", align);
		}

		getTextAlign():string {
			return this.getDrawOption("textAlign");
		}

		//top, hanging, middle, alphabetic, ideographic, bottom
		setTextBaseline(baseline:string) {
			this.setDrawOption("textBaseline", baseline);
		}

		getTextBaseline():string {
			return this.getDrawOption("textBaseline");
		}

		setColor(color:string) {
			this.setDrawOption("fillStyle", color);
		}

		getColor():string {
			return this.getDrawOption("fillStyle");
		}

		synchronize(obj:any, prop:string, round?:bool) {
			this.syncObj = obj;
			this.syncProp = prop;
			this.syncRound = round;
		}

		draw(context:CanvasRenderingContext2D) {
			if (this.syncObj) {
				var val;
				if (typeof this.syncObj[this.syncProp] == "function")
					val = this.syncObj[this.syncProp](this);
				else
					val = this.syncObj[this.syncProp];

				this.text = this.syncRound ? Math.round(val) : val;
			}
			if (this.maxWidth) {
				context.fillText(
					this.text,
					0,
					0,
					this.maxWidth
				);
			} else {
				context.fillText(
					this.text,
					0,
					0
				);
			}
		}
	}
}