module jg {
	export class Sprite extends E {
		image: any; // HTMLImageElement, HTMLVideoElement, HTMLCanvasElement
		srcWidth: number;
		srcHeight: number;
		srcX: number;
		srcY: number;

		constructor(image:any, srcWidth?:number, srcHeight?:number) {
			super();
			this.x = 0;
			this.y = 0;
			this.width = srcWidth ? srcWidth : image.width;
			this.height = srcHeight ? srcHeight : image.height;
			this.srcWidth = this.width;
			this.srcHeight = this.height;
			this.srcX = 0;
			this.srcY = 0;
			this.image = image;
		}

		draw(context:CanvasRenderingContext2D) {
			context.drawImage(
				this.image,
				this.srcX,
				this.srcY,
				this.srcWidth,
				this.srcHeight,
				0,
				0,
				this.width,
				this.height
			);
		}
/*
		refresh() {
			if (this.image instanceof HTMLCanvasElement) {
				//多分壊れてるが、復旧方法不明
			}
		}
*/
	}
}