///<reference path="all.ts"/>
module jg {
	/**
	 * 四角形クラス
	 */
	export class Rectangle implements IRectangle {
		/** 左座標 */
		left: number;
		/** 上座標 */
		top: number;
		/** 右座標 */
		right: number;
		/** 下座標 */
		bottom: number;

		/**
		 * コンストラクタ
		 * @param left 左座標
		 * @param top 上座標
		 * @param right 右座標
		 * @param bottom 下座標
		 */
		constructor(left?:number, top?:number, right?:number, bottom?:number) {
			this.left = left;
			this.top = top;
			this.right = right;
			this.bottom = bottom;
		}

		/**
		 * 多少の座標がこの四角形に当たっているかを判定する
		 * @param point 判定対象の座標
		 */
		hitTest(point:CommonOffset) {
			return (this.left <= point.x && this.right >= point.x && this.top <= point.y && this.bottom >= point.y);
		}

		/**
		 * 対象の座標をこの四角形に吸着させる
		 * @param point 対象の座標
		 */
		fit(point:CommonOffset) {
			if (point.y<this.top)
				point.y = this.top;
			else if (point.y > this.bottom)
				point.y = this.bottom;

			if (point.x<this.left)
				point.x = this.left;
			else if (point.x > this.right)
				point.x = this.right;
		}

		/**
		 * この四角形の横幅を得る
		 */
		width():number {
			return Math.abs(this.right - this.left);
		}

		/**
		 * この四角形の縦幅を得る
		 */
		height():number {
			return Math.abs(this.bottom - this.top);
		}
	}
}