/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jirc;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import jp.sourceforge.jirc.IRC;

class IRCIO
extends Thread {
    private IRC irc = null;
    private BufferedReader is = null;
    private DataOutputStream os = null;
    private boolean connected = false;
    private boolean runnable = false;

    IRCIO(String server) throws Exception {
        this.open(server, 6667);
    }

    IRCIO(String server, int port) throws Exception {
        this.open(server, port);
    }

    void open(String server, int port) throws Exception {
        Socket s = null;
        try {
            s = new Socket(server, port);
            this.is = new BufferedReader(new InputStreamReader(s.getInputStream()));
            this.os = new DataOutputStream(s.getOutputStream());
            this.connected = true;
        }
        catch (Exception e) {
            s = null;
            this.is = null;
            this.os = null;
            this.connected = false;
            throw e;
        }
    }

    final synchronized void close() {
        this.runnable = false;
        this.connected = false;
        try {
            try {
                this.is.close();
                this.join();
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var3_2 = null;
                this.is = null;
                this.os = null;
            }
            Object var3_1 = null;
            this.is = null;
            this.os = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.is = null;
            this.os = null;
            throw throwable;
        }
    }

    public void run() {
        String string = null;
        while (this.runnable) {
            try {
                string = this.is.readLine();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close();
            }
            if (string == null) {
                this.close();
                continue;
            }
            try {
                this.irc.readMessage(string);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                this.irc.getClient().Disconnection();
                this.close();
            }
        }
    }

    final void addReadMessageListener(IRC irc) {
        if (irc != null) {
            this.irc = irc;
            this.runnable = true;
        }
    }

    final synchronized void writeMessage(String message) throws IOException {
        this.os.writeBytes(message);
    }
}

