/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jirc;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import jp.sourceforge.jirc.Window;

class IRCMenuBar
extends JMenuBar {
    private Window window;
    private JMenuItem connectionItem = new JMenuItem("Connection");
    private JMenuItem disconnectionItem = new JMenuItem("Disconnection");
    private JMenu commandMenu = null;
    private JMenu channelMenu = null;
    private boolean hasMenu = false;

    IRCMenuBar(Window window) {
        this.window = window;
        if (!this.hasMenu) {
            this.commandMenu = this.getCommandMenu();
            this.channelMenu = this.getChannelMenu();
            this.add(this.getFileMenu());
            this.add(this.getEncodingMenu());
            this.add(this.commandMenu);
            this.add(this.channelMenu);
            this.hasMenu = true;
        }
    }

    private JMenu getFileMenu() {
        JMenu menu = new JMenu("File");
        JMenuItem quitItem = new JMenuItem("Quit");
        menu.add(this.connectionItem);
        menu.add(this.disconnectionItem);
        menu.add(new JSeparator());
        this.setMenuItem(menu, "Quit").addActionListener(new QuitActionImpl());
        this.connectionItem.addActionListener(new ConnectionActionImpl());
        this.disconnectionItem.addActionListener(new DisconnectionActionImpl());
        this.disconnectionItem.setEnabled(false);
        return menu;
    }

    private JMenu getEncodingMenu() {
        JMenu menu = new JMenu("Encoding");
        ButtonGroup group = new ButtonGroup();
        this.setEncGroupMenuItem(menu, group, "UTF8", false);
        this.setEncGroupMenuItem(menu, group, "JIS", true);
        this.setEncGroupMenuItem(menu, group, "SJIS", false);
        this.setEncGroupMenuItem(menu, group, "EUC_JP", false);
        return menu;
    }

    private JRadioButtonMenuItem setEncGroupMenuItem(JMenu menu, ButtonGroup group, String text, boolean selected) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(text, selected);
        menu.add(item);
        group.add(item);
        item.addActionListener(new SelectedActionImpl(text));
        return item;
    }

    private JMenu getCommandMenu() {
        JMenu menu = new JMenu("Command");
        this.setMenuItem(menu, "NICK...").addActionListener(new NickActionImpl());
        this.setMenuItem(menu, "JOIN...").addActionListener(new JoinActionImpl());
        menu.setEnabled(false);
        return menu;
    }

    private JMenu getChannelMenu() {
        JMenu menu = new JMenu("Channel");
        this.setMenuItem(menu, "PART").addActionListener(new PartActionImpl());
        this.setMenuItem(menu, "TOPIC...").addActionListener(new TopicActionImpl());
        menu.setEnabled(false);
        return menu;
    }

    private JMenuItem setMenuItem(JMenu menu, String text) {
        JMenuItem item = new JMenuItem(text);
        menu.add(item);
        return item;
    }

    public void setConnected(boolean connected) {
        this.connectionItem.setEnabled(!connected);
        this.disconnectionItem.setEnabled(connected);
        this.commandMenu.setEnabled(connected);
        this.channelMenu.setEnabled(connected);
    }

    private class NickActionImpl
    implements ActionListener {
        private NickActionImpl() {
        }

        public void actionPerformed(ActionEvent ae) {
            String nick = JOptionPane.showInputDialog("please input new nick");
            IRCMenuBar.this.window.setNICK(nick);
        }
    }

    private class TopicActionImpl
    implements ActionListener {
        private TopicActionImpl() {
        }

        public void actionPerformed(ActionEvent ae) {
            String topic = JOptionPane.showInputDialog("please input channel topic");
            IRCMenuBar.this.window.setTOPIC(IRCMenuBar.this.window.getNowChannel(), topic);
        }
    }

    private class PartActionImpl
    implements ActionListener {
        private PartActionImpl() {
        }

        public void actionPerformed(ActionEvent ae) {
            IRCMenuBar.this.window.setPART(IRCMenuBar.this.window.getNowChannel());
        }
    }

    private class JoinActionImpl
    implements ActionListener {
        private JoinActionImpl() {
        }

        public void actionPerformed(ActionEvent ae) {
            String channel = JOptionPane.showInputDialog("please input channel name");
            IRCMenuBar.this.window.setJOIN(channel);
        }
    }

    private class QuitActionImpl
    implements ActionListener {
        private QuitActionImpl() {
        }

        public void actionPerformed(ActionEvent ae) {
            IRCMenuBar.this.window.exit();
        }
    }

    private class SelectedActionImpl
    implements ActionListener {
        private final String encoding;

        SelectedActionImpl(String encoding) {
            this.encoding = encoding;
        }

        public void actionPerformed(ActionEvent ae) {
            IRCMenuBar.this.window.setENC(this.encoding);
        }
    }

    private class DisconnectionActionImpl
    implements ActionListener {
        private DisconnectionActionImpl() {
        }

        public void actionPerformed(ActionEvent ae) {
            IRCMenuBar.this.setConnected(false);
            IRCMenuBar.this.window.Disconnection();
        }
    }

    private class ConnectionActionImpl
    implements ActionListener {
        private ConnectionActionImpl() {
        }

        public void actionPerformed(ActionEvent ae) {
            IRCMenuBar.this.window.Connection();
        }
    }
}

