/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jirc;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import jp.sourceforge.jirc.AbstractClient;
import jp.sourceforge.jirc.Channel;
import jp.sourceforge.jirc.ChildWindow;
import jp.sourceforge.jirc.ConnectionDialog;
import jp.sourceforge.jirc.IRC;
import jp.sourceforge.jirc.IRCMenuBar;
import jp.sourceforge.jirc.IRCMessageFormat;
import jp.sourceforge.jirc.WindowTreeModel;

class Window
extends AbstractClient {
    private String applName = "jIRC";
    private Channel nowChannel = null;
    private final String CRLF = "\r\n";
    private JFrame frame = new JFrame();
    private JTextArea listenTA = new JTextArea();
    private JTree tree;
    private CardLayout cardLayout = new CardLayout();
    private JPanel cardPanel = new JPanel(this.cardLayout);
    private ConnectionDialog connectionDialog = null;
    private WindowTreeModel windowTreeModel = new WindowTreeModel(this);

    public Window() {
        this.frame.addWindowListener(new WindowListenerImpl());
        ((Component)this.frame).setSize(500, 350);
        this.init(this.frame.getContentPane());
    }

    public Window(JApplet applet) {
        applet.setSize(640, 480);
        this.init(applet.getContentPane());
    }

    public void Connection() {
        if (this.connectionDialog == null) {
            new ConnectionDialog(this);
        } else {
            this.connectionDialog.show();
        }
    }

    public void Connection(String server, int port, String nick, String user, String passwd) {
        try {
            super.Connection(server, port, nick, user, passwd);
            this.frame.pack();
        }
        catch (Exception e) {
            super.close();
            JOptionPane.showMessageDialog(null, e.getLocalizedMessage());
        }
    }

    public void setConnection(IRC irc, boolean flag) {
        if (this.irc.equals(irc)) {
            IRCMenuBar bar = (IRCMenuBar)this.frame.getJMenuBar();
            bar.setConnected(flag);
        }
    }

    private void init(Container container) {
        this.tree = new JTree(this.windowTreeModel);
        this.tree.addTreeSelectionListener(new TreeSelectionListenerImpl());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.listenTA.setLineWrap(true);
        this.listenTA.setWrapStyleWord(true);
        this.listenTA.setEditable(false);
        JScrollPane listenPane = new JScrollPane(this.listenTA, 22, 31);
        JScrollPane treePane = new JScrollPane(this.tree, 22, 31);
        JSplitPane splitPane = new JSplitPane(0, this.cardPanel, listenPane);
        container.add((Component)splitPane, "Center");
        container.add((Component)treePane, "West");
        container.setVisible(true);
        splitPane.setDividerLocation(0.6);
    }

    public void writeMessage(String channel, String message) {
        try {
            super.writeMessage(channel, message);
        }
        catch (Exception e) {
            super.close();
            JOptionPane.showMessageDialog(null, e.getLocalizedMessage());
        }
    }

    void setChannel(ChildWindow cw) {
        this.cardPanel.add((Component)cw, cw.getName());
        cw.requestTextFieldFocus();
        this.cardLayout.show(this.cardPanel, cw.getName());
        this.windowTreeModel.reload();
        this.setNowChannel(cw);
    }

    public void removeChannel(Channel channel) {
        this.windowTreeModel.removeChannel(channel);
    }

    void removeWindow(Channel channel) {
        ChildWindow cw = this.windowTreeModel.getServerChildWindow(channel);
        if (cw == null) {
            cw = (ChildWindow)channel;
        }
        this.cardLayout.removeLayoutComponent(cw);
    }

    public void setNowChannel(String serverName, String channelName) {
        ChildWindow server = this.windowTreeModel.getServerChildWindow(serverName);
        Channel channel = server.getIRC().getChannel(channelName);
        if (channel != null) {
            this.setNowChannel(channel);
        }
    }

    public void setNowChannel(Channel channel) {
        this.cardLayout.show(this.cardPanel, channel.getName());
        this.nowChannel = channel;
        this.setTopic();
    }

    public Channel getNowChannel() {
        return this.nowChannel;
    }

    public Channel getNowServer() {
        return this.windowTreeModel.getNowServer();
    }

    public void setTopic() {
        String title = "";
        if (this.nowChannel != null) {
            title = title + this.nowChannel.getName() + ' ' + this.nowChannel.getMode().toString() + ' ' + this.nowChannel.getTopic() + " - ";
        }
        this.setTopic(title);
    }

    public void addUser(Channel channel, String nick) {
        this.windowTreeModel.addUser(channel, nick);
    }

    public Channel makeChannel(String name) {
        ChildWindow cw = new ChildWindow(name, this.irc, this);
        this.windowTreeModel.addChannel(cw);
        this.tree.expandRow(0);
        return cw;
    }

    public Channel makeServerChannel(String name) {
        ChildWindow cw = new ChildWindow(name, this.irc, this);
        this.windowTreeModel.removeParentWindow();
        this.windowTreeModel.addParentWindow(cw);
        return cw;
    }

    public boolean removeUser(Channel channel, String nick) {
        return this.windowTreeModel.removeUser(channel, nick);
    }

    public void removeUser(IRC irc, String nick, String message) {
        Enumeration channels = irc.getChannels();
        while (channels.hasMoreElements()) {
            Channel channel = (Channel)channels.nextElement();
            if (!this.removeUser(channel, nick)) continue;
            String[] args = new String[]{nick, message};
            channel.append(IRCMessageFormat.getQuitMessage(args));
        }
    }

    public void setChanop(Channel channel, String nick, boolean flag) {
        this.windowTreeModel.setUserMode(channel, nick, "@", flag);
    }

    public void setVoice(Channel channel, String nick, boolean flag) {
        MutableTreeNode childNode = this.windowTreeModel.getUserNode(this.windowTreeModel.getChannelTreeNode(channel), nick);
        char head = childNode.toString().charAt(0);
        if (head != '@') {
            this.windowTreeModel.setUserMode(channel, nick, "+", flag);
        }
    }

    public void changeUser(IRC irc, String oldNick, String newNick) {
        Enumeration channels = irc.getChannels();
        while (channels.hasMoreElements()) {
            MutableTreeNode childNode;
            Channel channel = (Channel)channels.nextElement();
            MutableTreeNode treeNode = this.windowTreeModel.getChannelTreeNode(channel);
            if (treeNode == null || (childNode = this.windowTreeModel.getUserNode(treeNode, oldNick)) == null) continue;
            char head = childNode.toString().charAt(0);
            String fullNewNick = newNick;
            if (head == '@' || head == '+') {
                fullNewNick = head + newNick;
            }
            this.windowTreeModel.changeUserNode(treeNode, childNode, fullNewNick);
            String[] args = new String[]{oldNick, newNick};
            channel.append(IRCMessageFormat.getNickMessage(args));
        }
    }

    public void append(Channel channel, String string) {
        if (channel == null || !channel.getName().equals(this.nowChannel.getName())) {
            this.listenTA.append(string + "\r\n");
        }
    }

    public void show() {
        this.frame.show();
    }

    public Toolkit getToolkit() {
        return this.frame.getToolkit();
    }

    public Dimension getSize() {
        return this.frame.getSize();
    }

    public void setLocation(int x, int y) {
        ((Component)this.frame).setLocation(x, y);
    }

    public void setJMenuBar(JMenuBar bar) {
        this.frame.setJMenuBar(bar);
    }

    public void setDefaultCloseOperation(int i) {
        this.frame.setDefaultCloseOperation(i);
    }

    private void setTopic(String string) {
        this.frame.setTitle(string + this.applName);
    }

    public void exit() {
        int i;
        if (this.isConnected()) {
            this.Disconnection();
        }
        if ((i = this.frame.getDefaultCloseOperation()) == 1) {
            this.frame.hide();
        } else if (i == 2) {
            this.frame.dispose();
        } else if (i == 3) {
            System.exit(0);
        }
        this.irc = null;
    }

    private class TreeSelectionListenerImpl
    implements TreeSelectionListener {
        private TreeSelectionListenerImpl() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getNewLeadSelectionPath();
            if (path == null) {
                path = e.getOldLeadSelectionPath();
            }
            Object channel = "";
            Object server = "";
            if (path.getPathCount() > 1) {
                channel = path.getPath()[path.getPathCount() - 1];
                server = path.getPath()[1];
            } else {
                server = channel = path.getPath()[1];
            }
            Window.this.setNowChannel(server.toString(), channel.toString());
        }
    }

    private class WindowListenerImpl
    extends WindowAdapter {
        private WindowListenerImpl() {
        }

        public void windowClosed(WindowEvent we) {
            Window.this.exit();
        }
    }
}

