/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jirc;

import jp.sourceforge.jirc.Channel;
import jp.sourceforge.jirc.Client;
import jp.sourceforge.jirc.IRC;
import jp.sourceforge.jirc.IRCMessageFormat;

abstract class AbstractClient
implements Client {
    private String ENC = "JIS";

    AbstractClient() {
    }

    public IRC Connection(String server, int port, String nick, String user, String passwd) throws Exception {
        IRC irc = null;
        try {
            try {
                irc = new IRC(server, port, nick, user, passwd);
                irc.addReadMessageListener(this);
                irc.start();
            }
            catch (Exception e) {
                irc = null;
                throw e;
            }
            Object var9_7 = null;
            return irc;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            return irc;
        }
    }

    abstract IRC getIRC();

    public boolean isConnected() {
        IRC irc = this.getIRC();
        if (irc == null) {
            return false;
        }
        return irc.isConnected();
    }

    public void Disconnection() {
        IRC irc = this.getIRC();
        try {
            irc.QUIT();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        IRC irc = this.getIRC();
        if (irc != null) {
            irc.close();
        }
    }

    public final void setENC(String encoding) {
        this.ENC = encoding;
    }

    public final String getENC() {
        return this.ENC;
    }

    public void writeMessage(String channel, String message) throws Exception {
        IRC irc = this.getIRC();
        if (message.startsWith("/")) {
            message = message.substring(message.indexOf("/") + 1);
            irc.directMessage(this.toENC(message));
        } else if (channel != null) {
            irc.PRIVMSG(this.toENC(channel), this.toENC(message));
            String[] args = new String[]{irc.getNick(), channel, message};
            irc.getChannel(channel).append(IRCMessageFormat.getPrivmsgMessage(args));
        }
    }

    public String toENC(String string) {
        try {
            return new String(string.getBytes(this.ENC));
        }
        catch (Exception e) {
            e.printStackTrace();
            return string;
        }
    }

    public String encToUNICODE(String string) {
        try {
            return new String(string.getBytes(), this.ENC);
        }
        catch (Exception e) {
            e.printStackTrace();
            return string;
        }
    }

    public final void setJOIN(String channel) {
        IRC irc = this.getIRC();
        if (channel != null) {
            try {
                irc.JOIN(this.toENC(channel));
            }
            catch (Exception e) {
                this.Disconnection();
            }
        }
    }

    public final void setPART(Channel channel) {
        try {
            channel.getIRC().PART(this.toENC(channel.toString()));
        }
        catch (Exception e) {
            this.Disconnection();
        }
    }

    public void setTOPIC(Channel channel, String topic) {
        if (topic != null) {
            try {
                channel.getIRC().TOPIC(channel.toString(), this.toENC(topic));
            }
            catch (Exception e) {
                this.Disconnection();
            }
        }
    }

    public void setNICK(String nick) {
        IRC irc = this.getIRC();
        if (nick != null) {
            try {
                irc.NICK(nick);
            }
            catch (Exception e) {
                this.Disconnection();
            }
        }
    }

    public abstract void exit();

    public abstract void changeUser(IRC var1, String var2, String var3);

    public abstract void removeUser(IRC var1, String var2, String var3);

    public abstract void removeChannel(Channel var1);

    public abstract Channel makeChannel(IRC var1, String var2);

    public abstract Channel makeServerChannel(IRC var1, String var2);

    public abstract void append(Channel var1, String var2);

    public abstract void setConnection(IRC var1, boolean var2);
}

