/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jirc;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import jp.sourceforge.jirc.ChildWindow;
import jp.sourceforge.jirc.ConnectionDialog;
import jp.sourceforge.jirc.IRCMenuBar;
import jp.sourceforge.jirc.WindowTreeModel;
import jp.sourceforge.jirc.net.AbstractClient;
import jp.sourceforge.jirc.net.Channel;
import jp.sourceforge.jirc.net.IRC;
import jp.sourceforge.jirc.text.IRCMessageFormat;

public class Window
extends AbstractClient {
    private String applName = "jIRC";
    private Channel nowChannel = null;
    private final String CRLF = "\r\n";
    private JFrame frame = new JFrame();
    private JTextArea listenTA = new JTextArea();
    private JTextField tf = new JTextField();
    private JSplitPane splitPane;
    private JScrollBar scrollBar;
    private JTree tree;
    private CardLayout cardLayout = new CardLayout();
    private JPanel cardPanel = new JPanel(this.cardLayout);
    private ConnectionDialog connectionDialog = null;
    private WindowTreeModel windowTreeModel = new WindowTreeModel(this);

    public Window() {
        this.frame.addWindowListener(new WindowListenerImpl());
        this.frame.setSize(500, 350);
        this.init(this.frame.getContentPane());
    }

    public Window(JApplet applet) {
        applet.setSize(640, 480);
        this.init(applet.getContentPane());
    }

    public void Connection() {
        if (this.connectionDialog == null) {
            new ConnectionDialog(this);
        } else {
            this.connectionDialog.show();
        }
    }

    public IRC Connection(String server, int port, String nick, String user, String passwd, String channels) {
        IRC irc = this.Connection(server, port, nick, user, passwd);
        if (irc != null) {
            super.setJOIN(channels);
        }
        return irc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRC Connection(String server, int port, String nick, String user, String passwd) {
        IRC irc = null;
        try {
            try {
                irc = super.Connection(server, port, nick, user, passwd);
                this.listenTA.setText("");
                this.frame.pack();
            }
            catch (Exception e) {
                this.setException(e);
                super.close();
                Object var9_8 = null;
                return irc;
            }
            Object var9_7 = null;
            return irc;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            return irc;
        }
    }

    public void setConnection(IRC irc, boolean flag) {
        if (this.getIRC().equals(irc)) {
            IRCMenuBar bar = (IRCMenuBar)this.frame.getJMenuBar();
            bar.setConnected(flag);
        }
    }

    private void init(Container container) {
        this.tree = new JTree(this.windowTreeModel);
        this.tree.addTreeSelectionListener(new TreeSelectionListenerImpl());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.listenTA.setLineWrap(true);
        this.listenTA.setWrapStyleWord(true);
        this.listenTA.setEditable(false);
        JScrollPane listenPane = new JScrollPane(this.listenTA, 22, 31);
        JScrollPane treePane = new JScrollPane(this.tree, 22, 31);
        this.scrollBar = listenPane.getVerticalScrollBar();
        ChangeListener l = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Window.this.scrollBar.setValue(Window.this.scrollBar.getMaximum());
            }
        };
        this.scrollBar.getModel().addChangeListener(l);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.tf, "North");
        panel.add((Component)listenPane, "Center");
        this.splitPane = new JSplitPane(0, this.cardPanel, panel);
        container.add((Component)this.splitPane, "Center");
        container.add((Component)treePane, "West");
        container.setVisible(true);
        this.listenTA.addKeyListener(this.getKeyAdapter(this.listenTA));
        this.tf.requestFocus();
        this.tf.addActionListener(new ChildWindowInputListener());
    }

    KeyAdapter getKeyAdapter(JTextArea ta) {
        final JTextArea jta = ta;
        KeyAdapter adapter = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (jta.getSelectedText() == null) {
                    Window.this.tf.requestFocus();
                }
            }

            public void keyTyped(KeyEvent e) {
                Window.this.tf.requestFocus();
            }
        };
        return adapter;
    }

    public void writeMessage(String channel, String message) {
        try {
            super.writeMessage(channel, message);
        }
        catch (Exception e) {
            this.setException(e);
            super.close();
        }
    }

    void setChannel(ChildWindow cw) {
        this.cardPanel.add(cw.toString() + cw.getIRC().getDate(), cw);
        this.cardLayout.show(this.cardPanel, cw.toString() + cw.getIRC().getDate());
        this.windowTreeModel.reload();
        this.setNowChannel(cw);
    }

    void setChannel(String name) {
        this.setChannel((ChildWindow)this.getIRC().getChannel(name));
    }

    public void removeChannel(Channel channel) {
        this.windowTreeModel.removeChannel(channel);
    }

    void removeWindow(ChildWindow cw) {
        this.cardLayout.removeLayoutComponent(cw);
    }

    void setNowChannel(Channel channel) {
        this.cardLayout.show(this.cardPanel, channel.toString() + channel.getIRC().getDate());
        this.nowChannel = channel;
        this.setTopic();
        this.tree.expandRow(0);
    }

    public IRC getIRC() {
        if (this.nowChannel == null) {
            return null;
        }
        return this.nowChannel.getIRC();
    }

    public Channel getNowChannel() {
        return this.nowChannel;
    }

    public Channel getNowServer() {
        return this.windowTreeModel.getNowServer();
    }

    public void setTopic() {
        String title = "";
        if (this.nowChannel != null) {
            title = title + this.nowChannel.toString() + ' ' + this.nowChannel.getMode().toString() + ' ' + this.nowChannel.getTopic() + " - ";
        }
        this.setTopic(title);
    }

    public void addUser(Channel channel, String nick) {
        this.windowTreeModel.addUser(channel, nick);
    }

    public Channel makeChannel(IRC irc, String name) {
        ChildWindow cw = new ChildWindow(name, irc, this);
        this.windowTreeModel.addChannel(cw);
        return cw;
    }

    public Channel makeServerChannel(IRC irc, String name) {
        ChildWindow cw = new ChildWindow(name, irc, this);
        this.windowTreeModel.removeParentWindow();
        this.windowTreeModel.addParentWindow(cw);
        return cw;
    }

    public boolean removeUser(Channel channel, String nick) {
        return this.windowTreeModel.removeUser(channel, nick);
    }

    public void removeUser(IRC irc, String nick, String message) {
        Enumeration channels = irc.getChannels();
        while (channels.hasMoreElements()) {
            Channel channel = (Channel)channels.nextElement();
            if (!channel.equals(nick) && !this.removeUser(channel, nick)) continue;
            String[] args = new String[]{nick, message};
            channel.append(IRCMessageFormat.getQuitMessage(args));
        }
    }

    public void setChanop(Channel channel, String nick, boolean flag) {
        this.windowTreeModel.setUserMode(channel, nick, "@", flag);
    }

    public void setVoice(Channel channel, String nick, boolean flag) {
        MutableTreeNode childNode = this.windowTreeModel.getUserNode(this.windowTreeModel.getChannelTreeNode(channel), nick);
        char head = childNode.toString().charAt(0);
        if (head != '@') {
            this.windowTreeModel.setUserMode(channel, nick, "+", flag);
        }
    }

    public void changeUser(IRC irc, String oldNick, String newNick) {
        Enumeration channels = irc.getChannels();
        while (channels.hasMoreElements()) {
            MutableTreeNode childNode;
            Channel channel = (Channel)channels.nextElement();
            MutableTreeNode treeNode = this.windowTreeModel.getChannelTreeNode(channel);
            if (channel.equals(oldNick)) {
                ChildWindow window = (ChildWindow)channel;
                irc.removeChannel(channel);
                window.setChannelName(newNick);
                irc.addChannel(channel);
                this.windowTreeModel.addChannel(window);
                this.setChannel(window);
                String[] args = new String[]{oldNick, newNick};
                channel.append(IRCMessageFormat.getNickMessage(args));
                continue;
            }
            if (treeNode == null || (childNode = this.windowTreeModel.getUserNode(treeNode, oldNick)) == null) continue;
            char head = childNode.toString().charAt(0);
            String fullNewNick = newNick;
            if (head == '@' || head == '+') {
                fullNewNick = head + newNick;
            }
            this.windowTreeModel.changeUserNode(treeNode, childNode, fullNewNick);
            String[] args = new String[]{oldNick, newNick};
            channel.append(IRCMessageFormat.getNickMessage(args));
        }
    }

    public void append(Channel channel, String string) {
        if (channel == null || !channel.equals(this.nowChannel)) {
            this.listenTA.append(string + "\r\n");
        }
    }

    public void show() {
        this.frame.show();
    }

    public Toolkit getToolkit() {
        return this.frame.getToolkit();
    }

    public Dimension getSize() {
        return this.frame.getSize();
    }

    public void setLocation(int x, int y) {
        this.frame.setLocation(x, y);
    }

    public void setJMenuBar(JMenuBar bar) {
        this.frame.setJMenuBar(bar);
    }

    public void setDefaultCloseOperation(int i) {
        this.frame.setDefaultCloseOperation(i);
    }

    private void setTopic(String string) {
        this.frame.setTitle(string + this.applName);
    }

    public void exit() {
        int i;
        if (this.isConnected()) {
            this.Disconnection();
        }
        if ((i = this.frame.getDefaultCloseOperation()) == 1) {
            this.frame.hide();
        } else if (i == 2) {
            this.frame.dispose();
        } else if (i == 3) {
            System.exit(0);
        }
    }

    public JTextField getJTextField() {
        return this.tf;
    }

    public void setException(Exception e) {
        JOptionPane.showMessageDialog(null, e.getLocalizedMessage());
        super.setException(e);
    }

    private class ChildWindowInputListener
    implements ActionListener {
        private final char LF = (char)10;

        private ChildWindowInputListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            String string = Window.this.tf.getText();
            if (!string.equals("")) {
                if (string.indexOf(10) > 0) {
                    StringTokenizer st = new StringTokenizer(string, "\n");
                    while (st.hasMoreTokens()) {
                        Window.this.getNowChannel().writeMessage(st.nextToken());
                    }
                } else {
                    Window.this.getNowChannel().writeMessage(string);
                }
            }
            Window.this.tf.setText("");
        }
    }

    private class TreeSelectionListenerImpl
    implements TreeSelectionListener {
        private TreeSelectionListenerImpl() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getNewLeadSelectionPath();
            if (path == null) {
                path = e.getOldLeadSelectionPath();
            }
            Object channel = null;
            int count = path.getPathCount();
            channel = count < 4 ? path.getPath()[path.getPathCount() - 1] : path.getPath()[1];
            if (count < 4) {
                DefaultMutableTreeNode dmt = (DefaultMutableTreeNode)channel;
                Channel nowChannel = (Channel)dmt.getUserObject();
                Window.this.setNowChannel(nowChannel);
            }
            Window.this.tf.requestFocus();
        }
    }

    private class WindowListenerImpl
    extends WindowAdapter {
        private WindowListenerImpl() {
        }

        public void windowClosed(WindowEvent we) {
            Window.this.exit();
        }
    }
}

