/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jirc.net;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import jp.sourceforge.jirc.net.Channel;
import jp.sourceforge.jirc.net.Command;
import jp.sourceforge.jirc.net.IRC;
import jp.sourceforge.jirc.net.NUMERICREPLY;
import jp.sourceforge.jirc.text.IRCMessageFormat;

class CommandMap {
    private String CTCP_VERSION = "jIRC version 0.1";
    private IRC irc;
    private Hashtable commandList = new Hashtable();

    public CommandMap(IRC irc) {
        this.irc = irc;
        this.commandList.put("KILL", new KILL());
        this.commandList.put("PING", new PING());
        this.commandList.put("NICK", new NICK());
        this.commandList.put("JOIN", new JOIN());
        this.commandList.put("PART", new PART());
        this.commandList.put("MODE", new MODE());
        this.commandList.put("QUIT", new QUIT());
        this.commandList.put("KICK", new KICK());
        this.commandList.put("ERROR", new ERROR());
        this.commandList.put("TOPIC", new TOPIC());
        this.commandList.put("NOTICE", new NOTICE());
        this.commandList.put("INVITE", new INVITE());
        this.commandList.put("PRIVMSG", new PRIVMSG());
        this.commandList.put("WALLOPS", new WALLOPS());
        this.commandList.put("NUMERICREPLY", new NUMERICREPLY(irc));
    }

    public Command getCommand(String commandName) {
        return (Command)this.commandList.get(commandName);
    }

    Channel getChannelOrPriv(String channelname, String nick) {
        Channel channel = this.irc.getChannel(channelname);
        if (channel == null && (channel = this.irc.getChannel(nick)) == null) {
            channel = this.irc.makeChannel(nick);
        }
        return channel;
    }

    static String removeColon(String string) {
        if (string.indexOf(58) != 0) {
            return string;
        }
        return string.substring(string.indexOf(58) + 1);
    }

    static String getNick(String prefix) {
        int i = prefix.indexOf(33);
        if (i > 0) {
            prefix = CommandMap.removeColon(prefix).substring(0, i - 1);
        }
        return prefix;
    }

    public class PRIVMSG
    extends AbstractCommand {
        public void execute(String prefix, String params) {
            String nick = CommandMap.getNick(prefix);
            StringTokenizer st = new StringTokenizer(params, " ", false);
            String channelname = st.nextToken();
            String message = CommandMap.removeColon(st.nextToken("\r\n").trim());
            if (message.length() > 0 && message.charAt(0) == '\u0001') {
                int j = 0;
                int i = 2;
                while (i < message.length()) {
                    if (message.charAt(i) == '\u0001') {
                        j = i;
                    }
                    ++i;
                }
                if (j == 0) {
                    j = message.length();
                }
                this.ctcp(nick, message.substring(1, j));
            } else {
                Channel channel = CommandMap.this.getChannelOrPriv(channelname, nick);
                String[] args = new String[]{nick, channelname, message};
                channel.append(IRCMessageFormat.getPrivmsgMessage(args));
                CommandMap.this.irc.getClient().append(channel, IRCMessageFormat.getPrivmsgFullMessage(args));
            }
        }

        private void ctcp(String nick, String value) {
            try {
                String replay = null;
                if (value.startsWith("PING")) {
                    replay = value;
                } else if (value.startsWith("VERSION")) {
                    replay = CommandMap.this.CTCP_VERSION;
                } else if (value.startsWith("TIME")) {
                    DateFormat date = DateFormat.getDateTimeInstance(1, 1);
                    replay = "TIME " + date.format(new Date());
                } else if (value.startsWith("CLIENTINFO")) {
                    replay = "CLIENTINFO PING TIME VERSION";
                }
                CommandMap.this.irc.NOTICE(nick, '\u0001' + replay + '\u0001');
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class NOTICE
    extends AbstractCommand {
        private NOTICE() {
        }

        public void execute(String prefix, String params) {
            String nick = CommandMap.getNick(prefix);
            StringTokenizer st = new StringTokenizer(params, " ", false);
            String channelname = st.nextToken();
            String message = CommandMap.removeColon(st.nextToken("\r\n").trim());
            Channel channel = CommandMap.this.getChannelOrPriv(channelname, nick);
            String[] args = new String[]{nick, channelname, message};
            channel.append(IRCMessageFormat.getNoticeMessage(args));
            CommandMap.this.irc.getClient().append(channel, IRCMessageFormat.getNoticeFullMessage(args));
        }
    }

    private class KICK
    extends AbstractCommand {
        private KICK() {
        }

        public void execute(String prefix, String params) {
            String nick = CommandMap.getNick(prefix);
            StringTokenizer st = new StringTokenizer(params, " ", false);
            String channelName = st.nextToken();
            String target = st.nextToken();
            String message = CommandMap.removeColon(st.nextToken("\r\n").trim());
            Channel channel = CommandMap.this.irc.getChannel(channelName);
            if (target.equalsIgnoreCase(CommandMap.this.irc.getNick())) {
                CommandMap.this.irc.removeChannel(channel);
                channel = CommandMap.this.irc.getChannel(CommandMap.this.irc.getServer());
            } else {
                channel.removeUser(target);
            }
            String[] args = new String[]{nick, channelName, target, message};
            channel.append(IRCMessageFormat.getKickMessage(args));
        }
    }

    private class MODE
    extends AbstractCommand {
        private MODE() {
        }

        public void execute(String prefix, String params) {
            StringTokenizer st = new StringTokenizer(params, " ", false);
            String channelname = st.nextToken();
            String mode = st.nextToken("\r\n").trim();
            if (channelname.equalsIgnoreCase(CommandMap.this.irc.getNick())) {
                String[] args = new String[]{channelname, mode};
                String message = IRCMessageFormat.getModeMessage(args);
                Channel channel = CommandMap.this.irc.getChannel(CommandMap.this.irc.getServer());
                channel.append(message);
                CommandMap.this.irc.getClient().append(channel, message);
            } else {
                Channel channel = CommandMap.this.irc.getChannel(channelname);
                if (channel != null) {
                    channel.setMode(CommandMap.getNick(prefix), mode);
                }
            }
        }
    }

    private class TOPIC
    extends AbstractCommand {
        private TOPIC() {
        }

        public void execute(String prefix, String params) {
            StringTokenizer st = new StringTokenizer(params, " ", false);
            String channelname = st.nextToken();
            String topic = CommandMap.removeColon(st.nextToken("\r\n").trim());
            Channel channel = CommandMap.this.irc.getChannel(channelname);
            channel.setTopic(topic);
            String[] args = new String[]{CommandMap.getNick(prefix), channelname, topic};
            channel.append(IRCMessageFormat.getTopicMessage(args));
        }
    }

    private class PART
    extends AbstractCommand {
        private PART() {
        }

        public void execute(String prefix, String params) {
            String nick = CommandMap.getNick(prefix);
            StringTokenizer st = new StringTokenizer(params, " ", false);
            String channelName = st.nextToken();
            String message = CommandMap.removeColon(st.nextToken("\r\n").trim());
            Channel channel = CommandMap.this.irc.getChannel(channelName);
            if (nick.equalsIgnoreCase(CommandMap.this.irc.getNick())) {
                CommandMap.this.irc.removeChannel(channel);
                channel = CommandMap.this.irc.getChannel(CommandMap.this.irc.getServer());
            } else {
                channel.removeUser(nick);
            }
            String[] args = new String[]{nick, channelName, message};
            channel.append(IRCMessageFormat.getPartMessage(args));
        }
    }

    private class JOIN
    extends AbstractCommand {
        private JOIN() {
        }

        public void execute(String prefix, String params) {
            String nick = CommandMap.getNick(prefix);
            String channelName = CommandMap.removeColon(params);
            if (nick.equals(CommandMap.this.irc.getNick())) {
                CommandMap.this.irc.makeChannel(channelName);
                try {
                    CommandMap.this.irc.protectedMODE(channelName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Channel channel = CommandMap.this.irc.getChannel(channelName);
                String[] args = new String[]{nick, channelName};
                channel.append(IRCMessageFormat.getJoinMessage(args));
                channel.addUser(nick);
            }
        }
    }

    private class NICK
    extends AbstractCommand {
        private NICK() {
        }

        public void execute(String prefix, String params) {
            String oldNick = CommandMap.getNick(prefix);
            String newNick = CommandMap.removeColon(params);
            CommandMap.this.irc.changeNick(oldNick, newNick);
        }
    }

    private class PING
    extends AbstractCommand {
        private PING() {
        }

        public void execute(String params) {
            try {
                CommandMap.this.irc.PONG(params);
            }
            catch (IOException e) {
                CommandMap.this.irc.close();
            }
        }
    }

    private class ERROR
    extends AbstractCommand {
        private ERROR() {
        }

        public void execute(String params) {
            CommandMap.this.irc.getChannel(CommandMap.this.irc.getServer()).append(CommandMap.removeColon(params));
            CommandMap.this.irc.close();
        }
    }

    private class KILL
    extends AbstractCommand {
        private KILL() {
        }

        public void execute(String prefix, String params) {
            String nick = CommandMap.getNick(prefix);
            StringTokenizer st = new StringTokenizer(params, " ", false);
            String channelName = st.nextToken();
            String message = CommandMap.removeColon(st.nextToken("\r\n").trim());
            String[] args = new String[]{nick, channelName, message};
            CommandMap.this.irc.getChannel(CommandMap.this.irc.getServer()).append(IRCMessageFormat.getKillMessage(args));
            CommandMap.this.irc.close();
        }
    }

    private class WALLOPS
    extends AbstractCommand {
        private WALLOPS() {
        }

        public void execute(String prefix, String params) {
            String[] args = new String[]{prefix, CommandMap.removeColon(params)};
            CommandMap.this.irc.getChannel(CommandMap.this.irc.getServer()).append(IRCMessageFormat.getWallopsMessage(args));
        }
    }

    private class INVITE
    extends AbstractCommand {
        private INVITE() {
        }

        public void execute(String prefix, String params) {
            String nick = CommandMap.getNick(prefix);
            StringTokenizer st = new StringTokenizer(params, " ", false);
            String target = st.nextToken();
            String channel = CommandMap.removeColon(st.nextToken("\r\n").trim());
            String[] args = new String[]{nick, target, channel};
            CommandMap.this.irc.getChannel(CommandMap.this.irc.getServer()).append(IRCMessageFormat.getInviteMessage(args));
        }
    }

    private class QUIT
    extends AbstractCommand {
        private QUIT() {
        }

        public void execute(String prefix, String params) {
            String nick = CommandMap.getNick(prefix);
            if (nick.equalsIgnoreCase(CommandMap.this.irc.getNick())) {
                CommandMap.this.irc.close();
            } else {
                CommandMap.this.irc.removeNick(nick, CommandMap.removeColon(params));
            }
        }
    }

    private abstract class AbstractCommand
    implements Command {
        private AbstractCommand() {
        }

        public void execute(String prefix, String params) {
        }

        public void execute(String params) {
        }
    }
}

