/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jirc.net;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import jp.sourceforge.jirc.net.IRC;

class IRCIO
extends Thread {
    private IRC irc;
    private BufferedReader is = null;
    private IRCIOWriter os = null;
    private boolean runnable = false;

    IRCIO(IRC irc, String server) throws Exception {
        this(irc, server, 6667);
    }

    IRCIO(IRC irc, String server, int port) throws Exception {
        super("IRCIO");
        if (irc != null) {
            this.irc = irc;
            this.runnable = true;
        }
        this.open(server, port);
    }

    void open(String server, int port) throws Exception {
        Socket s = null;
        try {
            s = new Socket(server, port);
            System.out.println("SO_KEEPALIVE is " + s.getKeepAlive());
            System.out.println("SO_RCVBUF  is " + s.getReceiveBufferSize());
            System.out.println("SO_SNDBUF  is " + s.getSendBufferSize());
            System.out.println("SO_LINGER  is " + s.getSoLinger());
            System.out.println("SO_TIMEOUT is " + s.getSoLinger());
            System.out.println("TCP_NODELAY is " + s.getTcpNoDelay());
            this.is = new BufferedReader(new InputStreamReader(s.getInputStream()));
            this.os = new IRCIOWriter(s.getOutputStream());
            this.os.start();
        }
        catch (Exception e) {
            this.irc.setException(e);
            this.irc.close();
            s = null;
            this.is = null;
            this.os = null;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void close() {
        this.runnable = false;
        try {
            try {
                this.is.close();
                this.os.close();
                this.os.join();
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var3_2 = null;
                this.is = null;
                this.os = null;
            }
            Object var3_1 = null;
            this.is = null;
            this.os = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.is = null;
            this.os = null;
            throw throwable;
        }
    }

    public void run() {
        System.out.println("#IRCIO RUN");
        Thread.currentThread().getThreadGroup().list();
        String string = null;
        while (this.runnable) {
            try {
                string = this.is.readLine();
            }
            catch (SocketException e) {
                this.irc.setException(e);
                this.irc.close();
            }
            catch (Exception e) {
                this.irc.setException(e);
            }
            if (string == null) {
                this.close();
                continue;
            }
            try {
                this.irc.readMessage(string);
            }
            catch (NullPointerException e) {
                this.irc.setException(e);
                this.irc.close();
            }
        }
    }

    final synchronized void writeMessage(String message) throws IOException {
        if (!message.startsWith("PONG")) {
            System.out.print(message);
        }
        this.os.writeBytes(message);
    }

    class IRCIOWriter
    extends Thread {
        private DataOutputStream os = null;
        private LinkedList list = new LinkedList();

        IRCIOWriter(OutputStream os) {
            super("IRCIOWriteer");
            this.os = new DataOutputStream(os);
        }

        synchronized void writeBytes(String message) {
            this.list.addLast(message);
            int i = this.list.size();
            if (i > 1) {
                System.out.println("write count:" + i);
            }
        }

        public void run() {
            System.out.println("#IRCIOWRITER RUN");
            Thread.currentThread().getThreadGroup().list();
            try {
                while (IRCIO.this.runnable) {
                    if (this.list.size() == 0) continue;
                    this.os.writeBytes((String)this.list.removeFirst());
                }
            }
            catch (Exception e) {
                IRCIO.this.irc.close();
                IRCIO.this.irc.setException(e);
            }
        }

        void close() {
            try {
                this.os.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

