/* -----------------------------------------------------------------------
 SearchDialog.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/12/06
 *
 * File Name: SearchDialog.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 *
 */
package jp.co.jlight;

import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;
/**
 * Search/Replace
 */
public class SearchDialog {

	private Shell parent = null;
	private Shell dialog = null;

	private Label labelSearch;		// ٥
	private Label labelReplace;		// ִ٥
	private Combo cmbSearch;		// ܥܥå
	private Combo cmbReplace;		// ִܥܥå
	private Group grpDirection;		// 롼
	private Group grpOptions;		// ץ󥰥롼
	private Button btnNext;			// Ĥ
	private Button btnPrev;			// ɤ
	private Button btnWord;			// ʸ/ʸ
	private Button btnAround;		// ޤ֤
	private Button btnSearch;		// 
	private Button btnReplace;		// ִ
	private Button btnReplaceAll;	// ִ
	private Button btnClose;		// Ĥ

	private ControlSet cs;

	private int searchListLimit = 8;
	private int replaceListLimit = 8;

	private String searchText;

	private boolean closeFlg = false;
	private boolean selectedFlg = false;

	private static Resources resources = new Resources();

	/**
	 * SearchDialog󥹥ȥ饯
	 * @param parent
	 */
	SearchDialog(Shell parent) {
		this.parent = parent;
		initDialog();
	}

	/**
	 * SerachDialog
	 */
	private void initDialog() {
		// 
		dialog = new Shell(parent, SWT.DIALOG_TRIM);
		dialog.setText(resources.getSearchDialogTitle());
		dialog.setLayout(new FormLayout());
		dialog.setSize(450, 255);

		labelSearch = new Label(dialog, SWT.RIGHT);
		labelSearch.setText(resources.getSearchDialogSearchLabel());
		cmbSearch = new Combo(dialog, SWT.DROP_DOWN);

		labelReplace = new Label(dialog, SWT.RIGHT);
		labelReplace.setText(resources.getSearchDialogReplaceLabel());
		cmbReplace = new Combo(dialog, SWT.DROP_DOWN);

		grpDirection = new Group(dialog, SWT.SHADOW_ETCHED_IN);
		grpDirection.setText(resources.getSearchDialogDirection());
		grpDirection.setLayout(new FormLayout());
		
		grpOptions = new Group(dialog, SWT.SHADOW_ETCHED_IN);
		grpOptions.setText(resources.getSearchDialogOptions());
		grpOptions.setLayout(new FormLayout());

		btnNext = new Button(grpDirection, SWT.RADIO);
		btnNext.setText(resources.getSearchDialogForward());

		btnPrev = new Button(grpDirection, SWT.RADIO);
		btnPrev.setText(resources.getSearchDialogBackward());

		btnWord = new Button(grpOptions, SWT.CHECK);
		btnWord.setText(resources.getSearchDialogSensitive());

		btnAround = new Button(grpOptions, SWT.CHECK);
		btnAround.setText(resources.getSearchDialogAround());

		btnReplace = new Button(dialog, SWT.PUSH);
		btnReplace.setText(resources.getSearchDialogReplace());

		btnReplaceAll = new Button(dialog, SWT.PUSH);
		btnReplaceAll.setText(resources.getSearchDialogReplaceAll());

		btnSearch = new Button(dialog, SWT.PUSH);
		btnSearch.setText(resources.getSearchDialogSearch());

		btnClose = new Button(dialog, SWT.PUSH);
		btnClose.setText(resources.getSearchDialogClose());

		// ܥ򤵤줿ν
		btnSearch.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				// Ǥ֤Ƚ
				if (!getSearchTextCondition()) return;
				// ʸ
				setSearchText(cmbSearch.getText());
				// 
				if (btnNext.getSelection()) {
					searchNext();
				} else {
					searchPrev();
				}
				// ܥꥹȤʸɲ
				setSearchList();
			}
		});
		// ִܥ򤵤줿ν
		btnReplace.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				// Ǥ֤Ƚ
				if (!getSearchTextCondition()) return;
				// ʸִ
				replaceText();
				// γʸ򸡺
				setSearchText(cmbSearch.getText());
				if (btnNext.getSelection()) {
					searchNext();
				} else {
					searchPrev();
				}
				// ܥꥹȤʸɲ
				setReplaceList();
			}
		});
		// ִܥ򤵤줿ν
		btnReplaceAll.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				// Ǥ֤Ƚ
				if (!getSearchTextCondition()) return;
				// ʸִ
				replaceAllText();
				// ܥꥹȤʸɲ
				setReplaceList();
			}
		});
		// Ĥܥ򤵤줿ν
		btnClose.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				dialog.setVisible(false);
				searchText = "";
			}
		});
		// ܤؤѹäν
		cmbSearch.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent event) {
				setButtonStatus();
			}
		});
		// ܤΥꥹȤ򤵤줿ν
		cmbSearch.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				selectedFlg = true;
			}
		});
		// /ִShellListenerɲ
		dialog.addShellListener(new ShellAdapter() {
			public void shellClosed(ShellEvent event) {
				if (!closeFlg) {
					btnReplace.setEnabled(true);
					dialog.setVisible(false);
				}
				event.doit = closeFlg;
			}
			public void shellActivated(ShellEvent event) {
				if (cs != null) {
					if (!selectedFlg && cs.getSelectionText().length() > 0) {
						cmbSearch.setText(cs.getSelectionText());
					}
				}
			}
			public void shellDeactivated(ShellEvent event) {
				selectedFlg = false;
			}
		});
		// 쥤Ȥ
		setLayout();

		btnNext.setSelection(true);
		btnWord.setSelection(true);

		setButtonStatus();
	}

	/**
	 * /ִɽ
	 */
	public void showDialog() {
		if (cs == null) return;
		dialog.setVisible(true);
	}

	/**
	 * λɬƤӽФ᥽å
	 */
	public void dispose() {
		closeFlg = true;
		dialog.dispose();
	}

	/**
	 * ʸ
	 */
	public boolean searchNext() {
		String string = null;
		String sch = null;
		int start = 0;
		int startPos = 0;
		int length = searchText.length();
		boolean found = false;

		// ʸʸζ̤򤹤뤫ɤ
		if (btnWord.getSelection()) {
			string = cs.getStyledText().getText();
			sch = searchText;
		} else {
			string = cs.getStyledText().getText().toUpperCase();
			sch = searchText.toUpperCase();
		}
		// ϰ֤
		startPos = cs.getSelectionRange().x + cs.getSelectionRange().y;
		// 
		start = string.indexOf(sch, startPos);
		if (start != -1) {
			foundText(start, length);
			found = true;
		} else if (start == -1 && btnAround.getSelection()) {
			// ޤ֤
			start = string.indexOf(sch, 0);
			if (start != -1) {
				foundText(start, length);
				found = true;
			}
		}
		return found;
	}

	/**
	 * ʸ
	 */
	public boolean searchPrev() {
		String string = null;
		String sch = null;
		int start = 0;
		int startPos = 0;
		int length = searchText.length();
		boolean found = false;

		// ʸʸζ̤򤹤뤫ɤ
		if (btnWord.getSelection()) {
			string = cs.getStyledText().getText();
			sch = searchText;
		} else {
			string = cs.getStyledText().getText().toUpperCase();
			sch = searchText.toUpperCase();
		}
		// ϰ֤
		if (cs.getSelectionRange().y == 0) {
			startPos = cs.getSelectionRange().x - 1;
		} else {
			startPos = cs.getSelectionRange().x - length;
		}
		// 
		start = string.lastIndexOf(sch, startPos);
		if (start != -1) {
			foundText(start, length);
			found = true;
		} else if (start == -1 && btnAround.getSelection()) {
			// ޤ֤
			start = string.lastIndexOf(sch, (string.length() - 1));
			if (start != -1) {
				foundText(start, length);
				found = true;
			}
		}
		return found;
	}

	/**
	 * ʸִ
	 */
	private void replaceText() {
		String sch = cmbSearch.getText();
		String rpc = cmbReplace.getText();
		int xpos = cs.getSelectionRange().x;
		int length = sch.length();
		// ʸִ
		if (sch.equals(cs.getSelectionText())) {
			cs.replaceTextRange(xpos, length, rpc);
		}
	}

	/**
	 * Ƥʸִ
	 */
	private void replaceAllText() {
		// ʸ
		setSearchText(cmbSearch.getText());
		if (!searchPrev() && !searchNext()) {
			return;
		}
		cs.setOneSegment(true);
		// ִ
		while (searchPrev()) {
			replaceText();
		}
		// ִ
		while (searchNext()) {
			replaceText();
		}
		cs.setOneSegment(false);
	}

	/**
	 * ʸ󤬸Ĥäν
	 * @param start
	 * @param length
	 */
	private void foundText(int start, int length) {
		cs.setSelectionRange(start, length);
		cs.setLineAndColumn();
		btnReplace.setEnabled(true);
	}

	/**
	 * 郎·äƤ뤫ɤ
	 * @return boolean
	 */
	private boolean getSearchTextCondition() {
		if (cs == null || cs.getStyledText() == null
			|| cmbSearch.getText() == null
			|| cmbSearch.getText().length() < 1) return false;
		return true;
	}

	/**
	 * ܥξ֤
	 */
	private void setButtonStatus() {
		if (cmbSearch.getText() != null && cmbSearch.getText().length() > 0) {
			btnSearch.setEnabled(true);
			btnReplaceAll.setEnabled(true);
		} else {
			btnSearch.setEnabled(false);
			btnReplace.setEnabled(false);
			btnReplaceAll.setEnabled(false);
		}
	}

	/**
	 * cmbSearchܥܥåΥꥹȤ򹹿
	 */
	private void setSearchList() {
		String sch = cmbSearch.getText();
		// ꥹȤɲ
		cmbSearch.add(sch, 0);
		for (int i = 1; i < cmbSearch.getItems().length; i++) {
			if (sch.equals(cmbSearch.getItem(i))) {
				cmbSearch.remove(i);
			}
		}
		// ꥹȤο
		if (cmbSearch.getItemCount() > searchListLimit) {
			cmbSearch.remove(cmbSearch.getItemCount() - 1);
		}
	}

	/**
	 * cmbReplaceܥܥåΥꥹȤ򹹿
	 */
	private void setReplaceList() {
		String rpc = cmbReplace.getText();
		if (rpc.length() < 1) return;
		// ꥹȤɲ
		cmbReplace.add(rpc, 0);
		for (int i = 1; i < cmbReplace.getItems().length; i++) {
			if (rpc.equals(cmbReplace.getItem(i))) {
				cmbReplace.remove(i);
			}
		}
		// ꥹȤο
		if (cmbReplace.getItemCount() > replaceListLimit) {
			cmbReplace.remove(cmbReplace.getItemCount() - 1);
		}
	}

	/**
	 * SearchDialog˥եܤ
	 */
	public void setFocus() {
		dialog.setFocus();
	}

	/**
	 * ʸ
	 * @param searchText
	 */
	public void setSearchText(String searchText) {
		if (searchText != null) {
			this.searchText = searchText;
		} else {
			this.searchText = "";
		}
	}

	/**
	 * ߤControlSet
	 * @param cs
	 */
	public void setControlSet(ControlSet cs) {
		this.cs = cs;
	}

	/**
	 * Dialog˥쥤Ȥꤷȥ֤
	 */
	private void setLayout() {
		// ȥ쥤Ȥ
		FormData d1 = new FormData();
		d1.top = new FormAttachment(0, 17);
		d1.right = new FormAttachment(0, 80);
		
		labelSearch.setLayoutData(d1);
		
		FormData d2 = new FormData();
		d2.top = new FormAttachment(0, 15);
		d2.left = new FormAttachment(labelSearch, 10);
		d2.right = new FormAttachment(labelSearch, 380);
		
		cmbSearch.setLayoutData(d2);
		
		FormData d3 = new FormData();
		d3.top = new FormAttachment(labelSearch, 12);
		d3.right = new FormAttachment(0, 80);
		
		labelReplace.setLayoutData(d3);
		
		FormData d4 = new FormData();
		d4.top = new FormAttachment(labelSearch, 10);
		d4.left = new FormAttachment(labelReplace, 10);
		d4.right = new FormAttachment(labelSearch, 380);

		cmbReplace.setLayoutData(d4);
		
		FormData d5 = new FormData();
		d5.top = new FormAttachment(labelReplace, 15);
		d5.left = new FormAttachment(0, 20);
		d5.width = 170;
		d5.height = 70;
		
		grpDirection.setLayoutData(d5);
		
		FormData d51 = new FormData();
		d51.top = new FormAttachment(0, 8);
		d51.left = new FormAttachment(0, 8);
		
		btnNext.setLayoutData(d51);
		
		FormData d52 = new FormData();
		d52.top = new FormAttachment(btnNext, 5);
		d52.left = new FormAttachment(0, 8);
		
		btnPrev.setLayoutData(d52);
		
		FormData d6 = new FormData();
		d6.top = new FormAttachment(labelReplace, 15);
		d6.left = new FormAttachment(grpDirection, 5);
		d6.width = 170;
		d6.height = 70;
		
		grpOptions.setLayoutData(d6);
		
		FormData d61 = new FormData();
		d61.top = new FormAttachment(0, 8);
		d61.left = new FormAttachment(0, 8);
		
		btnWord.setLayoutData(d61);
		
		FormData d62 = new FormData();
		d62.top = new FormAttachment(btnWord, 5);
		d62.left = new FormAttachment(0, 8);
		
		btnAround.setLayoutData(d62);
		
		FormData d71 = new FormData();
		d71.top = new FormAttachment(grpDirection, 10);
		d71.left = new FormAttachment(0, 10);
		d71.width = 100;
		d71.height = 30;
		
		btnReplace.setLayoutData(d71);

		FormData d72 = new FormData();
		d72.top = new FormAttachment(grpDirection, 10);
		d72.left = new FormAttachment(btnReplace, 5);
		d72.width = 100;
		d72.height = 30;
		
		btnReplaceAll.setLayoutData(d72);
		
		FormData d73 = new FormData();
		d73.top = new FormAttachment(grpDirection, 10);
		d73.left = new FormAttachment(btnReplaceAll, 5);
		d73.width = 100;
		d73.height = 30;
		
		btnSearch.setLayoutData(d73);
		
		FormData d74 = new FormData();
		d74.top = new FormAttachment(grpDirection, 10);
		d74.left = new FormAttachment(btnSearch, 5);
		d74.width = 100;
		d74.height = 30;
		
		btnClose.setLayoutData(d74);

	}
}
