/* -----------------------------------------------------------------------
 LineStyler.java
 Copyright (C) 2004  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2004/01/17
 *
 * File Name: LineStyler.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 *
 */
package jp.co.jlight.stylers;

import org.eclipse.swt.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import java.util.*;
/**
 * ʸϤԤʤ
 */
public class LineStyler implements LineStyleListener {

	private SyntaxScanner scanner = null;

	private static final String[] languages = {"JAVA"
											  };
	int[] tokenColors;
	Color[] colors = null;
	Vector blockComments = new Vector();

	/**
	 * LineStyler󥹥ȥ饯(ǻѤ빽ʸϴ)
	 * @param lang
	 */
	public LineStyler(String lang) {
		setLineStyler(lang);
	}

	/**
	 * ꤵ줿LineStylerꤹ
	 * @param lang
	 */
	public void setLineStyler(String lang) {
		if (lang.equals("JAVA")) {
			scanner = new JavaSyntaxScanner();
		} else {
			scanner = null;
			disposeColors();
		}
		if (scanner == null) return;
		initializeColors();
	}

	private void initializeColors() {
		Display display = Display.getDefault();
		colors= new Color[] {
			new Color(display, new RGB(0, 0, 0)),		// black
			new Color(display, new RGB(255,   0,   0)),	// red
			new Color(display, new RGB(  0, 255,   0)),	// green
			new Color(display, new RGB(  0,   0, 255)),	// blue
			new Color(display, new RGB( 42,   0, 255)),	// Strings
			new Color(display, new RGB(127,   0,  85)),	// Keywords
			new Color(display, new RGB( 63, 127,  95))	// Comment 
		};
		tokenColors= new int[StylerKeys.MAXIMUM_TOKEN];
		tokenColors[StylerKeys.WORD]=		0;
		tokenColors[StylerKeys.WHITE]=		0;
		tokenColors[StylerKeys.KEY]=		5;
		tokenColors[StylerKeys.COMMENT]=	6;
		tokenColors[StylerKeys.STRING]= 	4;
		tokenColors[StylerKeys.OTHER]=		0;
		tokenColors[StylerKeys.NUMBER]=		0;
	}

	private void disposeColors() {
		if (colors == null) return;
		for (int i=0;i<colors.length;i++) {
			colors[i].dispose();
		}
	}

	private Color getColor(int type) {
		if (type < 0 || type >= tokenColors.length) {
			return null;
		}
		return colors[tokenColors[type]];
	}

	private boolean inBlockComment(int start, int end) {
		for (int i=0; i<blockComments.size(); i++) {
			int[] offsets = (int[])blockComments.elementAt(i);
			// start of comment in the line
			if ((offsets[0] >= start) && (offsets[0] <= end)) return true;
			// end of comment in the line
			if ((offsets[1] >= start) && (offsets[1] <= end)) return true;
			if ((offsets[0] <= start) && (offsets[1] >= end)) return true;
		}
		return false;
	}

	/**
	 * Event.detail			line start offset (input)	
	 * Event.text 			line text (input)
	 * LineStyleEvent.styles	 Enumeration of StyleRanges, need to be in order. (output)
	 * LineStyleEvent.background line background color (output)
	 */
	public void lineGetStyle(LineStyleEvent event) {
		if (scanner == null) return;
		Vector styles = new Vector();
		int token;
		StyleRange lastStyle;
		// If the line is part of a block comment, create one style for the entire line.
		if (inBlockComment(event.lineOffset, event.lineOffset + event.lineText.length())) {
			styles.addElement(new StyleRange(event.lineOffset, event.lineText.length(), getColor(StylerKeys.COMMENT), null));
			event.styles = new StyleRange[styles.size()];
			styles.copyInto(event.styles);
			return;
		}
		Color defaultFgColor = ((Control)event.widget).getForeground();
		scanner.setRange(event.lineText);
		token = scanner.nextToken();
		while (token != StylerKeys.EOF) {
			if (token == StylerKeys.OTHER) {
				// do nothing for non-colored tokens
			} else if (token != StylerKeys.WHITE) {
				Color color = getColor(token);
				// Only create a style if the token color is different than the 
				// widget's default foreground color and the token's style is not 
				// bold.  Keywords are bolded.
				if ((!color.equals(defaultFgColor)) || (token == StylerKeys.KEY)) {
					StyleRange style = new StyleRange(scanner.getStartOffset() + event.lineOffset, scanner.getLength(), color, null);
					if (token == StylerKeys.KEY) {
						style.fontStyle = SWT.BOLD;
					}
					if (styles.isEmpty()) {
						styles.addElement(style);
					} else {
						// Merge similar styles.  Doing so will improve performance.
						lastStyle = (StyleRange)styles.lastElement();
						if (lastStyle.similarTo(style) && (lastStyle.start + lastStyle.length == style.start)) {
							lastStyle.length += style.length;
						} else {
							styles.addElement(style); 
						}
					} 
				} 
			} else if ((!styles.isEmpty()) && ((lastStyle=(StyleRange)styles.lastElement()).fontStyle == SWT.BOLD)) {
				int start = scanner.getStartOffset() + event.lineOffset;
				lastStyle = (StyleRange)styles.lastElement();
				// A font style of SWT.BOLD implies that the last style
				// represents a java keyword.
				if (lastStyle.start + lastStyle.length == start) {
					// Have the white space take on the style before it to 
					// minimize the number of style ranges created and the
					// number of font style changes during rendering.
					lastStyle.length += scanner.getLength();
				}
			} 
			token= scanner.nextToken();
		}
		event.styles = new StyleRange[styles.size()];
		styles.copyInto(event.styles);
	}

	public void parseBlockComments(String text) {
		if (scanner == null) return;
		blockComments = scanner.parseBlockComments(text);
	}

	/**
	 * λνԤʤ᥽å
	 */
	public void dispose() {
		disposeColors();
		scanner = null;
	}

	/**
	 * ѲǽʸΥɤȤʤʸ
	 * @return String[]
	 */
	public String[] getLangs() {
		return languages;
	}


}
