/* -----------------------------------------------------------------------
 SyntaxScanner.java
 Copyright (C) 2004  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2004/01/17
 *
 * File Name: SyntaxScanner.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 *
 */
package jp.co.jlight.stylers;

import java.util.*;
/**
 * ʸϴ
 */
public abstract class SyntaxScanner {

	protected String fDoc;
	protected int fPos;
	protected int fEnd;
	protected int fStartToken;

	/**
	 * Initialize the lookup table.
	 */
	abstract void initialize();

	/**
	 * Returns the ending location of the current token in the document.
	 */
	public final int getLength() {
		return fPos - fStartToken;
	}

	/**
	 * Returns the starting location of the current token in the document.
	 */
	public final int getStartOffset() {
		return fStartToken;
	}

	/**
	 * Returns the next lexical token in the document.
	 */
	public abstract int nextToken();

	/**
	 * Returns the BlockComments in the document.
	 */
	public abstract Vector parseBlockComments(String text);

	/**
	 * Returns next character.
	 */
	protected int read() {
		if (fPos <= fEnd) {
			return fDoc.charAt(fPos++);
		}
		return StylerKeys.EOF;
	}

	public void setRange(String text) {
		fDoc= text;
		fPos= 0;
		fEnd= fDoc.length() -1;
	}

	protected void unread(int c) {
		if (c != StylerKeys.EOF)
			fPos--;
	}
}
