/* -----------------------------------------------------------------------
 CommandUnit.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/11/09
 *
 * File Name: CommandUnit.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 *
 */
package jp.co.jlight.undo;

import org.eclipse.swt.custom.*;
/**
 * ޥɤκǾñ
 */
class CommandUnit {

	private TextUnit textUnit = null;
	private StyledText text = null;
	
	CommandUnit(StyledText text, TextUnit textUnit) {
		this.text = text;
		this.textUnit = textUnit;
	}
	
	void undoText() {
//		System.out.println("CommandUnit.undoText() Start");
		// ɲä줿ƥȤä
		if (textUnit.getAddString().length() > 0) {
			text.replaceTextRange(textUnit.getAddPoint().x,
						textUnit.getAddString().length(), "");
			text.setSelection(textUnit.getAddPoint().x);
		}
		// 줿ƥȤ
		if (textUnit.getDelString().length() > 0) {
			text.replaceTextRange(textUnit.getDelPoint().x,
						0, textUnit.getDelString());
			text.setSelection(textUnit.getDelPoint().x + textUnit.getDelPoint().y);
		}
//		System.out.println("CommandUnit.undoText() End");
	}
	
	void redoText() {
//		System.out.println("CommandUnit.redoText() Start");
		// ٥ƥȤ
		if (textUnit.getDelString().length() > 0) {
			text.replaceTextRange(textUnit.getDelPoint().x,
						textUnit.getDelString().length(), "");
			text.setSelection(textUnit.getDelPoint().x);
		}
		// ƥȤɲäʤ
		if (textUnit.getAddString().length() > 0) {
			text.replaceTextRange(textUnit.getAddPoint().x,
						0, textUnit.getAddString());
			text.setSelection(textUnit.getAddPoint().x + textUnit.getAddPoint().y);
		}
//		System.out.println("CommandUnit.redoText() End");
	}
	
	TextUnit getTextUnit() {
		return this.textUnit;
	}
	
	CommandUnit getCommandUnitReverse() {
		return new CommandUnit(text, textUnit.getReverse());
	}
}
