/* -----------------------------------------------------------------------
 TextListener.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/11/01
 *
 * File Name: TextListener.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 *
 */
package jp.co.jlight.undo;

import org.eclipse.swt.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
/**
 * 
 */
public class TextListener implements VerifyListener,
						ModifyListener, VerifyKeyListener {
	
	private CommandStack history;
	private int caretPos = 0;
	private int strCount = 0;
	private boolean selected = false;
	private boolean deleted = false;
	
	private String selString = "";
	private char prevChar;
	private char nextChar;
	
	private Point selPoint = null;
	private StyledText text = null;
	
	private boolean recHistory = false;


	public TextListener(CommandStack history, StyledText text) {
		this.history = history;
		this.text = text;
	}

	public TextListener(CommandStack history, boolean record, StyledText text) {
		this(history, text);
		this.recHistory = record;
	}

	public void verifyText(VerifyEvent event) {
		if (!recHistory) return;
		strCount = text.getCharCount();
		caretPos = text.getCaretOffset();
	}
	
	public void modifyText(ModifyEvent event) {
		if (!recHistory) return;
		
		int pos = 0;
		int cnt = 0;
		int num = 0;
		TextUnit textUnit = new TextUnit();

		pos = text.getCaretOffset();
		cnt = text.getCharCount();
		
		if (deleted == true && selected == false) {
			// ñʤ1ʸ
			if (caretPos == pos) {
				textUnit.setDelString(new Character(nextChar).toString());
			} else {
				textUnit.setDelString(new Character(prevChar).toString());
			}
			textUnit.setDelPoint(new Point(pos, 1));
			
		} else if (deleted == true && selected == true) {
			// 򤵤ʸ󤬺줿
			textUnit.setDelString(selString);
			if (selPoint != null) {
				textUnit.setDelPoint(selPoint);
			}
			
		} else if (deleted == false && selected == false) {
			// ñʤʸorʸ
			textUnit.setAddString(text.getTextRange(caretPos, pos - caretPos));
			textUnit.setAddPoint(new Point(caretPos, pos - caretPos));

		} else if (deleted == false && selected == true) {
			// 򤵤ʸ󤬺졢ʸɲä줿
			textUnit.setDelString(selString);
			textUnit.setDelPoint(selPoint);
			textUnit.setAddString(text.getTextRange(selPoint.x, pos - selPoint.x));
			textUnit.setAddPoint(new Point(selPoint.x, pos - selPoint.x));
		}

		if (textUnit.getAddPoint().y > 0 || textUnit.getDelPoint().y > 0) {
			addHistory(textUnit);
		}

	}
	
	private void addHistory(TextUnit textUnit) {
		CommandUnit cmdUnit = new CommandUnit(text, textUnit);
		history.append(cmdUnit);
	}
	
	public void verifyKey(VerifyEvent event) {
		if (!recHistory) return;
		
		prevChar = '\u0000';
		nextChar = '\u0000';
		selString = "";
		selected = false;
		deleted = false;
		selPoint = null;
		
		if (text.getSelectionCount() > 0) {
			selected = true;
			selString = text.getSelectionText();
			
			selPoint = text.getSelectionRange();
//			System.out.println("X -> " + selPoint.x);
//			System.out.println("Y -> " + selPoint.y);
						
			if (event.keyCode == SWT.DEL || event.keyCode == SWT.BS) {
				deleted = true;
				return;
			}
		}
		if (text.getText().length() > 0 &&
		    (event.keyCode == SWT.DEL || event.keyCode == SWT.BS)) {
			deleted = true;
			if (event.keyCode == SWT.DEL && text.getCaretOffset() < text.getCharCount()) {
				if (text.getCaretOffset() == 0) {
					nextChar = text.getText(0, 0).charAt(0);
				} else {
					nextChar = text.getText(text.getCaretOffset(), text.getCaretOffset() + 1).charAt(0);
				}
//				System.out.print("DEL Key");

			} else if (event.keyCode == SWT.BS && text.getCaretOffset() > 0) {
				if (text.getCaretOffset() == text.getCharCount()) {
					prevChar = text.getText(text.getCharCount()-1, text.getCharCount()-1).charAt(0);
				} else {
					prevChar = text.getText(text.getCaretOffset() - 1, text.getCaretOffset()).charAt(0);
				}
//				System.out.print("BS Key");

			}
		}
	}
	
	public void setRecordHistory(boolean record) {
		this.recHistory = record;
	}
	
	public boolean getRecordHistory() {
		return this.recHistory;
	}
}
