/* -----------------------------------------------------------------------
 Resources.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/02/25
 *
 * File Name: Resources.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 * 
 */
package jp.co.jlight;

import java.util.ResourceBundle;
/**
 * ץꥱѤ꥽륯饹
 */
public class Resources {
	
	private static ResourceBundle resources = ResourceBundle.getBundle("resources.jlighteditor");
	
	/**
	 * ᥤ󥿥ȥ
	 * @return String
	 */
	public String getTitle() {
		return resources.getString("MainTitle");
	}
	/**
	 * File˥塼ʸ
	 * @return String
	 */
	public String getMenuFile() {
		return resources.getString("MenuItem.File");
	}
	/**
	 * Edit˥塼ʸ
	 * @return String
	 */
	public String getMenuEdit() {
		return resources.getString("MenuItem.Edit");
	}
	/**
	 * Setting˥塼ʸ
	 * @return String
	 */
	public String getMenuSetting() {
		return resources.getString("MenuItem.Setting");
	}
	/**
	 * Help˥塼ʸ
	 * @return String
	 */
	public String getMenuHelp() {
		return resources.getString("MenuItem.Help");
	}


	/**
	 * File.New˥塼ʸ
	 * @return String
	 */
	public String getItemFileNew() {
		return resources.getString("MenuItem.File.New");
	}
	/**
	 * File.Open˥塼ʸ
	 * @return String
	 */
	public String getItemFileOpen() {
		return resources.getString("MenuItem.File.Open");
	}
	/**
	 * File.Close˥塼ʸ
	 * @return String
	 */
	public String getItemFileClose() {
		return resources.getString("MenuItem.File.Close");
	}
	/**
	 * File.Save˥塼ʸ
	 * @return String
	 */
	public String getItemFileSave() {
		return resources.getString("MenuItem.File.Save");
	}
	/**
	 * File.SaveAs˥塼ʸ
	 * @return String
	 */
	public String getItemFileSaveAs() {
		return resources.getString("MenuItem.File.SaveAs");
	}
	/**
	 * File.Exit˥塼ʸ
	 * @return String
	 */
	public String getItemFileExit() {
		return resources.getString("MenuItem.File.Exit");
	}


	/**
	 * Edit.Undo˥塼ʸ
	 * @return String
	 */
	public String getItemEditUndo() {
		return resources.getString("MenuItem.Edit.Undo");
	}
	/**
	 * Edit.Redo˥塼ʸ
	 * @return String
	 */
	public String getItemEditRedo() {
		return resources.getString("MenuItem.Edit.Redo");
	}
	/**
	 * Edit.Cut˥塼ʸ
	 * @return String
	 */
	public String getItemEditCut() {
		return resources.getString("MenuItem.Edit.Cut");
	}
	/**
	 * Edit.Copy˥塼ʸ
	 * @return String
	 */
	public String getItemEditCopy() {
		return resources.getString("MenuItem.Edit.Copy");
	}
	/**
	 * Edit.Paste˥塼ʸ
	 * @return String
	 */
	public String getItemEditPaste() {
		return resources.getString("MenuItem.Edit.Paste");
	}
	/**
	 * Edit.SelectAll˥塼ʸ
	 * @return String
	 */
	public String getItemEditSelectAll() {
		return resources.getString("MenuItem.Edit.SelectAll");
	}
	/**
	 * Edit.Search˥塼ʸ
	 * @return String
	 */
	public String getItemEditSearch() {
		return resources.getString("MenuItem.Edit.Search");
	}
	/**
	 * Edit.SearchNext˥塼ʸ
	 * @return String
	 */
	public String getItemEditSearchNext() {
		return resources.getString("MenuItem.Edit.SearchNext");
	}
	/**
	 * Edit.SearchPrev˥塼ʸ
	 * @return String
	 */
	public String getItemEditSearchPrev() {
		return resources.getString("MenuItem.Edit.SearchPrev");
	}


	/**
	 * Setting.Font˥塼ʸ
	 * @return String
	 */
	public String getItemFont() {
		return resources.getString("MenuItem.Setting.Font");
	}
	/**
	 * Setting.Encoding˥塼ʸ
	 * @return String
	 */
	public String getItemEncoding() {
		return resources.getString("MenuItem.Setting.Encoding");
	}
	/**
	 * Setting.Syntax˥塼ʸ
	 * @return String
	 */
	public String getItemSyntax() {
		return resources.getString("MenuItem.Setting.Syntax");
	}


	/**
	 * Help.About˥塼ʸ
	 * @return String
	 */
	public String getItemHelpAbout() {
		return resources.getString("MenuItem.Help.About");
	}


	/**
	 * եΥȥ
	 * @return String
	 */
	public String getFontDialogTitle() {
		return resources.getString("FontDialogTitle");
	}
	/**
	 * ե¸Υȥ
	 * @return String
	 */
	public String getFileSaveDialogTitle() {
		return resources.getString("FileSaveDialogTitle");
	}
	/**
	 * ե򳫤Υȥ
	 * @return String
	 */
	public String getFileOpenDialogTitle() {
		return resources.getString("FileOpenDialogTitle");
	}


	/**
	 * եݴɥΥȥ
	 * @return String
	 */
	public String getSaveFilesDialogTitle() {
		return resources.getString("SaveFilesDialogTitle");
	}
	/**
	 * եݴɥ٥ʸ
	 * @return String
	 */
	public String getSaveFilesDialogExpl() {
		return resources.getString("SaveFilesDialogExpl");
	}
	/**
	 * եݴɥܥʸ
	 * @return String
	 */
	public String getSaveFilesDialogSelectAll() {
		return resources.getString("SaveFilesDialogSelectAll");
	}
	/**
	 * եݴɥƤܥʸ
	 * @return String
	 */
	public String getSaveFilesDialogRemoveAll() {
		return resources.getString("SaveFilesDialogRemoveAll");
	}
	/**
	 * եݴɥOKܥʸ
	 * @return String
	 */
	public String getSaveFilesDialogOk() {
		return resources.getString("SaveFilesDialogOk");
	}
	/**
	 * եݴɥΥ󥻥ܥʸ
	 * @return String
	 */
	public String getSaveFilesDialogCancel() {
		return resources.getString("SaveFilesDialogCancel");
	}
	/**
	 * եݴɥΥե̾ʸ
	 * @return String
	 */
	public String getSaveFilesDialogFileName() {
		return resources.getString("SaveFilesDialogFileName");
	}
	/**
	 * եݴɥΥǥ쥯ȥʸ
	 * @return String
	 */
	public String getSaveFilesDialogDirectory() {
		return resources.getString("SaveFilesDialogDirectory");
	}
	/**
	 * եݴɥΥơʸ
	 * @return String
	 */
	public String getSaveFilesDialogStatus() {
		return resources.getString("SaveFilesDialogStatus");
	}


	/**
	 * /ִΥȥ
	 * @return String
	 */
	public String getSearchDialogTitle() {
		return resources.getString("SearchDialogTitle");
	}
	/**
	 * /ִθ٥ʸ
	 * @return String
	 */
	public String getSearchDialogSearchLabel() {
		return resources.getString("SearchDialogSearchLabel");
	}
	/**
	 * /ִִ٥ʸ
	 * @return String
	 */
	public String getSearchDialogReplaceLabel() {
		return resources.getString("SearchDialogReplaceLabel");
	}
	/**
	 * /ִʸ
	 * @return String
	 */
	public String getSearchDialogDirection() {
		return resources.getString("SearchDialogDirection");
	}
	/**
	 * /ִΥץʸ
	 * @return String
	 */
	public String getSearchDialogOptions() {
		return resources.getString("SearchDialogOptions");
	}
	/**
	 * /ִΤĤʸ
	 * @return String
	 */
	public String getSearchDialogForward() {
		return resources.getString("SearchDialogForward");
	}
	/**
	 * /ִΤɤʸ
	 * @return String
	 */
	public String getSearchDialogBackward() {
		return resources.getString("SearchDialogBackward");
	}
	/**
	 * /ִʸʸζʸ
	 * @return String
	 */
	public String getSearchDialogSensitive() {
		return resources.getString("SearchDialogSensitive");
	}
	/**
	 * /ִޤ֤ʸ
	 * @return String
	 */
	public String getSearchDialogAround() {
		return resources.getString("SearchDialogAround");
	}
	/**
	 * /ִִܥʸ
	 * @return String
	 */
	public String getSearchDialogReplace() {
		return resources.getString("SearchDialogReplace");
	}
	/**
	 * /ִִܥʸ
	 * @return String
	 */
	public String getSearchDialogReplaceAll() {
		return resources.getString("SearchDialogReplaceAll");
	}
	/**
	 * /ִθܥʸ
	 * @return String
	 */
	public String getSearchDialogSearch() {
		return resources.getString("SearchDialogSearch");
	}
	/**
	 * /ִĤܥʸ
	 * @return String
	 */
	public String getSearchDialogClose() {
		return resources.getString("SearchDialogClose");
	}
}
