/* -----------------------------------------------------------------------
 SyntaxSet.java
 Copyright (C) 2004  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2004/01/17
 *
 * File Name: SyntaxSet.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 *
 */
package jp.co.jlight.stylers;

import java.util.*;
/**
 * ѤǤ빽ʸ
 */
public class SyntaxSet {

	private ArrayList al;
	private static final String[] langs = {
		"Non",
		"Java"
	};
	private int defaultSyntaxID = 0;

	private String defaultSyntax = ResourceBundle.getBundle("resources.Styler").getString("default");

	/**
	 * SyntaxSet饹󥹥ȥ饯
	 */
	public SyntaxSet() {
		al = new ArrayList();
		createSyntaxSet();
	}

	private void createSyntaxSet() {
		String dispName = "";
		boolean find = false;
		for (int i = 0; i < langs.length; i++) {
			dispName = langs[i];
			if (dispName.toUpperCase().equals(defaultSyntax.toUpperCase())) {
				dispName = langs[i] + " (Default)";
				defaultSyntaxID = i;
				find = true;
			}
			al.add(new Syntax(i, dispName, langs[i].toUpperCase()));
		}
		if (!find) {
			Syntax syntax = (Syntax)(al.get(0));
			syntax.dispName = new String(syntax.dispName) + " (Default)";
			defaultSyntax = langs[0];
		}
	}

	/**
	 * ǥեȥ󥿥å
	 * @return String
	 */
	public String getDefaultSyntax() {
		return defaultSyntax;
	}

	public int getDefaultSyntaxID() {
		return defaultSyntaxID;
	}

	/**
	 * Ϥʸ󤬽ǤȰפ뤫ɤ
	 * @param syntax
	 * @return
	 */
	public boolean checkSyntax(String syntax) {
		Iterator it = al.iterator();
		while (it.hasNext()) {
			if (((Syntax)it.next()).getRealSyntax().equals(syntax)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * Ǥ빽ʸο
	 * @return int
	 */
	public int getCount() {
		return al.size();
	}

	/**
	 * id˴Ϣդ줿ʸ̾
	 * @param id
	 * @return String
	 */
	public String getRealSyntaxName(int id) {
		if (id < 0 | id > (getCount() - 1)) return "";
		Syntax syntax = (Syntax)(al.get(id));
		return syntax.getRealSyntax();
	}

	/**
	 * id˴Ϣդ줿ʸ̾(˥塼ɽ)
	 * @param id
	 * @return String
	 */
	public String getDispSyntaxName(int id) {
		if (id < 0 | id > (getCount() - 1)) return "";
		Syntax syntax = (Syntax)(al.get(id));
		return syntax.getDispSyntax();
	}


	class Syntax {
		private int id;
		private String dispName;
		private String realName;

		/**
		 * Syntax饹󥹥ȥ饯
		 * @param id
		 * @param displayName
		 * @param realName
		 */
		public Syntax(int id, String displayName, String realName) {
			this.id = id;
			this.dispName = displayName;
			this.realName = realName;
		}

		/**
		 * @return int
		 */
		public int getId() {
			return id;
		}
		/**
		 * @return String
		 */
		public String getDispSyntax() {
			return dispName;
		}
		/**
		 * @return String
		 */
		public String getRealSyntax() {
			return realName;
		}
	}

}
