/**
JMdRdfToolsGUI
Copyright (C) 2001  Shinichi Hayashi

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package jp.or.fsinet.hayashi.rdf.jmdrdftools.gui;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/**
 * ^Cg:  JMdRdfTools
 * :    JMdRdfGUI[eBeBłB
 * 쌠:   Copyright (c) 2001
 * Ж:
 * @author Shinichi Hayashi
 * @version 1.0
 */

public class DlgFilename extends JDialog {
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel4 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel5 = new JPanel();
    JLabel jLabel1 = new JLabel();
    String[] data={"--ȉI--","܂","܂܂Ȃ","v","ŊJn","ŏI","ŊJnȂ","ŏIȂ"};
    JComboBox jComboBox1 = new JComboBox(data);
    JTextField jtf_filename = new JTextField();
    JPanel jPanel6 = new JPanel();
    JButton jButton1 = new JButton();
    JButton jButton2 = new JButton();

    private boolean resultOK=false;
    JOptionPane jOptionPane1 = new JOptionPane();
    private final String[] retType={""
        ,"match","notMatch","equals"
        ,"startsWith","endsWith"
        ,"notStartsWith","notEndsWith"};

    public DlgFilename(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            jbInit();
            pack();
        }
        catch(Exception ex) {
            ex.printStackTrace();
        }
    }

    public DlgFilename() {
        this(null, "", false);
    }
    void jbInit() throws Exception {
        panel1.setLayout(borderLayout1);
        jPanel1.setLayout(borderLayout2);
        jPanel4.setLayout(gridLayout1);
        jPanel4.setToolTipText("");
        gridLayout1.setRows(2);
        jLabel1.setText("t@C");
        jtf_filename.setColumns(15);
        jButton1.setText("OK");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jButton1_actionPerformed(e);
            }
        });
        jButton2.setText("LZ");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jButton2_actionPerformed(e);
            }
        });
        getContentPane().add(panel1);
        panel1.add(jPanel1, BorderLayout.CENTER);
        jPanel1.add(jPanel4, BorderLayout.CENTER);
        jPanel4.add(jPanel5, null);
        jPanel5.add(jLabel1, null);
        jPanel5.add(jtf_filename, null);
        jPanel5.add(jComboBox1, null);
        jPanel4.add(jPanel6, null);
        jPanel6.add(jButton1, null);
        jPanel6.add(jButton2, null);
        panel1.add(jPanel2, BorderLayout.NORTH);
    }

    void jButton1_actionPerformed(ActionEvent e) {
        if (jtf_filename.getText().length()<1){
            jOptionPane1.showMessageDialog(
                this.getContentPane(),
                "t@Cw肵ĂB",
                "G[",
                jOptionPane1.ERROR_MESSAGE);
            jtf_filename.requestFocus();
            return;
        }
        if (jComboBox1.getSelectedIndex()<1){
            jOptionPane1.showMessageDialog(
                this.getContentPane(),
                "^CvIĂB",
                "G[",
                jOptionPane1.ERROR_MESSAGE);
            jComboBox1.requestFocus();
            return;
        }
        resultOK=true;
        dispose();
    }

    void jButton2_actionPerformed(ActionEvent e) {
        dispose();
    }

    public boolean isOK() {
        return resultOK;
    }

    public void setFilename(String str) {
        jtf_filename.setText(str);
    }

    public void setType(int idx) {
        if (idx<1 || idx>7) idx=0;
        jComboBox1.setSelectedIndex(idx);
    }

    public String getFilename() {
        return jtf_filename.getText();
    }

    public String getType() {
        int idx=jComboBox1.getSelectedIndex();
        if (idx<1 || idx>7) return "";
        return retType[idx];
    }

}